/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.GifEncoder;
import ij.io.ImageWriter;
import ij.io.JpegEncoder;
import ij.io.SaveDialog;
import ij.io.TextEncoder;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileSaver {
    private static String defaultDirectory = null;
    private ImagePlus imp;
    private FileInfo fi;
    private String name;
    private String directory;

    public FileSaver(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.fi = imagePlus.getFileInfo();
    }

    public boolean save() {
        return this.saveAsTiff();
    }

    String getPath(String string, String string2) {
        this.name = this.imp.getTitle();
        SaveDialog saveDialog = new SaveDialog("Save as " + string, this.name, string2);
        this.name = saveDialog.getFileName();
        if (this.name == null) {
            return null;
        }
        this.directory = saveDialog.getDirectory();
        this.imp.startTiming();
        String string3 = this.directory + this.name;
        return string3;
    }

    public boolean saveAsTiff() {
        String string = this.getPath("TIFF", ".tif");
        if (string == null) {
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            return this.saveAsTiff(string);
        }
        return this.saveAsTiffStack(string);
    }

    public boolean saveAsTiff(String string) {
        this.fi.nImages = 1;
        this.fi.description = this.getDescriptionString();
        try {
            TiffEncoder tiffEncoder = new TiffEncoder(this.fi);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            tiffEncoder.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    public boolean saveAsTiffStack(String string) {
        if (this.fi.nImages == 1) {
            IJ.write("This is not a stack");
            return false;
        }
        this.fi.description = this.getDescriptionString();
        try {
            TiffEncoder tiffEncoder = new TiffEncoder(this.fi);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            tiffEncoder.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    public boolean saveAsZip() {
        String string = this.getPath("TIFF/ZIP", ".zip");
        if (string == null) {
            return false;
        }
        return this.saveAsZip(string);
    }

    public boolean saveAsZip(String string) {
        if (!string.endsWith(".zip")) {
            string = string + ".zip";
        }
        if (this.name == null) {
            this.name = this.imp.getTitle();
        }
        if (this.name.endsWith(".zip")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        if (!this.name.endsWith(".tif")) {
            this.name = this.name + ".tif";
        }
        this.fi.description = this.getDescriptionString();
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(zipOutputStream));
            zipOutputStream.putNextEntry(new ZipEntry(this.name));
            TiffEncoder tiffEncoder = new TiffEncoder(this.fi);
            tiffEncoder.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    public static boolean okForGif(ImagePlus imagePlus) {
        int n = imagePlus.getType();
        if (n == 4 || n == 1 || n == 2) {
            IJ.error("To save as Gif, the image must be \"8-bit\" or \"8-bit Color\".");
            return false;
        }
        return true;
    }

    public boolean saveAsGif() {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        String string = this.getPath("GIF", ".gif");
        if (string == null) {
            return false;
        }
        return this.saveAsGif(string);
    }

    public boolean saveAsGif(String string) {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        try {
            byte[] byArray = (byte[])this.imp.getProcessor().getPixels();
            GifEncoder gifEncoder = new GifEncoder(this.fi.width, this.fi.height, byArray, this.fi.reds, this.fi.greens, this.fi.blues);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            gifEncoder.write(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(this.fi, 3);
        return true;
    }

    public static boolean okForJpeg(ImagePlus imagePlus) {
        return true;
    }

    public boolean saveAsJpeg() {
        String string = this.getPath("JPEG", ".jpg");
        if (string == null) {
            return false;
        }
        return this.saveAsJpeg(string);
    }

    public boolean saveAsJpeg(String string) {
        Object object = null;
        if (IJ.isJava2()) {
            WindowManager.setTempCurrentImage(this.imp);
            object = IJ.runPlugIn("ij.plugin.JpegWriter", string);
            WindowManager.setTempCurrentImage(null);
        }
        if (object == null) {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
                JpegEncoder jpegEncoder = new JpegEncoder(this.imp.getImage(), JpegEncoder.getQuality(), bufferedOutputStream);
                jpegEncoder.Compress();
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                this.showErrorMessage(iOException);
                return false;
            }
        }
        if (this.imp.getType() != 1 && this.imp.getType() != 2) {
            this.updateImp(this.fi, 3);
        }
        return true;
    }

    public boolean saveAsRaw() {
        String string = this.getPath("Raw", ".raw");
        if (string == null) {
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            return this.saveAsRaw(string);
        }
        return this.saveAsRawStack(string);
    }

    public boolean saveAsRaw(String string) {
        this.fi.nImages = 1;
        try {
            ImageWriter imageWriter = new ImageWriter(this.fi);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            imageWriter.write(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(this.fi, 1);
        return true;
    }

    public boolean saveAsRawStack(String string) {
        if (this.fi.nImages == 1) {
            IJ.write("This is not a stack");
            return false;
        }
        try {
            ImageWriter imageWriter = new ImageWriter(this.fi);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            imageWriter.write(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(this.fi, 1);
        return true;
    }

    public boolean saveAsText() {
        String string = this.getPath("Text", ".txt");
        if (string == null) {
            return false;
        }
        return this.saveAsText(string);
    }

    public boolean saveAsText(String string) {
        try {
            Calibration calibration = this.imp.getCalibration();
            int n = Analyzer.getPrecision();
            TextEncoder textEncoder = new TextEncoder(this.imp.getProcessor(), calibration, n);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            textEncoder.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        return true;
    }

    public boolean saveAsLut() {
        if (this.imp.getType() == 4) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        String string = this.getPath("LUT", ".lut");
        if (string == null) {
            return false;
        }
        return this.saveAsLut(string);
    }

    public boolean saveAsLut(String string) {
        LookUpTable lookUpTable = this.imp.createLut();
        int n = lookUpTable.getMapSize();
        if (n == 0) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        if (n < 256) {
            IJ.error("Cannot save LUTs with less than 256 entries.");
            return false;
        }
        byte[] byArray = lookUpTable.getReds();
        byte[] byArray2 = lookUpTable.getGreens();
        byte[] byArray3 = lookUpTable.getBlues();
        byte[] byArray4 = new byte[768];
        int n2 = 0;
        while (n2 < 256) {
            byArray4[n2] = byArray[n2];
            byArray4[n2 + 256] = byArray2[n2];
            byArray4[n2 + 512] = byArray3[n2];
            ++n2;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.width = 768;
        fileInfo.height = 1;
        fileInfo.pixels = byArray4;
        try {
            ImageWriter imageWriter = new ImageWriter(fileInfo);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            imageWriter.write(fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        return true;
    }

    private void updateImp(FileInfo fileInfo, int n) {
        this.imp.changes = false;
        if (this.name != null) {
            fileInfo.fileFormat = n;
            fileInfo.fileName = this.name;
            fileInfo.directory = this.directory;
            if (n == 2) {
                fileInfo.offset = 768;
            }
            fileInfo.description = null;
            this.imp.setTitle(this.name);
            this.imp.setFileInfo(fileInfo);
        }
    }

    void showErrorMessage(IOException iOException) {
        IJ.error("An error occured writing the file.\n \n" + iOException);
    }

    String getDescriptionString() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ImageJ=1.29x\n");
        if (this.fi.nImages > 1) {
            stringBuffer.append("images=" + this.fi.nImages + "\n");
        }
        if (this.fi.unit != null) {
            stringBuffer.append("unit=" + this.fi.unit + "\n");
        }
        if (this.fi.valueUnit != null) {
            stringBuffer.append("cf=" + this.fi.calibrationFunction + "\n");
            if (this.fi.coefficients != null) {
                int n = 0;
                while (n < this.fi.coefficients.length) {
                    stringBuffer.append("c" + n + "=" + this.fi.coefficients[n] + "\n");
                    ++n;
                }
            }
            stringBuffer.append("vunit=" + this.fi.valueUnit + "\n");
        }
        if (this.fi.nImages > 1) {
            if (this.fi.pixelDepth != 0.0 && this.fi.pixelDepth != 1.0) {
                stringBuffer.append("spacing=" + this.fi.pixelDepth + "\n");
            }
            if (this.fi.frameInterval != 0.0) {
                double d = 1.0 / this.fi.frameInterval;
                if ((double)((int)d) == d) {
                    stringBuffer.append("fps=" + (int)d + "\n");
                } else {
                    stringBuffer.append("fps=" + d + "\n");
                }
            }
        }
        ImageProcessor imageProcessor = this.imp.getProcessor();
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        int n = this.imp.getType();
        boolean bl2 = bl = !(n != 0 && n != 3 || d == 0.0 && d2 == 255.0);
        if (bl || n == 1 || n == 2) {
            stringBuffer.append("min=" + d + "\n");
            stringBuffer.append("max=" + d2 + "\n");
        }
        Calibration calibration = this.imp.getCalibration();
        if (calibration.xOrigin != 0.0) {
            stringBuffer.append("xorigin=" + calibration.xOrigin + "\n");
        }
        if (calibration.yOrigin != 0.0) {
            stringBuffer.append("yorigin=" + calibration.yOrigin + "\n");
        }
        if (calibration.zOrigin != 0.0) {
            stringBuffer.append("zorigin=" + calibration.zOrigin + "\n");
        }
        if (calibration.info != null && calibration.info.length() <= 64 && calibration.info.indexOf(61) == -1 && calibration.info.indexOf(10) == -1) {
            stringBuffer.append("info=" + calibration.info + "\n");
        }
        stringBuffer.append('\u0000');
        return new String(stringBuffer);
    }
}

