/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.gui.GenericDialog;

public class CurveFitter {
    public static final int STRAIGHT_LINE = 0;
    public static final int POLY2 = 1;
    public static final int POLY3 = 2;
    public static final int POLY4 = 3;
    public static final int EXPONENTIAL = 4;
    public static final int POWER = 5;
    public static final int LOG = 6;
    public static final int RODBARD = 7;
    public static final int GAMMA_VARIATE = 8;
    public static final int IterFactor = 500;
    public static final String[] fitList = new String[]{"Straight Line", "2nd Degree Polynomial", "3rd Degree Polynomial", "4th Degree Polynomial", "Exponential", "Power", "log", "Rodbard", "Gamma Variate"};
    public static final String[] fList = new String[]{"y = a+bx", "y = a+bx+cx^2", "y = a+bx+cx^2+dx^3", "y = a+bx+cx^2+dx^3+ex^4", "y = a*exp(bx)", "y = ax^b", "y = a*ln(bx)", "y = c*((a-x)/(x-d))^(1/b)", "y = a*(x-b)^c*exp(-(x-b)/d)"};
    private static final double alpha = -1.0;
    private static final double beta = 0.5;
    private static final double gamma = 2.0;
    private static final double root2 = 1.414214;
    private int fit;
    private double[] xData;
    private double[] yData;
    private int numPoints;
    private int numParams;
    private int numVertices;
    private int worst;
    private int nextWorst;
    private int best;
    private double[][] simp;
    private double[] next;
    private int numIter;
    private int maxIter;
    private int restarts;
    private double maxError;

    public CurveFitter(double[] dArray, double[] dArray2) {
        this.xData = dArray;
        this.yData = dArray2;
        this.numPoints = dArray.length;
    }

    public void doFit(int n) {
        this.doFit(n, false);
    }

    public void doFit(int n, boolean bl) {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("Invalid fit type");
        }
        this.fit = n;
        this.initialize();
        if (bl) {
            this.settingsDialog();
        }
        this.restart(0);
        this.numIter = 0;
        boolean bl2 = false;
        double[] dArray = new double[this.numParams];
        while (!bl2) {
            ++this.numIter;
            int n2 = 0;
            while (n2 < this.numParams) {
                dArray[n2] = 0.0;
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.numVertices) {
                if (n3 != this.worst) {
                    int n4 = 0;
                    while (n4 < this.numParams) {
                        int n5 = n4;
                        dArray[n5] = dArray[n5] + this.simp[n3][n4];
                        ++n4;
                    }
                }
                ++n3;
            }
            int n6 = 0;
            while (n6 < this.numParams) {
                int n7 = n6;
                dArray[n7] = dArray[n7] / (double)this.numParams;
                this.next[n6] = dArray[n6] + -1.0 * (this.simp[this.worst][n6] - dArray[n6]);
                ++n6;
            }
            this.sumResiduals(this.next);
            if (this.next[this.numParams] <= this.simp[this.best][this.numParams]) {
                this.newVertex();
                int n8 = 0;
                while (n8 < this.numParams) {
                    this.next[n8] = dArray[n8] + 2.0 * (this.simp[this.worst][n8] - dArray[n8]);
                    ++n8;
                }
                this.sumResiduals(this.next);
                if (this.next[this.numParams] <= this.simp[this.worst][this.numParams]) {
                    this.newVertex();
                }
            } else if (this.next[this.numParams] <= this.simp[this.nextWorst][this.numParams]) {
                this.newVertex();
            } else {
                int n9 = 0;
                while (n9 < this.numParams) {
                    this.next[n9] = dArray[n9] + 0.5 * (this.simp[this.worst][n9] - dArray[n9]);
                    ++n9;
                }
                this.sumResiduals(this.next);
                if (this.next[this.numParams] <= this.simp[this.nextWorst][this.numParams]) {
                    this.newVertex();
                } else {
                    int n10 = 0;
                    while (n10 < this.numVertices) {
                        if (n10 != this.best) {
                            int n11 = 0;
                            while (n11 < this.numVertices) {
                                this.simp[n10][n11] = 0.5 * (this.simp[n10][n11] + this.simp[this.best][n11]);
                                ++n11;
                            }
                            this.sumResiduals(this.simp[n10]);
                        }
                        ++n10;
                    }
                }
            }
            this.order();
            double d = 2.0 * Math.abs(this.simp[this.best][this.numParams] - this.simp[this.worst][this.numParams]) / (Math.abs(this.simp[this.best][this.numParams]) + Math.abs(this.simp[this.worst][this.numParams]) + 1.0E-10);
            if (this.numIter >= this.maxIter) {
                bl2 = true;
                continue;
            }
            if (!(d < this.maxError)) continue;
            --this.restarts;
            if (this.restarts < 0) {
                bl2 = true;
                continue;
            }
            this.restart(this.best);
        }
    }

    void initialize() {
        this.numParams = this.getNumParams();
        this.numVertices = this.numParams + 1;
        this.simp = new double[this.numVertices][this.numVertices];
        this.next = new double[this.numVertices];
        double d = this.xData[0];
        double d2 = this.yData[0];
        double d3 = this.xData[this.numPoints - 1];
        double d4 = this.yData[this.numPoints - 1];
        double d5 = (d + d3) / 2.0;
        double d6 = (d2 + d4) / 2.0;
        double d7 = d3 - d != 0.0 ? (d4 - d2) / (d3 - d) : 1.0;
        double d8 = d2 - d7 * d;
        this.maxIter = 500 * this.numParams * this.numParams;
        this.restarts = 1;
        this.maxError = 1.0E-9;
        switch (this.fit) {
            case 0: {
                this.simp[0][0] = d8;
                this.simp[0][1] = d7;
                break;
            }
            case 1: {
                this.simp[0][0] = d8;
                this.simp[0][1] = d7;
                this.simp[0][2] = 0.0;
                break;
            }
            case 2: {
                this.simp[0][0] = d8;
                this.simp[0][1] = d7;
                this.simp[0][2] = 0.0;
                this.simp[0][3] = 0.0;
                break;
            }
            case 3: {
                this.simp[0][0] = d8;
                this.simp[0][1] = d7;
                this.simp[0][2] = 0.0;
                this.simp[0][3] = 0.0;
                this.simp[0][4] = 0.0;
                break;
            }
            case 4: {
                this.simp[0][0] = 0.1;
                this.simp[0][1] = 0.01;
                break;
            }
            case 5: {
                this.simp[0][0] = 0.0;
                this.simp[0][1] = 1.0;
                break;
            }
            case 6: {
                this.simp[0][0] = 0.5;
                this.simp[0][1] = 0.05;
                break;
            }
            case 7: {
                this.simp[0][0] = d2;
                this.simp[0][1] = 1.0;
                this.simp[0][2] = d5;
                this.simp[0][3] = d4;
                break;
            }
            case 8: {
                this.simp[0][0] = d;
                double d9 = this.xData[CurveFitter.getMax(this.yData)] - d;
                this.simp[0][2] = Math.sqrt(d9);
                this.simp[0][3] = Math.sqrt(d9);
                this.simp[0][1] = this.yData[CurveFitter.getMax(this.yData)] / (Math.pow(d9, this.simp[0][2]) * Math.exp(-d9 / this.simp[0][3]));
            }
        }
    }

    private void settingsDialog() {
        GenericDialog genericDialog = new GenericDialog("Simplex Fitting Options", IJ.getInstance());
        genericDialog.addMessage("Function name: " + fitList[this.fit] + "\n" + "Formula: " + fList[this.fit]);
        char c = 'a';
        int n = 0;
        while (n < this.numParams) {
            genericDialog.addNumericField("Initial " + new Character(c).toString() + ":", this.simp[0][n], 2);
            c = (char)(c + '\u0001');
            ++n;
        }
        genericDialog.addNumericField("Maximum iterations:", this.maxIter, 0);
        genericDialog.addNumericField("Number of restarts:", this.restarts, 0);
        genericDialog.addNumericField("Error tolerance [1*10^(-x)]:", -(Math.log(this.maxError) / Math.log(10.0)), 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled() || genericDialog.invalidNumber()) {
            IJ.error("Parameter setting canceled.\nUsing default parameters.");
        }
        int n2 = 0;
        while (n2 < this.numParams) {
            this.simp[0][n2] = genericDialog.getNextNumber();
            ++n2;
        }
        this.maxIter = (int)genericDialog.getNextNumber();
        this.restarts = (int)genericDialog.getNextNumber();
        this.maxError = Math.pow(10.0, -genericDialog.getNextNumber());
    }

    void restart(int n) {
        int n2 = 0;
        while (n2 < this.numParams) {
            this.simp[0][n2] = this.simp[n][n2];
            ++n2;
        }
        this.sumResiduals(this.simp[0]);
        double[] dArray = new double[this.numParams];
        int n3 = 0;
        while (n3 < this.numParams) {
            dArray[n3] = this.simp[0][n3] / 2.0;
            if (dArray[n3] == 0.0) {
                dArray[n3] = 0.01;
            }
            ++n3;
        }
        double[] dArray2 = new double[this.numParams];
        double[] dArray3 = new double[this.numParams];
        int n4 = 0;
        while (n4 < this.numParams) {
            dArray2[n4] = dArray[n4] * (Math.sqrt(this.numVertices) + (double)this.numParams - 1.0) / ((double)this.numParams * 1.414214);
            dArray3[n4] = dArray[n4] * (Math.sqrt(this.numVertices) - 1.0) / ((double)this.numParams * 1.414214);
            ++n4;
        }
        int n5 = 1;
        while (n5 < this.numVertices) {
            int n6 = 0;
            while (n6 < this.numParams) {
                this.simp[n5][n6] = this.simp[n5 - 1][n6] + dArray3[n6];
                ++n6;
            }
            this.simp[n5][n5 - 1] = this.simp[n5][n5 - 1] + dArray2[n5 - 1];
            this.sumResiduals(this.simp[n5]);
            ++n5;
        }
        this.best = 0;
        this.worst = 0;
        this.nextWorst = 0;
        this.order();
    }

    void showSimplex(int n) {
        IJ.write("" + n);
        int n2 = 0;
        while (n2 < this.numVertices) {
            String string = "";
            int n3 = 0;
            while (n3 < this.numVertices) {
                string = string + "  " + IJ.d2s(this.simp[n2][n3], 6);
                ++n3;
            }
            IJ.write(string);
            ++n2;
        }
    }

    public int getNumParams() {
        switch (this.fit) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 4;
            }
        }
        return 0;
    }

    public static double f(int n, double[] dArray, double d) {
        switch (n) {
            case 0: {
                return dArray[0] + dArray[1] * d;
            }
            case 1: {
                return dArray[0] + dArray[1] * d + dArray[2] * d * d;
            }
            case 2: {
                return dArray[0] + dArray[1] * d + dArray[2] * d * d + dArray[3] * d * d * d;
            }
            case 3: {
                return dArray[0] + dArray[1] * d + dArray[2] * d * d + dArray[3] * d * d * d + dArray[4] * d * d * d * d;
            }
            case 4: {
                return dArray[0] * Math.exp(dArray[1] * d);
            }
            case 5: {
                if (d == 0.0) {
                    return 0.0;
                }
                return dArray[0] * Math.exp(dArray[1] * Math.log(d));
            }
            case 6: {
                if (d == 0.0) {
                    d = 0.5;
                }
                return dArray[0] * Math.log(dArray[1] * d);
            }
            case 7: {
                double d2 = d == 0.0 ? 0.0 : Math.exp(Math.log(d / dArray[2]) * dArray[1]);
                double d3 = dArray[0] - dArray[3];
                return (d3 /= 1.0 + d2) + dArray[3];
            }
            case 8: {
                if (dArray[0] >= d) {
                    return 0.0;
                }
                if (dArray[1] <= 0.0) {
                    return -100000.0;
                }
                if (dArray[2] <= 0.0) {
                    return -100000.0;
                }
                if (dArray[3] <= 0.0) {
                    return -100000.0;
                }
                double d4 = Math.pow(d - dArray[0], dArray[2]);
                double d5 = Math.exp(-(d - dArray[0]) / dArray[3]);
                return dArray[1] * d4 * d5;
            }
        }
        return 0.0;
    }

    public double[] getParams() {
        this.order();
        return this.simp[this.best];
    }

    public double[] getResiduals() {
        double[] dArray = this.getParams();
        double[] dArray2 = new double[this.numPoints];
        int n = 0;
        while (n < this.numPoints) {
            dArray2[n] = this.yData[n] - CurveFitter.f(this.fit, dArray, this.xData[n]);
            ++n;
        }
        return dArray2;
    }

    public double getSumResidualsSqr() {
        double d = this.getParams()[this.getNumParams()];
        return d;
    }

    public double getSD() {
        double d = Math.sqrt(this.getSumResidualsSqr() / (double)this.numVertices);
        return d;
    }

    public double getFitGoodness() {
        double d = 0.0;
        int n = 0;
        while (n < this.numPoints) {
            d += this.yData[n];
            ++n;
        }
        double d2 = d / (double)this.numVertices;
        double d3 = 0.0;
        int n2 = this.numPoints - this.getNumParams();
        double d4 = 0.0;
        int n3 = 0;
        while (n3 < this.numPoints) {
            d3 += this.sqr(this.yData[n3] - d2);
            ++n3;
        }
        if (d3 > 0.0 && n2 != 0) {
            d4 = 1.0 - this.getSumResidualsSqr() / (double)n2 * ((double)this.numParams / d3);
        }
        return d4;
    }

    public String getResultString() {
        StringBuffer stringBuffer = new StringBuffer("\nNumber of iterations: " + this.getIterations() + "\nMaximum number of iterations: " + this.getMaxIterations() + "\nSum of residuals squared: " + this.getSumResidualsSqr() + "\nStandard deviation: " + this.getSD() + "\nGoodness of fit: " + this.getFitGoodness() + "\nParameters:");
        char c = 'a';
        double[] dArray = this.getParams();
        int n = 0;
        while (n < this.numParams) {
            stringBuffer.append("\n" + c + " = " + dArray[n]);
            c = (char)(c + '\u0001');
            ++n;
        }
        return stringBuffer.toString();
    }

    double sqr(double d) {
        return d * d;
    }

    void sumResiduals(double[] dArray) {
        dArray[this.numParams] = 0.0;
        int n = 0;
        while (n < this.numPoints) {
            dArray[this.numParams] = dArray[this.numParams] + this.sqr(CurveFitter.f(this.fit, dArray, this.xData[n]) - this.yData[n]);
            ++n;
        }
    }

    void newVertex() {
        int n = 0;
        while (n < this.numVertices) {
            this.simp[this.worst][n] = this.next[n];
            ++n;
        }
    }

    void order() {
        int n = 0;
        while (n < this.numVertices) {
            if (this.simp[n][this.numParams] < this.simp[this.best][this.numParams]) {
                this.best = n;
            }
            if (this.simp[n][this.numParams] > this.simp[this.worst][this.numParams]) {
                this.worst = n;
            }
            ++n;
        }
        this.nextWorst = this.best;
        int n2 = 0;
        while (n2 < this.numVertices) {
            if (n2 != this.worst && this.simp[n2][this.numParams] > this.simp[this.nextWorst][this.numParams]) {
                this.nextWorst = n2;
            }
            ++n2;
        }
    }

    public int getIterations() {
        return this.numIter;
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setMaxIterations(int n) {
        this.maxIter = n;
    }

    public int getRestarts() {
        return this.restarts;
    }

    public void setRestarts(int n) {
        this.restarts = n;
    }

    public static int getMax(double[] dArray) {
        double d = dArray[0];
        int n = 0;
        int n2 = 1;
        while (n2 < dArray.length) {
            if (d < dArray[n2]) {
                d = dArray[n2];
                n = n2;
            }
            ++n2;
        }
        return n;
    }
}

