/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.gui.GUI;
import ij.plugin.PlugIn;
import ij.plugin.PlugInExecuter;
import ij.plugin.frame.Editor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.OutputStream;
import sun.tools.javac.Main;

public class Compiler
implements PlugIn,
FilenameFilter {
    private static Main javac;
    private static ByteArrayOutputStream output;
    private static String dir;
    private static String name;
    private static Editor errors;
    static /* synthetic */ Class class$ij$plugin$Compiler;

    public void run(String string) {
        IJ.register(class$ij$plugin$Compiler == null ? (class$ij$plugin$Compiler = Compiler.class$("ij.plugin.Compiler")) : class$ij$plugin$Compiler);
        if (string.equals("edit")) {
            this.edit();
        } else {
            this.compileAndRun(string);
        }
    }

    void edit() {
        Editor editor;
        if (this.open("", "Open macro or plugin") && (editor = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "")) != null) {
            editor.open(dir, name);
        }
    }

    void compileAndRun(String string) {
        if (!this.isJavac()) {
            return;
        }
        if (!this.open(string, "Compile and Run Plugin...")) {
            return;
        }
        if (this.compile(dir + name)) {
            this.runPlugin(name);
        }
    }

    boolean isJavac() {
        try {
            if (javac == null) {
                output = new ByteArrayOutputStream(4096);
                javac = new Main((OutputStream)output, "javac");
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            IJ.error("This JVM does not include the javac compiler. Javac is\nincluded with the Windows, OS X and Linux versions of\nImageJ. Mac OS 9 users must install Apple's Java SDK.");
            return false;
        }
        return true;
    }

    boolean compile(String string) {
        boolean bl;
        IJ.showStatus("compiling: " + string);
        String string2 = System.getProperty("java.class.path");
        output.reset();
        boolean bl2 = javac.compile(new String[]{"-deprecation", "-classpath", string2, string});
        String string3 = output.toString();
        boolean bl3 = bl = !bl2 || this.areErrors(string3);
        if (bl) {
            this.showErrors(string3);
        } else {
            IJ.showStatus("done");
        }
        return bl2;
    }

    boolean areErrors(String string) {
        boolean bl;
        boolean bl2 = bl = string != null && string.length() > 0;
        if (bl && string.startsWith("Note: sun.tools.javac") && string.indexOf("error") == -1) {
            bl = false;
        }
        return bl;
    }

    void showErrors(String string) {
        if (errors == null || !errors.isVisible()) {
            errors = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        }
        if (errors != null) {
            errors.display("Errors", string);
        }
        IJ.showStatus("done (errors)");
    }

    boolean open(String string, String string2) {
        String string3;
        boolean bl;
        String string4;
        if (string.equals("")) {
            FileDialog fileDialog = new FileDialog((Frame)IJ.getInstance(), string2);
            if (dir != null) {
                fileDialog.setDirectory(dir);
            } else {
                String string5 = Menus.getPlugInsPath();
                if (string != null) {
                    fileDialog.setDirectory(string5);
                }
            }
            if (name != null) {
                fileDialog.setFile(name);
            }
            GUI.center(fileDialog);
            fileDialog.setFilenameFilter(this);
            fileDialog.show();
            string4 = fileDialog.getFile();
            bl = string4 != null;
            string3 = fileDialog.getDirectory();
            fileDialog.dispose();
            if (bl && !string4.endsWith(".java") && !string4.endsWith(".txt") && !string4.endsWith(".macro")) {
                IJ.error("File name must end with \".java\", \".macro\" or \".txt\".");
                bl = false;
            }
        } else {
            int n = string.lastIndexOf(47);
            if (n == -1) {
                n = string.lastIndexOf(92);
            }
            if (n > 0) {
                string3 = string.substring(0, n + 1);
                string4 = string.substring(n + 1);
            } else {
                string3 = "";
                string4 = string;
            }
            bl = true;
        }
        if (bl) {
            name = string4;
            dir = string3;
        }
        return bl;
    }

    public boolean accept(File file, String string) {
        return string.endsWith(".java") || string.endsWith(".macro") || string.endsWith(".txt");
    }

    void runPlugin(String string) {
        string = string.substring(0, string.length() - 5);
        new PlugInExecuter(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

