/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.GelAnalyzer;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class PlotsCanvas
extends ImageCanvas {
    public static final int MAX_PEAKS = 200;
    double[] actual = new double[]{428566.0, 351368.0, 233977.0, 99413.0, 60057.0, 31382.0, 14531.0, 7843.0, 2146.0, 752.0, 367.0};
    double[] measured = new double[200];
    Rectangle[] rect = new Rectangle[200];
    int counter;

    public PlotsCanvas(ImagePlus imagePlus) {
        super(imagePlus);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            return;
        }
        if (roi.getType() == 5) {
            Roi.setColor(Color.blue);
        } else {
            Roi.setColor(Color.yellow);
        }
        if (Toolbar.getToolId() != 8 || IJ.spaceBarDown()) {
            return;
        }
        ImageStatistics imageStatistics = this.imp.getStatistics();
        if (this.counter == 0) {
            IJ.setColumnHeadings(" \tArea");
        }
        double d = roi.getLength();
        String string = "";
        double d2 = Math.PI * 4 * ((double)imageStatistics.pixelCount / (d * d));
        if (d2 < 0.025) {
            string = " (error?)";
        }
        double d3 = (double)imageStatistics.pixelCount + d / 2.0;
        this.rect[this.counter] = roi.getBoundingRect();
        IJ.write(this.counter + 1 + "\t" + IJ.d2s(d3, 0) + string);
        this.measured[this.counter] = d3;
        if (this.counter < 200) {
            ++this.counter;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 5) {
            Undo.setup(1, this.imp);
            this.imp.getProcessor().snapshot();
            roi.drawPixels();
            this.imp.updateAndDraw();
            this.imp.killRoi();
        }
    }

    void reset() {
        this.counter = 0;
    }

    void labelPeaks() {
        this.imp.killRoi();
        double d = 0.0;
        int n = 0;
        while (n < this.counter) {
            d += this.measured[n];
            ++n;
        }
        ImageProcessor imageProcessor = this.imp.getProcessor();
        imageProcessor.setFont(new Font("SansSerif", 0, 9));
        int n2 = 0;
        while (n2 < this.counter) {
            Rectangle rectangle = this.rect[n2];
            String string = GelAnalyzer.labelWithPercentages ? IJ.d2s(this.measured[n2] / d * 100.0, 2) : IJ.d2s(this.measured[n2], 0);
            int n3 = imageProcessor.getStringWidth(string);
            int n4 = rectangle.x + rectangle.width / 2 - n3 / 2;
            int n5 = rectangle.y + rectangle.height * 3 / 4 + 9;
            int[] nArray = new int[n3];
            imageProcessor.getRow(n4, n5, nArray, n3);
            boolean bl = true;
            int n6 = 0;
            while (n6 < n3) {
                if (nArray[n6] != 255) {
                    bl = false;
                    break;
                }
                ++n6;
            }
            boolean bl2 = bl = bl && this.measured[n2] > 500.0;
            if (rectangle.height >= GelAnalyzer.plotHeight - 11) {
                bl = true;
            }
            if (!bl) {
                n5 = rectangle.y - 2;
            }
            imageProcessor.drawString(string, n4, n5);
            ++n2;
        }
        this.imp.updateAndDraw();
        this.displayPercentages();
        this.reset();
    }

    void displayPercentages() {
        IJ.setColumnHeadings(" \tarea\tpercent");
        double d = 0.0;
        int n = 0;
        while (n < this.counter) {
            d += this.measured[n];
            ++n;
        }
        if (IJ.debugMode && this.counter == this.actual.length) {
            this.debug();
            return;
        }
        int n2 = 0;
        while (n2 < this.counter) {
            double d2 = this.measured[n2] / d * 100.0;
            IJ.write(n2 + 1 + "\t" + IJ.d2s(this.measured[n2], 4) + "\t" + IJ.d2s(d2, 4));
            ++n2;
        }
    }

    void debug() {
        int n = 0;
        while (n < this.counter) {
            double d = this.actual[n] / this.actual[0] * 100.0;
            double d2 = this.measured[n] / this.measured[0] * 100.0;
            IJ.write(IJ.d2s(d, 4) + " " + IJ.d2s(d2, 4) + " " + IJ.d2s((d2 - d) / d2 * 100.0, 4));
            ++n;
        }
    }
}

