/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class StackEditor
implements PlugIn {
    String arg;
    ImagePlus imp;
    int nSlices;
    int width;
    int height;

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.nSlices = this.imp.getStackSize();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        if (string.equals("tostack")) {
            this.convertImagesToStack();
            return;
        }
        if (string.equals("add")) {
            this.addSlice();
            return;
        }
        if (this.nSlices < 2) {
            IJ.error("Stack requred");
            return;
        }
        if (string.equals("delete")) {
            this.deleteSlice();
        } else if (string.equals("toimages")) {
            this.convertStackToImages(this.imp);
        }
    }

    void addSlice() {
        if (!this.imp.lock()) {
            return;
        }
        ImageStack imageStack = this.imp.getStack();
        ImageProcessor imageProcessor = this.imp.getProcessor();
        int n = this.imp.getCurrentSlice();
        if (IJ.altKeyDown()) {
            --n;
        }
        imageStack.addSlice(null, imageProcessor.createProcessor(this.width, this.height), n);
        this.imp.setStack(null, imageStack);
        this.imp.setSlice(n + 1);
        this.imp.unlock();
    }

    void deleteSlice() {
        if (!this.imp.lock()) {
            return;
        }
        ImageStack imageStack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        imageStack.deleteSlice(n);
        if (imageStack.getSize() == 1) {
            this.imp.setProcessor(null, imageStack.getProcessor(1));
            new ImageWindow(this.imp);
        } else {
            this.imp.setStack(null, imageStack);
            if (n-- < 1) {
                n = 1;
            }
            this.imp.setSlice(n);
        }
        this.imp.unlock();
    }

    public void convertImagesToStack() {
        Object object;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error("No images are open.");
            return;
        }
        if (nArray.length < 2) {
            IJ.error("There must be at least two open images.");
            return;
        }
        ImagePlus[] imagePlusArray = new ImagePlus[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            imagePlusArray[n] = WindowManager.getImage(nArray[n]);
            if (imagePlusArray[n].getStackSize() > 1) {
                IJ.error("None of the open images can be a stack.");
                return;
            }
            ++n;
        }
        Calibration calibration = imagePlusArray[0].getCalibration();
        int n2 = 0;
        while (n2 < nArray.length - 1) {
            if (imagePlusArray[n2].getType() != imagePlusArray[n2 + 1].getType()) {
                IJ.error("All open images must be the same type.");
                return;
            }
            if (imagePlusArray[n2].getWidth() != imagePlusArray[n2 + 1].getWidth() || imagePlusArray[n2].getHeight() != imagePlusArray[n2 + 1].getHeight()) {
                IJ.error("All open images must be the same size.");
                return;
            }
            Calibration calibration2 = imagePlusArray[n2].getCalibration();
            if (!imagePlusArray[n2].getCalibration().equals(calibration)) {
                calibration = null;
            }
            ++n2;
        }
        int n3 = imagePlusArray[0].getWidth();
        int n4 = imagePlusArray[0].getHeight();
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        ImageStack imageStack = new ImageStack(n3, n4);
        int n5 = 0;
        while (n5 < nArray.length) {
            object = imagePlusArray[n5].getProcessor();
            if (((ImageProcessor)object).getMin() < d) {
                d = ((ImageProcessor)object).getMin();
            }
            if (((ImageProcessor)object).getMax() > d2) {
                d2 = ((ImageProcessor)object).getMax();
            }
            imageStack.addSlice(null, (ImageProcessor)object);
            imagePlusArray[n5].changes = false;
            imagePlusArray[n5].getWindow().close();
            ++n5;
        }
        object = new ImagePlus("Stack", imageStack);
        if (((ImagePlus)object).getType() == 1 || ((ImagePlus)object).getType() == 2) {
            ((ImagePlus)object).getProcessor().setMinAndMax(d, d2);
        }
        if (calibration != null) {
            ((ImagePlus)object).setCalibration(calibration);
        }
        ((ImagePlus)object).show();
    }

    public void convertStackToImages(ImagePlus imagePlus) {
        Object object;
        boolean bl;
        if (!imagePlus.lock()) {
            return;
        }
        ImageStack imageStack = imagePlus.getStack();
        int n = imageStack.getSize();
        if (n > 30 && !(bl = IJ.showMessageWithCancel("Convert to Images?", "Are you sure you want to convert this\nstack to " + n + " separate windows?"))) {
            imagePlus.unlock();
            return;
        }
        Calibration calibration = imagePlus.getCalibration();
        int n2 = 1;
        while (n2 <= n) {
            object = imageStack.getSliceLabel(n2);
            String string = object != null && !((String)object).equals("") ? object : this.getDigits(n2);
            ImagePlus imagePlus2 = new ImagePlus(string, imageStack.getProcessor(n2));
            imagePlus2.setCalibration(calibration);
            imagePlus2.show();
            ++n2;
        }
        imagePlus.changes = false;
        object = imagePlus.getWindow();
        if (object != null) {
            ((ImageWindow)object).close();
        }
        imagePlus.unlock();
    }

    String getDigits(int n) {
        String string = "00000000" + n;
        return string.substring(string.length() - 4, string.length());
    }
}

