/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.Cube;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.IndexColorModel;

public class MedianCut {
    static final int MAXCOLORS = 256;
    static final int HSIZE = 32768;
    private int[] hist;
    private int[] histPtr;
    private Cube[] list;
    private int[] pixels32;
    private int width;
    private int height;
    private IndexColorModel cm;

    public MedianCut(int[] nArray, int n, int n2) {
        this.pixels32 = nArray;
        this.width = n;
        this.height = n2;
        IJ.showProgress(0.3);
        IJ.showStatus("Building 32x32x32 RGB histogram");
        this.hist = new int[32768];
        int n3 = 0;
        while (n3 < n * n2) {
            int n4;
            int n5 = n4 = this.rgb(this.pixels32[n3]);
            this.hist[n5] = this.hist[n5] + 1;
            ++n3;
        }
    }

    public MedianCut(ColorProcessor colorProcessor) {
        this((int[])colorProcessor.getPixels(), colorProcessor.getWidth(), colorProcessor.getHeight());
    }

    int getColorCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < 32768) {
            if (this.hist[n2] > 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    Color getModalColor() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 32768) {
            if (this.hist[n3] > n) {
                n = this.hist[n3];
                n2 = n3;
            }
            ++n3;
        }
        return new Color(this.red(n2), this.green(n2), this.blue(n2));
    }

    private final int rgb(int n) {
        int n2 = (n & 0xF80000) >> 19;
        int n3 = (n & 0xF800) >> 6;
        int n4 = (n & 0xF8) << 7;
        return n4 | n3 | n2;
    }

    private final int red(int n) {
        return (n & 0x1F) << 3;
    }

    private final int green(int n) {
        return n >> 2 & 0xF8;
    }

    private final int blue(int n) {
        return n >> 7 & 0xF8;
    }

    public Image convert(int n) {
        ImageProcessor imageProcessor = this.convertToByte(n);
        return imageProcessor.createImage();
    }

    public ImageProcessor convertToByte(int n) {
        int n2 = 0;
        IJ.showStatus("Median cut");
        this.list = new Cube[256];
        this.histPtr = new int[32768];
        int n3 = 0;
        Cube cube = new Cube();
        int n4 = 0;
        int n5 = 0;
        while (n4 <= Short.MAX_VALUE) {
            if (this.hist[n4] != 0) {
                this.histPtr[n5++] = n4;
                cube.count += this.hist[n4];
            }
            ++n4;
        }
        cube.lower = 0;
        cube.upper = n5 - 1;
        cube.level = 0;
        this.Shrink(cube);
        this.list[n3++] = cube;
        while (n3 < n) {
            int n6 = 255;
            int n7 = -1;
            int n8 = 0;
            while (n8 <= n3 - 1) {
                if (this.list[n8].lower != this.list[n8].upper && this.list[n8].level < n6) {
                    n6 = this.list[n8].level;
                    n7 = n8;
                }
                ++n8;
            }
            if (n7 == -1) break;
            cube = this.list[n7];
            int n9 = cube.rmax - cube.rmin;
            int n10 = cube.gmax - cube.gmin;
            int n11 = cube.bmax - cube.bmin;
            if (n9 >= n10 && n9 >= n11) {
                n2 = 0;
            }
            if (n10 >= n9 && n10 >= n11) {
                n2 = 1;
            }
            if (n11 >= n9 && n11 >= n10) {
                n2 = 2;
            }
            this.reorderColors(this.histPtr, cube.lower, cube.upper, n2);
            this.quickSort(this.histPtr, cube.lower, cube.upper);
            this.restoreColorOrder(this.histPtr, cube.lower, cube.upper, n2);
            int n12 = 0;
            n4 = cube.lower;
            while (n4 <= cube.upper - 1) {
                if (n12 >= cube.count / 2) break;
                n5 = this.histPtr[n4];
                n12 += this.hist[n5];
                ++n4;
            }
            int n13 = n4;
            Cube cube2 = new Cube();
            cube2.lower = cube.lower;
            cube2.upper = n13 - 1;
            cube2.count = n12;
            cube2.level = cube.level + 1;
            this.Shrink(cube2);
            this.list[n7] = cube2;
            Cube cube3 = new Cube();
            cube3.lower = n13;
            cube3.upper = cube.upper;
            cube3.count = cube.count - n12;
            cube3.level = cube.level + 1;
            this.Shrink(cube3);
            this.list[n3++] = cube3;
            if (n3 % 15 != 0) continue;
            IJ.showProgress(0.3 + 0.6 * (double)n3 / (double)n);
        }
        IJ.showProgress(0.9);
        this.makeInverseMap(this.hist, n3);
        IJ.showProgress(0.95);
        return this.makeImage();
    }

    void Shrink(Cube cube) {
        int n = 255;
        int n2 = 0;
        int n3 = 255;
        int n4 = 0;
        int n5 = 255;
        int n6 = 0;
        int n7 = cube.lower;
        while (n7 <= cube.upper) {
            int n8 = this.histPtr[n7];
            int n9 = this.red(n8);
            int n10 = this.green(n8);
            int n11 = this.blue(n8);
            if (n9 > n2) {
                n2 = n9;
            }
            if (n9 < n) {
                n = n9;
            }
            if (n10 > n4) {
                n4 = n10;
            }
            if (n10 < n3) {
                n3 = n10;
            }
            if (n11 > n6) {
                n6 = n11;
            }
            if (n11 < n5) {
                n5 = n11;
            }
            ++n7;
        }
        cube.rmin = n;
        cube.rmax = n2;
        cube.gmin = n3;
        cube.gmax = n4;
        cube.gmin = n3;
        cube.gmax = n4;
    }

    void makeInverseMap(int[] nArray, int n) {
        int n2;
        int n3;
        Cube cube;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        IJ.showStatus("Making inverse map");
        int n4 = 0;
        while (n4 <= n - 1) {
            int n5;
            int n6;
            int n7;
            cube = this.list[n4];
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            n3 = cube.lower;
            while (n3 <= cube.upper) {
                n2 = this.histPtr[n3];
                n7 = this.red(n2);
                f3 += (float)n7 * (float)nArray[n2];
                n6 = this.green(n2);
                f2 += (float)n6 * (float)nArray[n2];
                n5 = this.blue(n2);
                f += (float)n5 * (float)nArray[n2];
                ++n3;
            }
            n7 = (int)(f3 / (float)cube.count);
            n6 = (int)(f2 / (float)cube.count);
            n5 = (int)(f / (float)cube.count);
            if (n7 == 248 && n6 == 248 && n5 == 248) {
                n5 = 255;
                n6 = 255;
                n7 = 255;
            }
            byArray[n4] = (byte)n7;
            byArray2[n4] = (byte)n6;
            byArray3[n4] = (byte)n5;
            ++n4;
        }
        this.cm = new IndexColorModel(8, n, byArray, byArray2, byArray3);
        n3 = 0;
        while (n3 <= n - 1) {
            cube = this.list[n3];
            int n8 = cube.lower;
            while (n8 <= cube.upper) {
                n2 = this.histPtr[n8];
                nArray[n2] = n3;
                ++n8;
            }
            ++n3;
        }
    }

    void reorderColors(int[] nArray, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                int n4 = n;
                while (n4 <= n2) {
                    int n5 = nArray[n4];
                    int n6 = n5 & 0x1F;
                    nArray[n4] = n6 << 10 | n5 >> 5;
                    ++n4;
                }
                break;
            }
            case 1: {
                int n7 = n;
                while (n7 <= n2) {
                    int n8 = nArray[n7];
                    int n9 = n8 & 0x1F;
                    int n10 = n8 >> 5 & 0x1F;
                    int n11 = n8 >> 10;
                    nArray[n7] = n10 << 10 | n11 << 5 | n9;
                    ++n7;
                }
                break;
            }
        }
    }

    void restoreColorOrder(int[] nArray, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                int n4 = n;
                while (n4 <= n2) {
                    int n5 = nArray[n4];
                    int n6 = n5 >> 10;
                    nArray[n4] = (n5 & 0x3FF) << 5 | n6;
                    ++n4;
                }
                break;
            }
            case 1: {
                int n7 = n;
                while (n7 <= n2) {
                    int n8 = nArray[n7];
                    int n9 = n8 & 0x1F;
                    int n10 = n8 >> 10;
                    int n11 = n8 >> 5 & 0x1F;
                    nArray[n7] = n11 << 10 | n10 << 5 | n9;
                    ++n7;
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void quickSort(int[] var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = var1_1[(var2_2 + var3_3) / 2];
            ** GOTO lbl18
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && var1_1[var4_4] < var6_6) continue block0;
                    while (var5_5 > var2_2 && var1_1[var5_5] > var6_6) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    var7_7 = var1_1[var4_4];
                    var1_1[var4_4] = var1_1[var5_5];
                    var1_1[var5_5] = var7_7;
                    ++var4_4;
                    --var5_5;
lbl18:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.quickSort(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.quickSort(var1_1, var4_4, var3_3);
            }
        }
    }

    ImageProcessor makeImage() {
        IJ.showStatus("Creating 8-bit image");
        byte[] byArray = new byte[this.width * this.height];
        int n = 0;
        while (n < this.width * this.height) {
            int n2 = this.rgb(this.pixels32[n]);
            byArray[n] = (byte)this.hist[n2];
            ++n;
        }
        ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, byArray, this.cm);
        IJ.showProgress(1.0);
        return byteProcessor;
    }
}

