/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class ImageStack {
    static final int INITIAL_SIZE = 25;
    static final String outOfRange = "Argument out of range: ";
    private int nSlices = 0;
    private Object[] stack;
    private String[] label;
    private int width;
    private int height;
    private Rectangle roi;
    private ColorModel cm;
    private double min = Double.MAX_VALUE;
    private double max;
    private ImageProcessor ip;

    public ImageStack(int n, int n2) {
        this(n, n2, null);
    }

    public ImageStack(int n, int n2, ColorModel colorModel) {
        this.width = n;
        this.height = n2;
        this.cm = colorModel;
        this.stack = new Object[25];
        this.label = new String[25];
        this.nSlices = 0;
    }

    public void addSlice(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("'pixels' is null!");
        }
        ++this.nSlices;
        if (this.nSlices == this.stack.length) {
            Object[] objectArray = new Object[this.nSlices * 2];
            System.arraycopy(this.stack, 0, objectArray, 0, this.nSlices);
            this.stack = objectArray;
            String[] stringArray = new String[this.nSlices * 2];
            System.arraycopy(this.label, 0, stringArray, 0, this.nSlices);
            this.label = stringArray;
        }
        this.stack[this.nSlices - 1] = object;
        this.label[this.nSlices - 1] = string;
    }

    public void addUnsignedShortSlice(String string, Object object) {
        this.addSlice(string, object);
    }

    public void addSlice(String string, ImageProcessor imageProcessor) {
        if (imageProcessor.getWidth() != this.width || imageProcessor.getHeight() != this.height) {
            throw new IllegalArgumentException("Dimensions do not match");
        }
        if (this.nSlices == 0) {
            this.cm = imageProcessor.getColorModel();
            this.min = imageProcessor.getMin();
            this.max = imageProcessor.getMax();
        }
        this.addSlice(string, imageProcessor.getPixels());
    }

    public void addSlice(String string, ImageProcessor imageProcessor, int n) {
        if (n < 0 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.addSlice(string, imageProcessor);
        Object object = this.stack[this.nSlices - 1];
        String string2 = this.label[this.nSlices - 1];
        int n2 = n > 0 ? n : 1;
        int n3 = this.nSlices - 1;
        while (n3 >= n2) {
            this.stack[n3] = this.stack[n3 - 1];
            this.label[n3] = this.label[n3 - 1];
            --n3;
        }
        this.stack[n] = object;
        this.label[n] = string2;
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if (this.nSlices < 1) {
            return;
        }
        int n2 = n;
        while (n2 < this.nSlices) {
            this.stack[n2 - 1] = this.stack[n2];
            this.label[n2 - 1] = this.label[n2];
            ++n2;
        }
        this.stack[this.nSlices - 1] = null;
        this.label[this.nSlices - 1] = null;
        --this.nSlices;
    }

    public void deleteLastSlice() {
        if (this.nSlices > 0) {
            this.deleteSlice(this.nSlices);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setRoi(Rectangle rectangle) {
        this.roi = rectangle;
    }

    public Rectangle getRoi() {
        return this.roi;
    }

    public void update(ImageProcessor imageProcessor) {
        this.min = imageProcessor.getMin();
        this.max = imageProcessor.getMax();
    }

    public Object getPixels(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        return this.stack[n - 1];
    }

    public void setPixels(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("'pixels' is null!");
        }
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.stack[n - 1] = object;
    }

    public Object[] getImageArray() {
        return this.stack;
    }

    public int getSize() {
        return this.nSlices;
    }

    public String getSliceLabel(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        return this.label[n - 1];
    }

    public void setSliceLabel(String string, int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.label[n - 1] = string;
    }

    public ImageProcessor getProcessor(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if (this.nSlices == 0) {
            return null;
        }
        if (this.stack[0] instanceof byte[]) {
            this.ip = new ByteProcessor(this.width, this.height, null, this.cm);
        } else if (this.stack[0] instanceof short[]) {
            this.ip = new ShortProcessor(this.width, this.height, null, this.cm);
        } else if (this.stack[0] instanceof int[]) {
            this.ip = new ColorProcessor(this.width, this.height, null);
        } else if (this.stack[0] instanceof float[]) {
            this.ip = new FloatProcessor(this.width, this.height, null, this.cm);
        }
        this.ip.setPixels(this.stack[n - 1]);
        if (this.min != Double.MAX_VALUE && this.ip != null && !(this.ip instanceof ColorProcessor)) {
            this.ip.setMinAndMax(this.min, this.max);
        }
        return this.ip;
    }

    public void setColorModel(ColorModel colorModel) {
        this.cm = colorModel;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public boolean isRGB() {
        return this.nSlices == 3 && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("Red");
    }

    public boolean isHSB() {
        return this.nSlices == 3 && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("Hue");
    }

    public void trim() {
        int n = (int)Math.round(Math.log(this.nSlices) + 1.0);
        int n2 = 0;
        while (n2 < n) {
            this.deleteLastSlice();
            System.gc();
            ++n2;
        }
    }

    public String toString() {
        return "width=" + this.width + ", height=" + this.height + ", nSlices=" + this.nSlices + ", cm=" + this.cm;
    }
}

