/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Graphics;

public class Line
extends Roi {
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    private int x1R = 0;
    private int y1R = 0;
    private int x2R;
    private int y2R;
    private static int lineWidth = 1;

    public Line(int n, int n2, int n3, int n4) {
        this(n, n2, null);
        this.grow(n3, n4);
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        this.state = 3;
    }

    public Line(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        this.type = 5;
    }

    public Line(int n, int n2, int n3, int n4, ImagePlus imagePlus) {
        this(n, n2, n3, n4);
        this.setImage(imagePlus);
    }

    protected void grow(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n > this.xMax) {
            n = this.xMax;
        }
        if (n2 > this.yMax) {
            n2 = this.yMax;
        }
        int n3 = this.x + this.x1R;
        int n4 = this.y + this.y1R;
        if (this.constrain) {
            int n5;
            int n6 = Math.abs(n - n3);
            if (n6 >= (n5 = Math.abs(n2 - n4))) {
                n2 = n4;
            } else {
                n = n3;
            }
        }
        this.x = Math.min(this.x + this.x1R, n);
        this.y = Math.min(this.y + this.y1R, n2);
        this.x1R = n3 - this.x;
        this.y1R = n4 - this.y;
        this.x2R = n - this.x;
        this.y2R = n2 - this.y;
        this.width = Math.abs(this.x2R - this.x1R);
        this.height = Math.abs(this.y2R - this.y1R);
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        this.updateClipRect();
        if (this.imp != null) {
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    public void draw(Graphics graphics) {
        graphics.setColor(Roi.ROIColor);
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        graphics.drawLine(this.ic.screenX(this.x1), this.ic.screenY(this.y1), this.ic.screenX(this.x2), this.ic.screenY(this.y2));
        IJ.showStatus(this.imp.getLocationAsString(this.x2, this.y2) + ", angle=" + IJ.d2s(this.getAngle(this.x1, this.y1, this.x2, this.y2)) + ", length=" + IJ.d2s(this.getLength()));
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public double getLength() {
        Calibration calibration = this.imp.getCalibration();
        return Math.sqrt((double)(this.x2 - this.x1) * calibration.pixelWidth * (double)(this.x2 - this.x1) * calibration.pixelWidth + (double)(this.y2 - this.y1) * calibration.pixelHeight * (double)(this.y2 - this.y1) * calibration.pixelHeight);
    }

    public double getRawLength() {
        return Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
    }

    public double[] getPixels() {
        ImageProcessor imageProcessor = this.imp.getProcessor();
        double[] dArray = imageProcessor.getLine(this.x1, this.y1, this.x2, this.y2);
        return dArray;
    }

    public void drawPixels() {
        ImageProcessor imageProcessor = this.imp.getProcessor();
        imageProcessor.moveTo(this.x1, this.y1);
        imageProcessor.lineTo(this.x2, this.y2);
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public static int getWidth() {
        return lineWidth;
    }

    public static void setWidth(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 99) {
            n = 99;
        }
        lineWidth = n;
    }

    public void nudgeCorner(int n) {
        switch (n) {
            case 38: {
                --this.y2R;
                break;
            }
            case 40: {
                ++this.y2R;
                break;
            }
            case 37: {
                --this.x2R;
                break;
            }
            case 39: {
                ++this.x2R;
            }
        }
        this.grow(this.x + this.x2R, this.y + this.y2R);
    }
}

