/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class GifEncoder {
    private boolean interlace = false;
    private int width;
    private int height;
    private byte[] pixels;
    private byte[] r;
    private byte[] g;
    private byte[] b;
    private int pixelIndex;
    private int numPixels;
    private int transparentPixel = -1;
    int Width;
    int Height;
    boolean Interlace;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    public GifEncoder(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.width = n;
        this.height = n2;
        this.pixels = byArray;
        this.r = byArray2;
        this.g = byArray3;
        this.b = byArray4;
        this.interlace = false;
        this.pixelIndex = 0;
        this.numPixels = n * n2;
    }

    public GifEncoder(Image image) {
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.pixels = new byte[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        if (!(colorModel instanceof IndexColorModel)) {
            throw new IllegalArgumentException("Image must be 8-bit");
        }
        this.pixels = (byte[])pixelGrabber.getPixels();
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        this.setTransparentPixel(indexColorModel.getTransparentPixel());
        indexColorModel = (IndexColorModel)colorModel;
        int n = indexColorModel.getMapSize();
        this.r = new byte[n];
        this.g = new byte[n];
        this.b = new byte[n];
        indexColorModel.getReds(this.r);
        indexColorModel.getGreens(this.g);
        indexColorModel.getBlues(this.b);
        this.interlace = false;
        this.pixelIndex = 0;
        this.numPixels = this.width * this.height;
    }

    public void write(OutputStream outputStream) throws IOException {
        int n = this.r.length;
        int n2 = n <= 2 ? 1 : (n <= 4 ? 2 : (n <= 16 ? 4 : 8));
        int n3 = 1 << n2;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        int n4 = 0;
        while (n4 < n) {
            byArray[n4] = this.r[n4];
            byArray2[n4] = this.g[n4];
            byArray3[n4] = this.b[n4];
            ++n4;
        }
        this.GIFEncode(outputStream, this.width, this.height, this.interlace, (byte)0, this.getTransparentPixel(), n2, byArray, byArray2, byArray3);
    }

    public void setTransparentPixel(int n) {
        this.transparentPixel = n;
    }

    public int getTransparentPixel() {
        return this.transparentPixel;
    }

    static void writeString(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
    }

    void GIFEncode(OutputStream outputStream, int n, int n2, boolean bl, byte by, int n3, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        this.Width = n;
        this.Height = n2;
        this.Interlace = bl;
        int n5 = 1 << n4;
        int n6 = 0;
        int n7 = 0;
        int n8 = n4 <= 1 ? 2 : n4;
        GifEncoder.writeString(outputStream, "GIF89a");
        this.Putword(n, outputStream);
        this.Putword(n2, outputStream);
        byte by2 = -128;
        by2 = (byte)(by2 | 0x70);
        by2 = (byte)(by2 | (byte)(n4 - 1));
        this.Putbyte(by2, outputStream);
        this.Putbyte(by, outputStream);
        this.Putbyte((byte)0, outputStream);
        int n9 = 0;
        while (n9 < n5) {
            this.Putbyte(byArray[n9], outputStream);
            this.Putbyte(byArray2[n9], outputStream);
            this.Putbyte(byArray3[n9], outputStream);
            ++n9;
        }
        if (n3 != -1) {
            this.Putbyte((byte)33, outputStream);
            this.Putbyte((byte)-7, outputStream);
            this.Putbyte((byte)4, outputStream);
            this.Putbyte((byte)1, outputStream);
            this.Putbyte((byte)0, outputStream);
            this.Putbyte((byte)0, outputStream);
            this.Putbyte((byte)n3, outputStream);
            this.Putbyte((byte)0, outputStream);
        }
        this.Putbyte((byte)44, outputStream);
        this.Putword(n7, outputStream);
        this.Putword(n6, outputStream);
        this.Putword(n, outputStream);
        this.Putword(n2, outputStream);
        if (bl) {
            this.Putbyte((byte)64, outputStream);
        } else {
            this.Putbyte((byte)0, outputStream);
        }
        this.Putbyte((byte)n8, outputStream);
        this.compress(n8 + 1, outputStream);
        this.Putbyte((byte)0, outputStream);
        this.Putbyte((byte)59, outputStream);
    }

    int GIFNextPixel() throws IOException {
        if (this.pixelIndex == this.numPixels) {
            return -1;
        }
        return this.pixels[this.pixelIndex++] & 0xFF;
    }

    void Putword(int n, OutputStream outputStream) throws IOException {
        this.Putbyte((byte)(n & 0xFF), outputStream);
        this.Putbyte((byte)(n >> 8 & 0xFF), outputStream);
    }

    void Putbyte(byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by);
    }

    final int MAXCODE(int n) {
        return (1 << n) - 1;
    }

    void compress(int n, OutputStream outputStream) throws IOException {
        int n2;
        this.g_init_bits = n;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int n3 = this.GIFNextPixel();
        int n4 = 0;
        int n5 = this.hsize;
        while (n5 < 65536) {
            ++n4;
            n5 *= 2;
        }
        n4 = 8 - n4;
        int n6 = this.hsize;
        this.cl_hash(n6);
        this.output(this.ClearCode, outputStream);
        block1: while ((n2 = this.GIFNextPixel()) != -1) {
            int n7 = n2 << n4 ^ n3;
            n5 = (n2 << this.maxbits) + n3;
            if (this.htab[n7] == n5) {
                n3 = this.codetab[n7];
                continue;
            }
            if (this.htab[n7] >= 0) {
                int n8 = n6 - n7;
                if (n7 == 0) {
                    n8 = 1;
                }
                do {
                    if ((n7 -= n8) < 0) {
                        n7 += n6;
                    }
                    if (this.htab[n7] != n5) continue;
                    n3 = this.codetab[n7];
                    continue block1;
                } while (this.htab[n7] >= 0);
            }
            this.output(n3, outputStream);
            n3 = n2;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n7] = n5;
                continue;
            }
            this.cl_block(outputStream);
        }
        this.output(n3, outputStream);
        this.output(this.EOFCode, outputStream);
    }

    void output(int n, OutputStream outputStream) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n << this.cur_bits) : n;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (n == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outputStream);
        }
    }

    void cl_block(OutputStream outputStream) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outputStream);
    }

    void cl_hash(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.htab[n2] = -1;
            ++n2;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte by, OutputStream outputStream) throws IOException {
        this.accum[this.a_count++] = by;
        if (this.a_count >= 254) {
            this.flush_char(outputStream);
        }
    }

    void flush_char(OutputStream outputStream) throws IOException {
        if (this.a_count > 0) {
            outputStream.write(this.a_count);
            outputStream.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

