/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.io.FileInfo;
import ij.plugin.DicomDictionary;
import ij.util.Tools;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

class DicomDecoder {
    private static final int PIXEL_REPRESENTATION = 2621699;
    private static final int TRANSFER_SYNTAX_UID = 131088;
    private static final int SLICE_SPACING = 0x180088;
    private static final int SAMPLES_PER_PIXEL = 0x280002;
    private static final int PHOTOMETRIC_INTERPRETATION = 2621444;
    private static final int PLANAR_CONFIGURATION = 2621446;
    private static final int NUMBER_OF_FRAMES = 0x280008;
    private static final int ROWS = 2621456;
    private static final int COLUMNS = 2621457;
    private static final int PIXEL_SPACING = 2621488;
    private static final int BITS_ALLOCATED = 2621696;
    private static final int WINDOW_CENTER = 2625616;
    private static final int WINDOW_WIDTH = 2625617;
    private static final int RED_PALETTE = 2626049;
    private static final int GREEN_PALETTE = 2626050;
    private static final int BLUE_PALETTE = 2626051;
    private static final int PIXEL_DATA = 2145386512;
    private static final int AE = 16709;
    private static final int AS = 16723;
    private static final int AT = 16724;
    private static final int CS = 17235;
    private static final int DA = 17473;
    private static final int DS = 17491;
    private static final int DT = 17492;
    private static final int FD = 17988;
    private static final int FL = 17996;
    private static final int IS = 18771;
    private static final int LO = 19535;
    private static final int LT = 19540;
    private static final int PN = 20558;
    private static final int SH = 21320;
    private static final int SL = 21324;
    private static final int SS = 21331;
    private static final int ST = 21332;
    private static final int TM = 21581;
    private static final int UI = 21833;
    private static final int UL = 21836;
    private static final int US = 21843;
    private static final int UT = 21844;
    private static final int OB = 20290;
    private static final int OW = 20311;
    private static final int SQ = 21329;
    private static final int UN = 21838;
    private static final int QQ = 16191;
    private static Properties dictionary;
    private String directory;
    private String fileName;
    private static final int ID_OFFSET = 128;
    private static final String DICM = "DICM";
    private BufferedInputStream f;
    private int location = 0;
    private boolean littleEndian = true;
    private int elementLength;
    private int vr;
    private static final int IMPLICIT_VR = 11565;
    private byte[] vrLetters = new byte[2];
    private int previousGroup;
    private StringBuffer dicomInfo = new StringBuffer(1000);
    private boolean dicmFound;
    private boolean oddLocations;
    private boolean bigEndianTransferSyntax = false;
    double windowCenter;
    double windowWidth;
    static char[] buf8;
    char[] buf10;
    static /* synthetic */ Class class$ij$plugin$DICOM;

    public DicomDecoder(String string, String string2) {
        this.directory = string;
        this.fileName = string2;
        if (dictionary == null) {
            DicomDictionary dicomDictionary = new DicomDictionary();
            dictionary = dicomDictionary.getDictionary();
        }
        IJ.register(class$ij$plugin$DICOM == null ? (class$ij$plugin$DICOM = DicomDecoder.class$("ij.plugin.DICOM")) : class$ij$plugin$DICOM);
    }

    String getString(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.f.read(byArray, n2, n - n2);
            n2 += n3;
        }
        this.location += n;
        return new String(byArray);
    }

    int getByte() throws IOException {
        int n = this.f.read();
        if (n == -1) {
            throw new IOException("unexpected EOF");
        }
        ++this.location;
        return n;
    }

    int getShort() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        if (this.littleEndian) {
            return (n2 << 8) + n;
        }
        return (n << 8) + n2;
    }

    final int getInt() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        int n3 = this.getByte();
        int n4 = this.getByte();
        if (this.littleEndian) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    byte[] getLut(int n) throws IOException {
        if ((n & 1) != 0) {
            String string = this.getString(n);
            return null;
        }
        byte[] byArray = new byte[n /= 2];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(this.getShort() >>> 8);
            ++n2;
        }
        return byArray;
    }

    int getLength() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        int n3 = this.getByte();
        int n4 = this.getByte();
        this.vr = (n << 8) + n2;
        switch (this.vr) {
            case 20290: 
            case 20311: 
            case 21329: 
            case 21838: {
                if (n3 == 0 || n4 == 0) {
                    return this.getInt();
                }
                this.vr = 11565;
                if (this.littleEndian) {
                    return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
                }
                return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: 
            case 21844: {
                if (this.littleEndian) {
                    return (n4 << 8) + n3;
                }
                return (n3 << 8) + n4;
            }
        }
        this.vr = 11565;
        if (this.littleEndian) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    int getNextTag() throws IOException {
        int n = this.getShort();
        if (n == 2048 && this.bigEndianTransferSyntax) {
            this.littleEndian = false;
            n = 8;
        }
        int n2 = this.getShort();
        int n3 = n << 16 | n2;
        this.elementLength = this.getLength();
        if (this.elementLength == 13 && !this.oddLocations) {
            this.elementLength = 10;
        }
        if (this.elementLength == -1) {
            this.elementLength = 0;
        }
        return n3;
    }

    FileInfo getFileInfo() throws IOException {
        FileInfo fileInfo = new FileInfo();
        int n = 16;
        fileInfo.fileFormat = 1;
        fileInfo.fileName = this.fileName;
        fileInfo.directory = this.directory;
        fileInfo.width = 0;
        fileInfo.height = 0;
        fileInfo.offset = 0;
        fileInfo.intelByteOrder = true;
        fileInfo.fileType = 2;
        fileInfo.fileFormat = 6;
        int n2 = 1;
        int n3 = 0;
        String string = "";
        this.f = new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
        if (IJ.debugMode) {
            IJ.log("");
            IJ.log("DicomDecoder: decoding " + this.fileName);
        }
        long l = 128L;
        while (l > 0L) {
            l -= this.f.skip(l);
        }
        this.location += 128;
        if (!this.getString(4).equals(DICM)) {
            this.f.close();
            this.f = new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
            this.location = 0;
            if (IJ.debugMode) {
                IJ.log("DICM not found at offset 128; reseting to offset 0");
            }
        } else {
            this.dicmFound = true;
            if (IJ.debugMode) {
                IJ.log("DICM found at offset 128");
            }
        }
        boolean bl = true;
        boolean bl2 = true;
        block21: while (bl2) {
            int n4 = this.getNextTag();
            if ((this.location & 1) != 0) {
                this.oddLocations = true;
            }
            switch (n4) {
                case 131088: {
                    String string2 = this.getString(this.elementLength);
                    this.addInfo(n4, string2);
                    if (string2.indexOf("1.2.4") > -1 || string2.indexOf("1.2.5") > -1) {
                        this.f.close();
                        String string3 = "ImageJ cannot open compressed DICOM images.\n \n";
                        string3 = string3 + "Transfer Syntax UID = " + string2;
                        throw new IOException(string3);
                    }
                    if (string2.indexOf("1.2.840.10008.1.2.2") < 0) continue block21;
                    this.bigEndianTransferSyntax = true;
                    break;
                }
                case 0x280008: {
                    String string2 = this.getString(this.elementLength);
                    this.addInfo(n4, string2);
                    double d = this.s2d(string2);
                    if (!(d > 1.0)) continue block21;
                    fileInfo.nImages = (int)d;
                    break;
                }
                case 0x280002: {
                    n2 = this.getShort();
                    this.addInfo(n4, n2);
                    break;
                }
                case 2621444: {
                    string = this.getString(this.elementLength);
                    this.addInfo(n4, string);
                    break;
                }
                case 2621446: {
                    n3 = this.getShort();
                    this.addInfo(n4, n3);
                    break;
                }
                case 2621456: {
                    fileInfo.height = this.getShort();
                    this.addInfo(n4, fileInfo.height);
                    break;
                }
                case 2621457: {
                    fileInfo.width = this.getShort();
                    this.addInfo(n4, fileInfo.width);
                    break;
                }
                case 2621488: {
                    String string4 = this.getString(this.elementLength);
                    this.getSpatialScale(fileInfo, string4);
                    this.addInfo(n4, string4);
                    break;
                }
                case 0x180088: {
                    String string5 = this.getString(this.elementLength);
                    fileInfo.pixelDepth = this.s2d(string5);
                    this.addInfo(n4, string5);
                    break;
                }
                case 2621696: {
                    n = this.getShort();
                    if (n == 8) {
                        fileInfo.fileType = 0;
                    }
                    this.addInfo(n4, n);
                    break;
                }
                case 2621699: {
                    int n5 = this.getShort();
                    if (n5 == 1) {
                        fileInfo.fileType = 1;
                    }
                    this.addInfo(n4, n5);
                    break;
                }
                case 2625616: {
                    String string6 = this.getString(this.elementLength);
                    this.windowCenter = this.s2d(string6);
                    this.addInfo(n4, string6);
                    break;
                }
                case 2625617: {
                    String string7 = this.getString(this.elementLength);
                    this.windowWidth = this.s2d(string7);
                    this.addInfo(n4, string7);
                    break;
                }
                case 2626049: {
                    fileInfo.reds = this.getLut(this.elementLength);
                    this.addInfo(n4, this.elementLength / 2);
                    break;
                }
                case 2626050: {
                    fileInfo.greens = this.getLut(this.elementLength);
                    this.addInfo(n4, this.elementLength / 2);
                    break;
                }
                case 2626051: {
                    fileInfo.blues = this.getLut(this.elementLength);
                    this.addInfo(n4, this.elementLength / 2);
                    break;
                }
                case 2145386512: {
                    if (this.elementLength != 0) {
                        fileInfo.offset = this.location;
                        this.addInfo(n4, this.location);
                        bl2 = false;
                        break;
                    }
                    this.addInfo(n4, null);
                    break;
                }
                case 2139619344: {
                    if (this.elementLength == 0) continue block21;
                    fileInfo.offset = this.location + 4;
                    bl2 = false;
                    break;
                }
                default: {
                    this.addInfo(n4, null);
                }
            }
        }
        if (fileInfo.fileType == 0 && fileInfo.reds != null && fileInfo.greens != null && fileInfo.blues != null && fileInfo.reds.length == fileInfo.greens.length && fileInfo.reds.length == fileInfo.blues.length) {
            fileInfo.fileType = 5;
            fileInfo.lutSize = fileInfo.reds.length;
        }
        if (n2 == 3 && string.startsWith("RGB")) {
            if (n3 == 0) {
                fileInfo.fileType = 6;
            } else if (n3 == 1) {
                fileInfo.fileType = 7;
            }
        } else if (string.endsWith("1 ")) {
            fileInfo.whiteIsZero = true;
        }
        if (!this.littleEndian) {
            fileInfo.intelByteOrder = false;
        }
        if (IJ.debugMode) {
            IJ.log("width: " + fileInfo.width);
            IJ.log("height: " + fileInfo.height);
            IJ.log("images: " + fileInfo.nImages);
            IJ.log("bits allocated: " + n);
            IJ.log("offset: " + fileInfo.offset);
        }
        this.f.close();
        return fileInfo;
    }

    String getDicomInfo() {
        return new String(this.dicomInfo);
    }

    void addInfo(int n, String string) throws IOException {
        String string2 = this.getHeaderInfo(n, string);
        if (string2 != null) {
            int n2 = n >>> 16;
            if (n2 != this.previousGroup) {
                this.dicomInfo.append("\n");
            }
            this.previousGroup = n2;
            this.dicomInfo.append(this.tag2hex(n) + string2 + "\n");
        }
        if (IJ.debugMode) {
            if (string2 == null) {
                string2 = "";
            }
            this.vrLetters[0] = (byte)(this.vr >> 8);
            this.vrLetters[1] = (byte)(this.vr & 0xFF);
            String string3 = new String(this.vrLetters);
            IJ.log("(" + this.tag2hex(n) + string3 + " " + this.elementLength + " bytes from " + (this.location - this.elementLength) + ") " + string2);
        }
    }

    void addInfo(int n, int n2) throws IOException {
        this.addInfo(n, Integer.toString(n2));
    }

    String getHeaderInfo(int n, String string) throws IOException {
        String string2 = this.i2hex(n);
        String string3 = (String)((Hashtable)dictionary).get(string2);
        if (string3 != null) {
            if (this.vr == 11565 && string3 != null) {
                this.vr = (string3.charAt(0) << 8) + string3.charAt(1);
            }
            string3 = string3.substring(2);
        }
        if (string != null) {
            return string3 + ": " + string;
        }
        switch (this.vr) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                string = this.getString(this.elementLength);
                break;
            }
            case 21843: {
                if (this.elementLength == 2) {
                    string = Integer.toString(this.getShort());
                    break;
                }
                string = "";
                int n2 = this.elementLength / 2;
                int n3 = 0;
                while (n3 < n2) {
                    string = string + Integer.toString(this.getShort()) + " ";
                    ++n3;
                }
                break;
            }
            default: {
                long l = this.elementLength;
                while (l > 0L) {
                    l -= this.f.skip(l);
                }
                this.location += this.elementLength;
                string = "";
            }
        }
        if (string3 == null) {
            return null;
        }
        return string3 + ": " + string;
    }

    String i2hex(int n) {
        int n2 = 7;
        while (n2 >= 0) {
            DicomDecoder.buf8[n2] = Tools.hexDigits[n & 0xF];
            n >>>= 4;
            --n2;
        }
        return new String(buf8);
    }

    String tag2hex(int n) {
        if (this.buf10 == null) {
            this.buf10 = new char[11];
            this.buf10[4] = 44;
            this.buf10[9] = 32;
        }
        int n2 = 8;
        while (n2 >= 0) {
            this.buf10[n2] = Tools.hexDigits[n & 0xF];
            n >>>= 4;
            if (--n2 != 4) continue;
            --n2;
        }
        return new String(this.buf10);
    }

    double s2d(String string) {
        Double d;
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void getSpatialScale(FileInfo fileInfo, String string) {
        double d = 0.0;
        double d2 = 0.0;
        int n = string.indexOf(92);
        if (n > 0) {
            d = this.s2d(string.substring(0, n));
            d2 = this.s2d(string.substring(n + 1));
        }
        if (d != 0.0 && d2 != 0.0) {
            fileInfo.pixelWidth = d;
            fileInfo.pixelHeight = d2;
            fileInfo.unit = "mm";
        }
    }

    boolean dicmFound() {
        return this.dicmFound;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        buf8 = new char[8];
    }
}

