/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

public class ScaleBar
implements PlugIn {
    static final String[] locations = new String[]{"Upper Right", "Lower Right", "Lower Left", "Upper Left", "At Selection"};
    static final int UPPER_RIGHT = 0;
    static final int LOWER_RIGHT = 1;
    static final int LOWER_LEFT = 2;
    static final int UPPER_LEFT = 3;
    static final int AT_SELECTION = 4;
    static final String[] colors = new String[]{"White", "Black", "Light Gray", "Gray", "Dark Gray", "Red", "Green", "Blue", "Yellow"};
    static double barWidth;
    static int defaultBarHeight;
    static int barHeightInPixels;
    static String location;
    static String color;
    static boolean boldText;
    static int fontSize;
    ImagePlus imp;
    double imageWidth;
    double mag;
    int xloc;
    int yloc;
    int barWidthInPixels;
    int roiX = -1;
    int roiY;
    int roiWidth;
    int roiHeight;

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.showDialog(this.imp);
    }

    boolean showDialog(ImagePlus imagePlus) {
        int n;
        Object object;
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            object = roi.getBoundingRect();
            this.roiX = ((Rectangle)object).x;
            this.roiY = ((Rectangle)object).y;
            this.roiWidth = ((Rectangle)object).width;
            this.roiHeight = ((Rectangle)object).height;
            location = locations[4];
        } else if (location.equals(locations[4])) {
            location = locations[0];
        }
        object = imagePlus.getCalibration();
        ImageWindow imageWindow = imagePlus.getWindow();
        double d = this.mag = imageWindow != null ? imageWindow.getCanvas().getMagnification() : 1.0;
        if (this.mag > 1.0) {
            this.mag = 1.0;
        }
        if ((double)fontSize < 12.0 / this.mag) {
            fontSize = (int)(12.0 / this.mag);
        }
        String string = ((Calibration)object).getUnits();
        double d2 = ((Calibration)object).pixelWidth;
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        double d3 = 1.0 / d2;
        this.imageWidth = (double)imagePlus.getWidth() * d2;
        if (this.roiX > 0 && this.roiWidth > 10) {
            barWidth = (double)this.roiWidth * d2;
        } else if (barWidth == 0.0 || barWidth > 0.67 * this.imageWidth) {
            barWidth = 80.0 * d2 / this.mag;
            if (barWidth > 0.67 * this.imageWidth) {
                barWidth = 0.67 * this.imageWidth;
            }
            if (barWidth > 5.0) {
                barWidth = (int)barWidth;
            }
        }
        int n2 = n = (double)((int)barWidth) == barWidth ? 0 : 1;
        if (barWidth < 1.0) {
            n = 2;
        }
        int n3 = (int)(barWidth * 100.0 / this.imageWidth);
        if (this.mag < 1.0 && (double)barHeightInPixels < (double)defaultBarHeight / this.mag) {
            barHeightInPixels = (int)((double)defaultBarHeight / this.mag);
        }
        imagePlus.getProcessor().snapshot();
        this.updateScalebar();
        BarDialog barDialog = new BarDialog("Scale Bar");
        barDialog.addNumericField("Width in " + string + ": ", barWidth, n);
        barDialog.addNumericField("Height in Pixels: ", barHeightInPixels, 0);
        barDialog.addNumericField("Font Size: ", fontSize, 0);
        barDialog.addChoice("Color: ", colors, color);
        barDialog.addChoice("Location: ", locations, location);
        barDialog.addCheckbox("Bold Text", boldText);
        barDialog.showDialog();
        if (barDialog.wasCanceled()) {
            imagePlus.getProcessor().reset();
            imagePlus.updateAndDraw();
            return false;
        }
        barWidth = barDialog.getNextNumber();
        barHeightInPixels = (int)barDialog.getNextNumber();
        fontSize = (int)barDialog.getNextNumber();
        color = barDialog.getNextChoice();
        location = barDialog.getNextChoice();
        boldText = barDialog.getNextBoolean();
        return true;
    }

    void drawScaleBar(ImagePlus imagePlus) {
        int n;
        if (!this.updateLocation()) {
            return;
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        Undo.setup(4, imagePlus);
        Color color = this.getColor();
        imageProcessor.setColor(color);
        int n2 = this.xloc;
        int n3 = this.yloc;
        imageProcessor.setRoi(n2, n3, this.barWidthInPixels, barHeightInPixels);
        imageProcessor.fill();
        imageProcessor.resetRoi();
        int n4 = boldText ? 1 : 0;
        imageProcessor.setFont(new Font("SansSerif", n4, fontSize));
        imageProcessor.setAntialiasedText(true);
        int n5 = n = (double)((int)barWidth) == barWidth ? 0 : 1;
        if (barWidth < 1.0) {
            n = 2;
        }
        String string = IJ.d2s(barWidth, n) + " " + imagePlus.getCalibration().getUnits();
        n3 = n3 + barHeightInPixels + fontSize + fontSize / 4;
        imageProcessor.drawString(string, n2 += (this.barWidthInPixels - imageProcessor.getStringWidth(string)) / 2, n3);
        imagePlus.updateAndDraw();
    }

    boolean updateLocation() {
        Calibration calibration = this.imp.getCalibration();
        this.barWidthInPixels = (int)(barWidth / calibration.pixelWidth);
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        int n3 = 20;
        int n4 = n - n / n3 - this.barWidthInPixels;
        int n5 = 0;
        if (location.equals(locations[0])) {
            n5 = n2 / n3;
        } else if (location.equals(locations[1])) {
            n5 = n2 - n2 / n3 - barHeightInPixels - fontSize;
        } else if (location.equals(locations[3])) {
            n4 = n / n3;
            n5 = n2 / n3;
        } else if (location.equals(locations[2])) {
            n4 = n / n3;
            n5 = n2 - n2 / n3 - barHeightInPixels - fontSize;
        } else {
            if (this.roiX == -1) {
                return false;
            }
            n4 = this.roiX;
            n5 = this.roiY;
        }
        this.xloc = n4;
        this.yloc = n5;
        return true;
    }

    Color getColor() {
        Color color = Color.white;
        if (ScaleBar.color.equals(colors[1])) {
            color = Color.black;
        } else if (ScaleBar.color.equals(colors[2])) {
            color = Color.lightGray;
        } else if (ScaleBar.color.equals(colors[3])) {
            color = Color.gray;
        } else if (ScaleBar.color.equals(colors[4])) {
            color = Color.darkGray;
        } else if (ScaleBar.color.equals(colors[5])) {
            color = Color.red;
        } else if (ScaleBar.color.equals(colors[6])) {
            color = Color.green;
        } else if (ScaleBar.color.equals(colors[7])) {
            color = Color.blue;
        } else if (ScaleBar.color.equals(colors[8])) {
            color = Color.yellow;
        }
        return color;
    }

    void updateScalebar() {
        this.updateLocation();
        this.imp.getProcessor().reset();
        this.drawScaleBar(this.imp);
    }

    static {
        barHeightInPixels = defaultBarHeight = 3;
        location = locations[0];
        color = colors[0];
        boldText = true;
    }

    class BarDialog
    extends GenericDialog {
        BarDialog(String string) {
            super(string);
        }

        public void textValueChanged(TextEvent textEvent) {
            TextField textField = (TextField)this.numberField.elementAt(0);
            Double d = this.getValue(textField.getText());
            if (d == null) {
                return;
            }
            barWidth = d;
            TextField textField2 = (TextField)this.numberField.elementAt(1);
            d = this.getValue(textField2.getText());
            if (d == null) {
                return;
            }
            barHeightInPixels = (int)d.doubleValue();
            TextField textField3 = (TextField)this.numberField.elementAt(2);
            d = this.getValue(textField3.getText());
            if (d == null) {
                return;
            }
            int n = (int)d.doubleValue();
            if (n > 5) {
                fontSize = n;
            }
            ScaleBar.this.updateScalebar();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Choice choice = (Choice)this.choice.elementAt(0);
            color = choice.getSelectedItem();
            Choice choice2 = (Choice)this.choice.elementAt(1);
            location = choice2.getSelectedItem();
            boldText = ((Checkbox)this.checkbox.elementAt(0)).getState();
            ScaleBar.this.updateScalebar();
        }
    }
}

