/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class XYCoordinates
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 31;
    }

    public void run(ImageProcessor imageProcessor) {
        Object object;
        String string;
        int n;
        int n2 = this.imp.getWidth();
        int n3 = this.imp.getHeight();
        double d = imageProcessor.getPixelValue(0, 0);
        if (imageProcessor instanceof ColorProcessor) {
            n = imageProcessor.getPixel(0, 0);
            int n4 = (n & 0xFF0000) >> 16;
            int n5 = (n & 0xFF00) >> 8;
            int n6 = n & 0xFF;
            string = n4 + "," + n5 + "," + n6;
        } else {
            string = (double)((int)d) == d ? IJ.d2s(d, 0) : "" + d;
        }
        this.imp.killRoi();
        n = IJ.showMessageWithCancel("XY_Coordinates", "This plugin writes to a text file the XY coordinates and\npixel value of all non-background pixels. Backround\nis assumed to be the value of the pixel in the\nupper left corner of the image.\n \n    Width: " + n2 + "\n" + "    Height: " + n3 + "\n" + "    Background value: " + string + "\n") ? 1 : 0;
        if (n == 0) {
            return;
        }
        SaveDialog saveDialog = new SaveDialog("Save Coordinates as Text...", this.imp.getTitle(), ".txt");
        String string2 = saveDialog.getFileName();
        if (string2 == null) {
            return;
        }
        String string3 = saveDialog.getDirectory();
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3 + string2);
            object = new BufferedOutputStream(fileOutputStream);
            printWriter = new PrintWriter((OutputStream)object);
        }
        catch (IOException iOException) {
            IJ.write("" + iOException);
            return;
        }
        IJ.showStatus("Saving coordinates...");
        int n7 = 0;
        object = System.getProperty("line.separator");
        int n8 = this.imp.getType();
        int n9 = n3 - 1;
        while (n9 >= 0) {
            int n10 = 0;
            while (n10 < n2) {
                float f = imageProcessor.getPixelValue(n10, n9);
                if ((double)f != d) {
                    if (n8 == 2) {
                        printWriter.print(n10 + "\t" + (n3 - 1 - n9) + "\t" + f + (String)object);
                    } else if (n8 == 4) {
                        int n11 = imageProcessor.getPixel(n10, n9);
                        int n12 = (n11 & 0xFF0000) >> 16;
                        int n13 = (n11 & 0xFF00) >> 8;
                        int n14 = n11 & 0xFF;
                        printWriter.print(n10 + "\t" + (n3 - 1 - n9) + "\t" + n12 + "\t" + n13 + "\t" + n14 + (String)object);
                    } else {
                        printWriter.print(n10 + "\t" + (n3 - 1 - n9) + "\t" + (int)f + (String)object);
                    }
                    ++n7;
                }
                ++n10;
            }
            if (n9 % 10 == 0) {
                IJ.showProgress((double)(n3 - n9) / (double)n3);
            }
            --n9;
        }
        IJ.showProgress(1.0);
        printWriter.close();
        IJ.write(this.imp.getTitle() + ": " + n7 + " pixels (" + IJ.d2s((double)n7 * 100.0 / (double)(n2 * n3)) + "%)\n");
    }
}

