/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.TrimmedButton;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.ThresholdPlot;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class ThresholdAdjuster
extends PlugInFrame
implements PlugIn,
Measurements,
Runnable,
ActionListener,
AdjustmentListener,
ItemListener {
    static final int RED = 0;
    static final int BLACK_AND_WHITE = 1;
    static final int OVER_UNDER = 2;
    static final String[] modes = new String[]{"Red", "Black & White", "Over/Under"};
    static final double defaultMinThreshold = 85.0;
    static final double defaultMaxThreshold = 170.0;
    static boolean fill1 = true;
    static boolean fill2 = true;
    static boolean useBW = true;
    static Frame instance;
    static int mode;
    ThresholdPlot plot = new ThresholdPlot();
    Thread thread;
    int minValue = -1;
    int maxValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doApplyLut;
    boolean doStateChange;
    boolean doSet;
    Panel panel;
    Button autoB;
    Button resetB;
    Button applyB;
    Button setB;
    int previousImageID;
    int previousImageType;
    double previousMin;
    double previousMax;
    ImageJ ij;
    double minThreshold;
    double maxThreshold;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Label label1;
    Label label2;
    boolean done;
    boolean invertedLut;
    int lutColor;
    static Choice choice;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int HIST = 2;
    static final int APPLY = 3;
    static final int STATE_CHANGE = 4;
    static final int MIN_THRESHOLD = 5;
    static final int MAX_THRESHOLD = 6;
    static final int SET = 7;
    static /* synthetic */ Class class$ij$plugin$frame$PasteController;

    public ThresholdAdjuster() {
        super("Threshold");
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        this.setLutColor(mode);
        IJ.register(class$ij$plugin$frame$PasteController == null ? (class$ij$plugin$frame$PasteController = ThresholdAdjuster.class$("ij.plugin.frame.PasteController")) : class$ij$plugin$frame$PasteController);
        this.ij = IJ.getInstance();
        Font font = new Font("SansSerif", 0, 10);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        int n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.plot, gridBagConstraints);
        this.minSlider = new Scrollbar(0, this.sliderRange / 3, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.minSlider, gridBagConstraints);
        this.minSlider.addAdjustmentListener(this);
        this.minSlider.setUnitIncrement(1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.label1 = new Label("       ", 2);
        this.label1.setFont(font);
        this.add((Component)this.label1, gridBagConstraints);
        this.maxSlider = new Scrollbar(0, this.sliderRange * 2 / 3, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.maxSlider, gridBagConstraints);
        this.maxSlider.addAdjustmentListener(this);
        this.maxSlider.setUnitIncrement(1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.label2 = new Label("       ", 2);
        this.label2.setFont(font);
        this.add((Component)this.label2, gridBagConstraints);
        choice = new Choice();
        int n2 = 0;
        while (n2 < modes.length) {
            choice.addItem(modes[n2]);
            ++n2;
        }
        choice.select(mode);
        choice.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.add((Component)choice, gridBagConstraints);
        int n3 = IJ.isMacOSX() ? 15 : 0;
        this.panel = new Panel();
        this.autoB = new TrimmedButton("Auto", n3);
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.applyB = new TrimmedButton("Apply", n3);
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.resetB = new TrimmedButton("Reset", n3);
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.setB = new TrimmedButton("Set", n3);
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.panel, gridBagConstraints);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        this.show();
        this.thread = new Thread((Runnable)this, "ThresholdAdjuster");
        this.thread.start();
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            this.setup(imagePlus);
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.minSlider) {
            this.minValue = this.minSlider.getValue();
        } else {
            this.maxValue = this.maxSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == null) {
            return;
        }
        if (button == this.resetB) {
            this.doReset = true;
        } else if (button == this.autoB) {
            this.doAutoAdjust = true;
        } else if (button == this.applyB) {
            this.doApplyLut = true;
        } else if (button == this.setB) {
            this.doSet = true;
        }
        this.notify();
    }

    void setLutColor(int n) {
        switch (n) {
            case 0: {
                this.lutColor = 0;
                break;
            }
            case 1: {
                this.lutColor = 1;
                break;
            }
            case 2: {
                this.lutColor = 3;
            }
        }
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        mode = choice.getSelectedIndex();
        this.setLutColor(mode);
        this.doStateChange = true;
        this.notify();
    }

    ImageProcessor setup(ImagePlus imagePlus) {
        int n = imagePlus.getType();
        if (n == 4) {
            return null;
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        boolean bl = false;
        if (n == 1 || n == 2) {
            if (imageProcessor.getMin() != this.previousMin || imageProcessor.getMax() != this.previousMax) {
                bl = true;
            }
            this.previousMin = imageProcessor.getMin();
            this.previousMax = imageProcessor.getMax();
        }
        int n2 = imagePlus.getID();
        if (bl || n2 != this.previousImageID || n != this.previousImageType) {
            this.invertedLut = imagePlus.isInvertedLut();
            this.minThreshold = imageProcessor.getMinThreshold();
            this.maxThreshold = imageProcessor.getMaxThreshold();
            if (this.minThreshold == -808080.0) {
                this.minThreshold = 85.0;
                this.maxThreshold = 170.0;
            }
            this.plot.setHistogram(imagePlus);
            this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
            this.updateLabels(imagePlus, imageProcessor);
            this.updatePlot();
            this.updateScrollBars();
            imagePlus.updateAndDraw();
        }
        this.previousImageID = n2;
        this.previousImageType = n;
        return imageProcessor;
    }

    void scaleUpAndSet(ImageProcessor imageProcessor, double d, double d2) {
        if (!(imageProcessor instanceof ByteProcessor) && d != -808080.0) {
            double d3 = imageProcessor.getMin();
            double d4 = imageProcessor.getMax();
            if (d4 > d3) {
                d = d3 + d / 255.0 * (d4 - d3);
                d2 = d3 + d2 / 255.0 * (d4 - d3);
            } else {
                d = -808080.0;
            }
        }
        imageProcessor.setThreshold(d, d2, this.lutColor);
    }

    double scaleDown(ImageProcessor imageProcessor, double d) {
        double d2 = imageProcessor.getMin();
        double d3 = imageProcessor.getMax();
        if (d3 > d2) {
            return (d - d2) / (d3 - d2) * 255.0;
        }
        return -808080.0;
    }

    double scaleUp(ImageProcessor imageProcessor, double d) {
        double d2 = imageProcessor.getMin();
        double d3 = imageProcessor.getMax();
        if (d3 > d2) {
            return d2 + d / 255.0 * (d3 - d2);
        }
        return -808080.0;
    }

    void updatePlot() {
        this.plot.minThreshold = this.minThreshold;
        this.plot.maxThreshold = this.maxThreshold;
        this.plot.mode = mode;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        if (d == -808080.0) {
            this.label1.setText("");
            this.label2.setText("");
        } else {
            Calibration calibration = imagePlus.getCalibration();
            if (calibration.calibrated()) {
                d = calibration.getCValue((int)d);
                d2 = calibration.getCValue((int)d2);
            }
            if ((double)((int)d) == d && (double)((int)d2) == d2 || imageProcessor instanceof ShortProcessor) {
                this.label1.setText("" + (int)d);
                this.label2.setText("" + (int)d2);
            } else {
                this.label1.setText("" + IJ.d2s(d, 2));
                this.label2.setText("" + IJ.d2s(d2, 2));
            }
        }
    }

    void updateScrollBars() {
        this.minSlider.setValue((int)this.minThreshold);
        this.maxSlider.setValue((int)this.maxThreshold);
    }

    void doMasking(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int[] nArray = imagePlus.getMask();
        if (nArray != null) {
            imageProcessor.reset(nArray);
        }
    }

    void adjustMinThreshold(ImagePlus imagePlus, ImageProcessor imageProcessor, double d) {
        if (IJ.altKeyDown()) {
            double d2 = this.maxThreshold - this.minThreshold;
            if (d2 < 1.0) {
                d2 = 1.0;
            }
            this.minThreshold = d;
            this.maxThreshold = this.minThreshold + d2;
            if (this.minThreshold + d2 > 255.0) {
                this.minThreshold = 255.0 - d2;
                this.maxThreshold = this.minThreshold + d2;
                this.minSlider.setValue((int)this.minThreshold);
            }
            this.maxSlider.setValue((int)this.maxThreshold);
            this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
            return;
        }
        this.minThreshold = d;
        if (this.maxThreshold < this.minThreshold) {
            this.maxThreshold = this.minThreshold;
            this.maxSlider.setValue((int)this.maxThreshold);
        }
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
    }

    void adjustMaxThreshold(ImagePlus imagePlus, ImageProcessor imageProcessor, int n) {
        this.maxThreshold = n;
        if (this.minThreshold > this.maxThreshold) {
            this.minThreshold = this.maxThreshold;
            this.minSlider.setValue((int)this.minThreshold);
        }
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
    }

    void reset(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.plot.setHistogram(imagePlus);
        imageProcessor.resetThreshold();
        this.updateScrollBars();
        if (Recorder.record) {
            Recorder.record("resetThreshold");
        }
    }

    void doSet(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        boolean bl;
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        if (d == -808080.0) {
            d = this.scaleUp(imageProcessor, 85.0);
            d2 = this.scaleUp(imageProcessor, 170.0);
        }
        Calibration calibration = imagePlus.getCalibration();
        int n = imageProcessor instanceof FloatProcessor || calibration.calibrated() ? 2 : 0;
        d = calibration.getCValue(d);
        d2 = calibration.getCValue(d2);
        GenericDialog genericDialog = new GenericDialog("Set Threshold Levels");
        genericDialog.addNumericField("Lower Threshold Level: ", d, n);
        genericDialog.addNumericField("Upper Threshold Level: ", d2, n);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        d = genericDialog.getNextNumber();
        d2 = genericDialog.getNextNumber();
        d = calibration.getRawValue(d);
        if ((d2 = calibration.getRawValue(d2)) < d) {
            d2 = d;
        }
        double d3 = imageProcessor.getMin();
        double d4 = imageProcessor.getMax();
        imageProcessor.resetMinAndMax();
        double d5 = imageProcessor.getMin();
        double d6 = imageProcessor.getMax();
        if (d < d5) {
            d = d5;
        }
        if (d2 > d6) {
            d2 = d6;
        }
        boolean bl2 = bl = d < d3 || d2 > d4;
        if (bl) {
            this.plot.setHistogram(imagePlus);
        } else {
            imageProcessor.setMinAndMax(d3, d4);
        }
        this.minThreshold = this.scaleDown(imageProcessor, d);
        this.maxThreshold = this.scaleDown(imageProcessor, d2);
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
        if (Recorder.record) {
            Recorder.record("setThreshold", (int)imageProcessor.getMinThreshold(), (int)imageProcessor.getMaxThreshold());
        }
    }

    void changeState(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
    }

    void autoThreshold(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (!(imageProcessor instanceof ByteProcessor)) {
            return;
        }
        ImageStatistics imageStatistics = imagePlus.getStatistics(24);
        int n = ((ByteProcessor)imageProcessor).getAutoThreshold();
        if (imageStatistics.max - (double)imageStatistics.mode < (double)imageStatistics.mode - imageStatistics.min) {
            this.minThreshold = imageStatistics.min;
            this.maxThreshold = n;
        } else {
            this.minThreshold = n;
            this.maxThreshold = imageStatistics.max;
        }
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
        if (Recorder.record) {
            Recorder.record("setThreshold", (int)imageProcessor.getMinThreshold(), (int)imageProcessor.getMaxThreshold());
        }
    }

    void apply() {
        try {
            IJ.run("Threshold");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        while (!this.done) {
            ThresholdAdjuster thresholdAdjuster = this;
            synchronized (thresholdAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int n;
        int n2 = this.minValue;
        int n3 = this.maxValue;
        if (this.doReset) {
            n = 0;
        } else if (this.doAutoAdjust) {
            n = 1;
        } else if (this.doApplyLut) {
            n = 3;
        } else if (this.doStateChange) {
            n = 4;
        } else if (this.doSet) {
            n = 7;
        } else if (this.minValue >= 0) {
            n = 5;
        } else if (this.maxValue >= 0) {
            n = 6;
        } else {
            return;
        }
        this.minValue = -1;
        this.maxValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doApplyLut = false;
        this.doStateChange = false;
        this.doSet = false;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        ImageProcessor imageProcessor = this.setup(imagePlus);
        if (imageProcessor == null) {
            imagePlus.unlock();
            IJ.beep();
            IJ.showStatus("RGB images cannot be thresolded");
            return;
        }
        switch (n) {
            case 0: {
                this.reset(imagePlus, imageProcessor);
                break;
            }
            case 1: {
                this.autoThreshold(imagePlus, imageProcessor);
                break;
            }
            case 3: {
                this.apply();
                break;
            }
            case 4: {
                this.changeState(imagePlus, imageProcessor);
                break;
            }
            case 7: {
                this.doSet(imagePlus, imageProcessor);
                break;
            }
            case 5: {
                this.adjustMinThreshold(imagePlus, imageProcessor, n2);
                break;
            }
            case 6: {
                this.adjustMaxThreshold(imagePlus, imageProcessor, n3);
            }
        }
        this.updatePlot();
        this.updateLabels(imagePlus, imageProcessor);
        imageProcessor.setLutAnimation(true);
        imagePlus.updateAndDraw();
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        instance = null;
        this.done = true;
        ThresholdAdjuster thresholdAdjuster = this;
        synchronized (thresholdAdjuster) {
            this.notify();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        mode = 0;
    }
}

