/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.Prefs;
import ij.process.Blitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;

public class FloatBlitter
implements Blitter {
    public static float divideByZeroValue = (float)Prefs.getDouble("div-by-zero", 3.4028234663852886E38);
    private FloatProcessor ip;
    private int width;
    private int height;
    private float[] pixels;

    public FloatBlitter(FloatProcessor floatProcessor) {
        this.ip = floatProcessor;
        this.width = floatProcessor.getWidth();
        this.height = floatProcessor.getHeight();
        this.pixels = (float[])floatProcessor.getPixels();
    }

    public void setTransparentColor(Color color) {
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        int n4 = imageProcessor.getWidth();
        int n5 = imageProcessor.getHeight();
        Rectangle rectangle = new Rectangle(n4, n5);
        rectangle.setLocation(n, n2);
        Rectangle rectangle2 = new Rectangle(this.width, this.height);
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        float[] fArray = (float[])imageProcessor.getPixels();
        rectangle = rectangle.intersection(rectangle2);
        int n6 = n < 0 ? -n : 0;
        int n7 = n2 < 0 ? -n2 : 0;
        int n8 = rectangle.y;
        while (n8 < rectangle.y + rectangle.height) {
            int n9 = (n8 - n2) * n4 + (rectangle.x - n);
            int n10 = n8 * this.width + rectangle.x;
            switch (n3) {
                case 0: 
                case 1: {
                    int n11 = rectangle.width;
                    while (--n11 >= 0) {
                        this.pixels[n10++] = fArray[n9++];
                    }
                    break;
                }
                case 3: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        this.pixels[n10] = fArray[n9] + this.pixels[n10];
                        ++n9;
                        ++n10;
                    }
                    break;
                }
                case 7: {
                    float f2;
                    int n13 = rectangle.width;
                    while (--n13 >= 0) {
                        f2 = (fArray[n9++] + this.pixels[n10]) / 2.0f;
                        this.pixels[n10++] = f2;
                    }
                    break;
                }
                case 8: {
                    float f2;
                    int n14 = rectangle.width;
                    while (--n14 >= 0) {
                        f2 = this.pixels[n10] - fArray[n9];
                        this.pixels[n10] = f2 < 0.0f ? -f2 : f2;
                        ++n9;
                        ++n10;
                    }
                    break;
                }
                case 4: {
                    int n15 = rectangle.width;
                    while (--n15 >= 0) {
                        this.pixels[n10] = this.pixels[n10] - fArray[n9];
                        ++n9;
                        ++n10;
                    }
                    break;
                }
                case 5: {
                    int n16 = rectangle.width;
                    while (--n16 >= 0) {
                        this.pixels[n10] = fArray[n9] * this.pixels[n10];
                        ++n9;
                        ++n10;
                    }
                    break;
                }
                case 6: {
                    float f;
                    int n17 = rectangle.width;
                    while (--n17 >= 0) {
                        f = fArray[n9];
                        this.pixels[n10] = (double)f == 0.0 ? divideByZeroValue : this.pixels[n10] / f;
                        ++n9;
                        ++n10;
                    }
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 12: {
                    float f;
                    float f2;
                    int n18 = rectangle.width;
                    while (--n18 >= 0) {
                        int n19 = n9++;
                        f = fArray[n19];
                        f2 = this.pixels[n10];
                        if (f < f2) {
                            f2 = f;
                        }
                        this.pixels[n10++] = f2;
                    }
                    break;
                }
                case 13: {
                    float f;
                    float f2;
                    int n20 = rectangle.width;
                    while (--n20 >= 0) {
                        int n21 = n9++;
                        f = fArray[n21];
                        f2 = this.pixels[n10];
                        if (f > f2) {
                            f2 = f;
                        }
                        this.pixels[n10++] = f2;
                    }
                    break;
                }
            }
            if (n8 % 20 == 0) {
                imageProcessor.showProgress((double)(n8 - rectangle.y) / (double)rectangle.height);
            }
            ++n8;
        }
        imageProcessor.hideProgress();
    }
}

