/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.measure.Calibration;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Roi
implements Cloneable {
    public static final int CONSTRUCTING = 0;
    public static final int MOVING = 1;
    public static final int RESIZING = 2;
    public static final int NORMAL = 3;
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int POLYGON = 2;
    public static final int FREEROI = 3;
    public static final int TRACED_ROI = 4;
    public static final int LINE = 5;
    public static final int POLYLINE = 6;
    public static final int FREELINE = 7;
    public static final int HANDLE_SIZE = 4;
    int startX;
    int startY;
    int x;
    int y;
    int width;
    int height;
    int state;
    public static Roi previousRoi = null;
    protected static Color ROIColor = Prefs.getColor("roicolor", Color.yellow);
    protected static int pasteMode = 0;
    protected int type;
    protected int xMax;
    protected int yMax;
    protected ImagePlus imp;
    protected ImageCanvas ic;
    protected int oldX;
    protected int oldY;
    protected int oldWidth;
    protected int oldHeight;
    protected int clipX;
    protected int clipY;
    protected int clipWidth;
    protected int clipHeight;
    protected ImagePlus clipboard = null;
    protected boolean constrain = false;
    protected boolean updateFullWindow;

    public Roi(int n, int n2, int n3, int n4) {
        this.setImage(null);
        if (n3 > this.xMax) {
            n3 = this.xMax;
        }
        if (n4 > this.yMax) {
            n4 = this.yMax;
        }
        this.x = n;
        this.y = n2;
        this.startX = n;
        this.startY = n2;
        this.oldX = n;
        this.oldY = n2;
        this.oldWidth = 0;
        this.oldHeight = 0;
        this.width = n3;
        this.height = n4;
        this.oldWidth = n3;
        this.oldHeight = n4;
        this.clipX = n;
        this.clipY = n2;
        this.clipWidth = n3;
        this.clipHeight = n4;
        this.state = 3;
        this.type = 0;
        if (this.ic != null) {
            Graphics graphics = this.ic.getGraphics();
            this.draw(graphics);
            graphics.dispose();
        }
    }

    public Roi(int n, int n2, ImagePlus imagePlus) {
        this.setImage(imagePlus);
        this.setLocation(n, n2);
        this.width = 0;
        this.height = 0;
        this.state = 0;
        this.type = 0;
    }

    public Roi(int n, int n2, int n3, int n4, ImagePlus imagePlus) {
        this(n, n2, n3, n4);
        this.setImage(imagePlus);
    }

    public void setLocation(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n + this.width > this.xMax) {
            n = this.xMax - this.width;
        }
        if (n2 + this.height > this.yMax) {
            n2 = this.yMax - this.height;
        }
        this.x = n;
        this.y = n2;
        this.startX = n;
        this.startY = n2;
        this.oldX = n;
        this.oldY = n2;
        this.oldWidth = 0;
        this.oldHeight = 0;
    }

    public void setImage(ImagePlus imagePlus) {
        this.imp = imagePlus;
        if (imagePlus == null) {
            this.ic = null;
            this.xMax = 99999;
            this.yMax = 99999;
        } else {
            ImageWindow imageWindow = imagePlus.getWindow();
            if (imageWindow != null) {
                this.ic = imageWindow.getCanvas();
            }
            this.xMax = imagePlus.getWidth();
            this.yMax = imagePlus.getHeight();
        }
    }

    public int getType() {
        return this.type;
    }

    public int getState() {
        return this.state;
    }

    public double getLength() {
        double d = 1.0;
        double d2 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
        }
        return 2.0 * (double)this.width * d + 2.0 * (double)this.height * d2;
    }

    public double getFeretsDiameter() {
        double d = 1.0;
        double d2 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
        }
        return Math.sqrt((double)(this.width * this.width) * d * d + (double)(this.height * this.height) * d2 * d2);
    }

    public Rectangle getBoundingRect() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public synchronized Object clone() {
        try {
            Roi roi = (Roi)super.clone();
            previousRoi = null;
            roi.imp = null;
            return roi;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void grow(int n, int n2) {
        if (this.clipboard != null) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.constrain) {
            int n3 = n - this.x;
            int n4 = n2 - this.y;
            int n5 = n3 < n4 ? n3 : n4;
            n = this.x + n5;
            n2 = this.y + n5;
        }
        this.width = Math.abs(n - this.startX);
        this.height = Math.abs(n2 - this.startY);
        this.x = n >= this.startX ? this.startX : this.startX - this.width;
        int n6 = this.y = n2 >= this.startY ? this.startY : this.startY - this.height;
        if (this.x + this.width > this.xMax) {
            this.width = this.xMax - this.x;
        }
        if (this.y + this.height > this.yMax) {
            this.height = this.yMax - this.y;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    void move(int n, int n2) {
        this.x += n - this.startX;
        this.y += n2 - this.startY;
        if (this.x < 0) {
            this.x = 0;
        }
        if (this.y < 0) {
            this.y = 0;
        }
        if (this.x + this.width > this.xMax) {
            this.x = this.xMax - this.width;
        }
        if (this.y + this.height > this.yMax) {
            this.y = this.yMax - this.height;
        }
        this.startX = n;
        this.startY = n2;
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    public void nudge(int n) {
        switch (n) {
            case 38: {
                --this.y;
                if (this.y >= 0) break;
                this.y = 0;
                break;
            }
            case 40: {
                ++this.y;
                if (this.y + this.height < this.yMax) break;
                this.y = this.yMax - this.height;
                break;
            }
            case 37: {
                --this.x;
                if (this.x >= 0) break;
                this.x = 0;
                break;
            }
            case 39: {
                ++this.x;
                if (this.x + this.width < this.xMax) break;
                this.x = this.xMax - this.width;
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
    }

    public void nudgeCorner(int n) {
        if (this.type > 1 || this.clipboard != null) {
            return;
        }
        switch (n) {
            case 38: {
                --this.height;
                if (this.height >= 1) break;
                this.height = 1;
                break;
            }
            case 40: {
                ++this.height;
                if (this.y + this.height <= this.yMax) break;
                this.height = this.yMax - this.y;
                break;
            }
            case 37: {
                --this.width;
                if (this.width >= 1) break;
                this.width = 1;
                break;
            }
            case 39: {
                ++this.width;
                if (this.x + this.width <= this.xMax) break;
                this.width = this.xMax - this.x;
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
    }

    protected void updateClipRect() {
        double d;
        this.clipX = this.x <= this.oldX ? this.x : this.oldX;
        this.clipY = this.y <= this.oldY ? this.y : this.oldY;
        this.clipWidth = (this.x + this.width >= this.oldX + this.oldWidth ? this.x + this.width : this.oldX + this.oldWidth) - this.clipX + 1;
        this.clipHeight = (this.y + this.height >= this.oldY + this.oldHeight ? this.y + this.height : this.oldY + this.oldHeight) - this.clipY + 1;
        if (this.ic != null && (d = this.ic.getMagnification()) < 1.0) {
            this.clipWidth += (int)(1.0 / d);
            this.clipHeight += (int)(1.0 / d);
        }
        if (this.type != 0) {
            if (this.clipboard == null) {
                this.clipWidth += 2;
                this.clipHeight += 2;
                --this.clipX;
                --this.clipY;
            } else {
                this.clipWidth += 5;
                this.clipHeight += 5;
            }
        }
    }

    protected void handleMouseDrag(int n, int n2, boolean bl) {
        this.constrain = bl;
        int n3 = this.ic.offScreenX(n);
        int n4 = this.ic.offScreenY(n2);
        switch (this.state) {
            case 0: {
                this.grow(n3, n4);
                break;
            }
            case 1: {
                this.move(n3, n4);
                break;
            }
        }
    }

    int getHandleSize() {
        double d = this.ic.getMagnification();
        double d2 = 4.0 / d;
        return (int)(d2 * d);
    }

    public void draw(Graphics graphics) {
        double d = this.ic.getMagnification();
        graphics.setColor(ROIColor);
        int n = this.ic.screenX(this.x);
        int n2 = this.ic.screenY(this.y);
        int n3 = n + (int)((double)this.width * d) - 1;
        int n4 = n2 + (int)((double)this.height * d) - 1;
        graphics.drawRect(n, n2, n3 - n, n4 - n2);
        if (n3 - n > 2 && n4 - n2 > 2) {
            int n5 = this.getHandleSize();
            graphics.fillRect(n3 - 4, n4 - 4, 4, 4);
        }
        this.showStatus();
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public void drawPixels() {
        this.endPaste();
        this.imp.getProcessor().drawRect(this.x, this.y, this.width, this.height);
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.x, this.y, this.width, this.height);
        return rectangle.contains(n, n2);
    }

    boolean insideHandle(int n, int n2) {
        if (this.type != 0) {
            return false;
        }
        return n >= this.ic.screenX(this.x + this.width) - 8 && n2 >= this.ic.screenY(this.y + this.height) - 8;
    }

    protected void handleMouseDown(int n, int n2) {
        if (this.state == 3) {
            if (this.insideHandle(n, n2)) {
                this.state = 0;
                this.startX = this.x;
                this.startY = this.y;
            } else {
                this.state = 1;
                this.startX = this.ic.offScreenX(n);
                this.startY = this.ic.offScreenY(n2);
            }
            this.showStatus();
        }
    }

    protected void handleMouseUp(int n, int n2) {
        this.state = 3;
        if (Recorder.record) {
            if (this.type == 5) {
                if (this.imp == null) {
                    return;
                }
                Line line = (Line)this.imp.getRoi();
                Recorder.record("makeLine", line.x1, line.y1, line.x2, line.y2);
            } else if (this.type == 1) {
                Recorder.record("makeOval", this.x, this.y, this.width, this.height);
            } else {
                Recorder.record("makeRectangle", this.x, this.y, this.width, this.height);
            }
        }
    }

    protected void showStatus() {
        String string;
        Object object;
        if (this.state != 0 && this.type == 0 && this.width <= 25 && this.height <= 25) {
            object = this.imp.getProcessor();
            double d = ((ImageProcessor)object).getPixelValue(this.x, this.y);
            int n = this.imp.getType() == 0 || this.imp.getType() == 1 ? 0 : 2;
            string = ", value=" + IJ.d2s(d, n);
        } else {
            string = "";
        }
        object = this.imp.getCalibration();
        String string2 = ((Calibration)object).scaled() ? ", w=" + IJ.d2s((double)this.width * ((Calibration)object).pixelWidth) + " (" + this.width + "), h=" + IJ.d2s((double)this.height * ((Calibration)object).pixelHeight) + " (" + this.height + ")" : ", width=" + this.width + ", height=" + this.height;
        IJ.showStatus(this.imp.getLocationAsString(this.x, this.y) + string2 + string);
    }

    public int[] getMask() {
        return null;
    }

    void startPaste(ImagePlus imagePlus) {
        IJ.showStatus("Pasting...");
        this.clipboard = imagePlus;
        this.imp.getProcessor().snapshot();
        this.updateClipRect();
        if (IJ.debugMode) {
            IJ.log("startPaste: " + this.clipX + " " + this.clipY + " " + this.clipWidth + " " + this.clipHeight);
        }
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    void updatePaste() {
        if (this.clipboard != null) {
            ImageProcessor imageProcessor = this.imp.getProcessor();
            imageProcessor.reset();
            imageProcessor.copyBits(this.clipboard.getProcessor(), this.x, this.y, pasteMode);
            if (this.type != 0) {
                imageProcessor.reset(this.imp.getMask());
            }
            this.ic.setImageUpdated();
        }
    }

    public void endPaste() {
        if (this.clipboard != null) {
            ImageProcessor imageProcessor = this.imp.getProcessor();
            if (pasteMode != 0) {
                imageProcessor.reset();
            }
            imageProcessor.copyBits(this.clipboard.getProcessor(), this.x, this.y, pasteMode);
            if (this.type != 0) {
                imageProcessor.reset(this.imp.getMask());
            }
            imageProcessor.snapshot();
            this.clipboard = null;
            this.imp.updateAndDraw();
            Undo.setup(1, this.imp);
        }
    }

    public void abortPaste() {
        this.clipboard = null;
        this.imp.getProcessor().reset();
        this.imp.updateAndDraw();
    }

    public double getAngle(int n, int n2, int n3, int n4) {
        double d = n3 - n;
        double d2 = n2 - n4;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d *= calibration.pixelWidth;
            d2 *= calibration.pixelHeight;
        }
        double d3 = d != 0.0 ? Math.atan(d2 / d) : (d2 >= 0.0 ? 1.5707963267948966 : -1.5707963267948966);
        d3 = 57.29577951308232 * d3;
        int n5 = d >= 0.0 && d2 >= 0.0 ? 0 : (d < 0.0 ? 2 : 3);
        switch (n5) {
            case 0: {
                break;
            }
            case 2: {
                d3 += 180.0;
                break;
            }
            case 3: {
                d3 += 360.0;
            }
        }
        return d3;
    }

    public static Color getColor() {
        return ROIColor;
    }

    public static void setColor(Color color) {
        ROIColor = color;
    }

    public static void setPasteMode(int n) {
        int n2 = pasteMode;
        pasteMode = n;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        if (n2 != 0) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            imageProcessor.reset();
            if (pasteMode != 0) {
                // empty if block
            }
        }
        imagePlus.updateAndDraw();
    }

    public String toString() {
        return "Roi: type=" + this.type + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height;
    }
}

