/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import ij.util.Java2;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class TextRoi
extends Roi {
    static final int MAX_LINES = 50;
    private String[] theText = new String[50];
    private static String name = "SansSerif";
    private static int style = 0;
    private static int size = 18;
    private static Font font;
    private double previousMag;
    private boolean firstChar = true;
    private boolean firstMouseUp = true;
    private int cline = 0;

    public TextRoi(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        double d;
        ImageWindow imageWindow = imagePlus.getWindow();
        double d2 = d = imageWindow != null ? imageWindow.getCanvas().getMagnification() : 1.0;
        if (d > 1.0) {
            d = 1.0;
        }
        if ((double)size < 12.0 / d) {
            size = (int)(12.0 / d);
        }
        this.theText[0] = "Type, then";
        this.theText[1] = "Ctl+D";
        if (Roi.previousRoi != null && Roi.previousRoi instanceof TextRoi) {
            this.firstMouseUp = false;
            Roi.previousRoi = null;
        }
    }

    public void addChar(char c) {
        if (c < ' ' && c != '\b' && c != '\n') {
            return;
        }
        if (this.firstChar) {
            this.cline = 0;
            this.theText[this.cline] = new String("");
            int n = 1;
            while (n < 50) {
                this.theText[n] = null;
                ++n;
            }
        }
        if (c == '\b') {
            if (this.theText[this.cline].length() > 0) {
                this.theText[this.cline] = this.theText[this.cline].substring(0, this.theText[this.cline].length() - 1);
            } else if (this.cline > 0) {
                this.theText[this.cline] = null;
                --this.cline;
            }
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.firstChar = false;
            return;
        }
        if (c == '\n') {
            if (this.cline < 49) {
                ++this.cline;
            }
        } else {
            char[] cArray = new char[]{c};
            int n = this.cline;
            this.theText[n] = this.theText[n] + new String(cArray);
            this.adjustSize();
            this.updateClipRect();
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.firstChar = false;
            return;
        }
        this.theText[this.cline] = "";
        this.adjustSize();
    }

    Font getCurrentFont() {
        double d = this.ic.getMagnification();
        if (font == null || d != this.previousMag) {
            font = new Font(name, style, (int)((double)size * d));
            this.previousMag = d;
        }
        return font;
    }

    public void drawPixels() {
        if (this.imp == null) {
            return;
        }
        ImageProcessor imageProcessor = this.imp.getProcessor();
        Font font = new Font(name, style, size);
        imageProcessor.setFont(font);
        imageProcessor.setAntialiasedText(true);
        FontMetrics fontMetrics = imageProcessor.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getDescent();
        int n3 = 0;
        int n4 = 0;
        while (n3 < 50 && this.theText[n3] != null) {
            imageProcessor.drawString(this.theText[n3], this.x, this.y + n4 + n);
            ++n3;
            n4 += n;
        }
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        double d = this.ic.getMagnification();
        int n = this.ic.screenX(this.x);
        int n2 = this.ic.screenY(this.y);
        int n3 = (int)((double)this.width * d);
        int n4 = (int)((double)this.height * d);
        if (IJ.isJava2()) {
            Java2.setAntialiasedText(graphics, true);
        }
        if (font == null) {
            this.adjustSize();
        }
        Font font = this.getCurrentFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n5 = fontMetrics.getHeight();
        int n6 = fontMetrics.getDescent();
        graphics.setFont(font);
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setClip(n, n2, n3, n4);
        int n7 = 0;
        while (n7 < 50 && this.theText[n7] != null) {
            graphics.drawString(this.theText[n7], n, n2 + n5 - n6);
            ++n7;
            n2 += n5;
        }
        if (rectangle != null) {
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public static String getFont() {
        return name;
    }

    public static int getSize() {
        return size;
    }

    public static int getStyle() {
        return style;
    }

    public static void setFont(String string, int n, int n2) {
        Roi roi;
        name = string;
        size = n;
        style = n2;
        font = null;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null && (roi = imagePlus.getRoi()) instanceof TextRoi) {
            imagePlus.draw();
        }
    }

    protected void handleMouseUp(int n, int n2) {
        super.handleMouseUp(n, n2);
        if (this.firstMouseUp) {
            this.adjustSize();
            this.firstMouseUp = false;
        } else if (this.width < 5 || this.height < 5) {
            this.imp.killRoi();
        }
    }

    void adjustSize() {
        if (this.ic == null) {
            return;
        }
        double d = this.ic.getMagnification();
        Font font = this.getCurrentFont();
        Graphics graphics = this.ic.getGraphics();
        if (IJ.isJava2()) {
            Java2.setAntialiasedText(graphics, true);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = (int)((double)fontMetrics.getHeight() / d);
        int n2 = fontMetrics.getDescent();
        int n3 = 0;
        int n4 = 0;
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.width = 10;
        while (n3 < 50 && this.theText[n3] != null) {
            ++n4;
            int n5 = (int)((double)this.stringWidth(this.theText[n3], fontMetrics, graphics) / d);
            if (n5 > this.width) {
                this.width = n5;
            }
            ++n3;
        }
        graphics.dispose();
        this.width += 2;
        if (this.x + this.width > this.xMax) {
            this.x = this.xMax - this.width;
        }
        this.height = n4 * n + 2;
        if (this.height > this.yMax) {
            this.height = this.yMax;
        }
        if (this.y + this.height > this.yMax) {
            this.y = this.yMax - this.height;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    int stringWidth(String string, FontMetrics fontMetrics, Graphics graphics) {
        if (IJ.isJava2()) {
            return Java2.getStringWidth(string, fontMetrics, graphics);
        }
        return fontMetrics.stringWidth(string);
    }
}

