/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class Wand {
    static final int UP = 0;
    static final int DOWN = 1;
    static final int UP_OR_DOWN = 2;
    static final int LEFT = 3;
    static final int RIGHT = 4;
    static final int LEFT_OR_RIGHT = 5;
    static final int NA = 6;
    public int npoints;
    private int maxPoints = 1000;
    public int[] xpoints = new int[this.maxPoints];
    public int[] ypoints = new int[this.maxPoints];
    private ImageProcessor ip;
    private byte[] bpixels;
    private int[] cpixels;
    private short[] spixels;
    private float[] fpixels;
    private int width;
    private int height;
    private float lowerThreshold;
    private float upperThreshold;

    public Wand(ImageProcessor imageProcessor) {
        if (imageProcessor instanceof ByteProcessor) {
            this.bpixels = (byte[])imageProcessor.getPixels();
        } else if (imageProcessor instanceof ColorProcessor) {
            this.cpixels = (int[])imageProcessor.getPixels();
        } else if (imageProcessor instanceof ShortProcessor) {
            this.spixels = (short[])imageProcessor.getPixels();
        } else if (imageProcessor instanceof FloatProcessor) {
            this.fpixels = (float[])imageProcessor.getPixels();
        }
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
    }

    private float getColorPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.cpixels[n2 * this.width + n];
        }
        return Float.MAX_VALUE;
    }

    private float getBytePixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.bpixels[n2 * this.width + n] & 0xFF;
        }
        return Float.MAX_VALUE;
    }

    private float getShortPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.spixels[n2 * this.width + n] & 0xFFFF;
        }
        return Float.MAX_VALUE;
    }

    private float getFloatPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.fpixels[n2 * this.width + n];
        }
        return Float.MAX_VALUE;
    }

    private float getPixel(int n, int n2) {
        if (this.bpixels != null) {
            return this.getBytePixel(n, n2);
        }
        if (this.spixels != null) {
            return this.getShortPixel(n, n2);
        }
        if (this.fpixels != null) {
            return this.getFloatPixel(n, n2);
        }
        return this.getColorPixel(n, n2);
    }

    private boolean inside(int n, int n2) {
        float f = this.bpixels != null ? this.getBytePixel(n, n2) : (this.spixels != null ? this.getShortPixel(n, n2) : (this.fpixels != null ? this.getFloatPixel(n, n2) : this.getColorPixel(n, n2)));
        return f >= this.lowerThreshold && f <= this.upperThreshold;
    }

    boolean isLine(int n, int n2) {
        int n3;
        int n4;
        int n5 = 5;
        int n6 = n;
        int n7 = n + 2 * n5;
        if (n7 >= this.width) {
            n7 = this.width - 1;
        }
        if ((n4 = n2 - n5) < 0) {
            n4 = 0;
        }
        if ((n3 = n2 + n5) >= this.height) {
            n3 = this.height - 1;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = n6;
        while (n10 <= n7) {
            int n11 = n4;
            while (n11 <= n3) {
                ++n8;
                if (this.inside(n10, n11)) {
                    ++n9;
                }
                ++n11;
            }
            ++n10;
        }
        if (IJ.debugMode) {
            IJ.log(((double)n9 / (double)n8 >= 0.75 ? "line " : "blob ") + n9 + " " + n8 + " " + IJ.d2s((double)n9 / (double)n8));
        }
        return (double)n9 / (double)n8 >= 0.75;
    }

    public void autoOutline(int n, int n2) {
        int n3;
        int n4 = n;
        int n5 = n2;
        this.lowerThreshold = this.upperThreshold = this.getPixel(n, n2);
        while (this.inside(++n4, n5)) {
        }
        if (this.isLine(n4, n5)) {
            this.lowerThreshold = this.upperThreshold = this.getPixel(n4, n5);
            n3 = 0;
        } else {
            n3 = !this.inside(n4 - 1, n5 - 1) ? 4 : (this.inside(n4, n5 - 1) ? 3 : 1);
        }
        this.traceEdge(n4, n5, n3);
    }

    public void autoOutline(int n, int n2, double d, double d2) {
        int n3;
        this.npoints = 0;
        int n4 = n;
        int n5 = n2;
        this.lowerThreshold = (float)d;
        this.upperThreshold = (float)d2;
        if (this.inside(n4, n5)) {
            while (this.inside(++n4, n5)) {
            }
            n3 = !this.inside(n4 - 1, n5 - 1) ? 4 : (this.inside(n4, n5 - 1) ? 3 : 1);
        } else {
            while (!this.inside(++n4, n5) && n4 < this.width) {
            }
            n3 = 0;
            if (n4 >= this.width) {
                return;
            }
        }
        this.traceEdge(n4, n5, n3);
    }

    public void autoOutline(int n, int n2, int n3, int n4) {
        this.autoOutline(n, n2, (double)n3, (double)n4);
    }

    void traceEdge(int n, int n2, int n3) {
        int[] nArray = new int[]{6, 4, 1, 4, 0, 0, 2, 0, 3, 5, 1, 4, 3, 3, 1, 6};
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        boolean bl = this.inside(n4 - 1, n5 - 1);
        boolean bl2 = this.inside(n4, n5 - 1);
        boolean bl3 = this.inside(n4 - 1, n5);
        boolean bl4 = this.inside(n4, n5);
        int n7 = 0;
        do {
            int n8;
            int n9 = 0;
            if (bl4) {
                n9 |= 1;
            }
            if (bl3) {
                n9 |= 2;
            }
            if (bl2) {
                n9 |= 4;
            }
            if (bl) {
                n9 |= 8;
            }
            if ((n8 = nArray[n9]) == 2) {
                n8 = n6 == 4 ? 0 : 1;
            }
            if (n8 == 5) {
                n8 = n6 == 0 ? 3 : 4;
            }
            if (n8 != n6) {
                this.xpoints[n7] = n4;
                this.ypoints[n7] = n5;
                if (++n7 == this.xpoints.length) {
                    int[] nArray2 = new int[this.maxPoints * 2];
                    int[] nArray3 = new int[this.maxPoints * 2];
                    System.arraycopy(this.xpoints, 0, nArray2, 0, this.maxPoints);
                    System.arraycopy(this.ypoints, 0, nArray3, 0, this.maxPoints);
                    this.xpoints = nArray2;
                    this.ypoints = nArray3;
                    this.maxPoints *= 2;
                }
            }
            switch (n8) {
                case 0: {
                    bl3 = bl;
                    bl4 = bl2;
                    bl = this.inside(n4 - 1, --n5 - 1);
                    bl2 = this.inside(n4, n5 - 1);
                    break;
                }
                case 1: {
                    bl = bl3;
                    bl2 = bl4;
                    bl3 = this.inside(n4 - 1, ++n5);
                    bl4 = this.inside(n4, n5);
                    break;
                }
                case 3: {
                    bl2 = bl;
                    bl4 = bl3;
                    bl = this.inside(--n4 - 1, n5 - 1);
                    bl3 = this.inside(n4 - 1, n5);
                    break;
                }
                case 4: {
                    bl = bl2;
                    bl3 = bl4;
                    bl2 = this.inside(++n4, n5 - 1);
                    bl4 = this.inside(n4, n5);
                }
            }
            n6 = n8;
        } while (n4 != n || n5 != n2 || n6 != n3);
        this.npoints = n7;
    }
}

