/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.FileInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageReader {
    private FileInfo fi;
    private int width;
    private int height;
    private int skipCount;
    private int bytesPerPixel;
    private int bufferSize;
    private int byteCount;
    private int nPixels;
    private boolean showProgressBar = true;
    private int eofErrorCount;

    public ImageReader(FileInfo fileInfo) {
        this.fi = fileInfo;
        this.width = fileInfo.width;
        this.height = fileInfo.height;
        this.skipCount = fileInfo.offset;
    }

    void eofError() {
        ++this.eofErrorCount;
    }

    byte[] read8bitImage(InputStream inputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[this.nPixels];
        while (n < this.byteCount) {
            int n2 = n + this.bufferSize > this.nPixels ? this.nPixels - n : this.bufferSize;
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                this.eofError();
                break;
            }
            this.showProgress((double)(n += n3) / (double)this.byteCount);
        }
        return byArray;
    }

    private void showProgress(double d) {
        if (this.showProgressBar) {
            IJ.showProgress(d);
        }
    }

    short[] read16bitImage(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.bufferSize];
        short[] sArray = new short[this.nPixels];
        int n = 0;
        int n2 = 0;
        while (n < this.byteCount) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (n + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - n;
            }
            int n7 = 0;
            while (n7 < this.bufferSize) {
                int n8 = inputStream.read(byArray, n7, this.bufferSize - n7);
                if (n8 == -1) {
                    this.eofError();
                    if (this.fi.fileType == 1) {
                        n6 = n2;
                        while (n6 < sArray.length) {
                            sArray[n6] = Short.MIN_VALUE;
                            ++n6;
                        }
                    }
                    return sArray;
                }
                n7 += n8;
            }
            this.showProgress((double)(n += this.bufferSize) / (double)this.byteCount);
            int n9 = this.bufferSize / this.bytesPerPixel;
            if (this.fi.intelByteOrder) {
                if (this.fi.fileType == 1) {
                    n6 = n2;
                    n5 = 0;
                    while (n6 < n2 + n9) {
                        sArray[n6] = (short)(((byArray[n5 + 1] & 0xFF) << 8 | byArray[n5] & 0xFF) + 32768);
                        ++n6;
                        n5 += 2;
                    }
                } else {
                    n4 = n2;
                    n3 = 0;
                    while (n4 < n2 + n9) {
                        sArray[n4] = (short)((byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF);
                        ++n4;
                        n3 += 2;
                    }
                }
            } else if (this.fi.fileType == 1) {
                n6 = n2;
                n5 = 0;
                while (n6 < n2 + n9) {
                    sArray[n6] = (short)(((byArray[n5] & 0xFF) << 8 | byArray[n5 + 1] & 0xFF) + 32768);
                    ++n6;
                    n5 += 2;
                }
            } else {
                n4 = n2;
                n3 = 0;
                while (n4 < n2 + n9) {
                    sArray[n4] = (short)((byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF);
                    ++n4;
                    n3 += 2;
                }
            }
            n2 += n9;
        }
        return sArray;
    }

    float[] read32bitImage(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.bufferSize];
        float[] fArray = new float[this.nPixels];
        int n = 0;
        int n2 = 0;
        while (n < this.byteCount) {
            int n3;
            if (n + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - n;
            }
            int n4 = 0;
            while (n4 < this.bufferSize) {
                int n5 = inputStream.read(byArray, n4, this.bufferSize - n4);
                if (n5 == -1) {
                    this.eofError();
                    return fArray;
                }
                n4 += n5;
            }
            this.showProgress((double)(n += this.bufferSize) / (double)this.byteCount);
            int n6 = this.bufferSize / this.bytesPerPixel;
            int n7 = 0;
            if (this.fi.intelByteOrder) {
                int n8 = n2;
                while (n8 < n2 + n6) {
                    n3 = (byArray[n7 + 3] & 0xFF) << 24 | (byArray[n7 + 2] & 0xFF) << 16 | (byArray[n7 + 1] & 0xFF) << 8 | byArray[n7] & 0xFF;
                    fArray[n8] = this.fi.fileType == 4 ? Float.intBitsToFloat(n3) : (this.fi.fileType == 11 ? (float)((long)n3 & 0xFFFFFFFFL) : (float)n3);
                    n7 += 4;
                    ++n8;
                }
            } else {
                int n9 = n2;
                while (n9 < n2 + n6) {
                    n3 = (byArray[n7] & 0xFF) << 24 | (byArray[n7 + 1] & 0xFF) << 16 | (byArray[n7 + 2] & 0xFF) << 8 | byArray[n7 + 3] & 0xFF;
                    fArray[n9] = this.fi.fileType == 4 ? Float.intBitsToFloat(n3) : (this.fi.fileType == 11 ? (float)((long)n3 & 0xFFFFFFFFL) : (float)n3);
                    n7 += 4;
                    ++n9;
                }
            }
            n2 += n6;
        }
        return fArray;
    }

    int[] readChunkyRGB(InputStream inputStream) throws IOException {
        this.bufferSize = 24 * this.width;
        byte[] byArray = new byte[this.bufferSize];
        int[] nArray = new int[this.nPixels];
        int n = 0;
        int n2 = 0;
        while (n < this.byteCount) {
            if (n + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - n;
            }
            int n3 = 0;
            while (n3 < this.bufferSize) {
                int n4 = inputStream.read(byArray, n3, this.bufferSize - n3);
                if (n4 == -1) {
                    this.eofError();
                    return nArray;
                }
                n3 += n4;
            }
            this.showProgress((double)(n += this.bufferSize) / (double)this.byteCount);
            int n5 = this.bufferSize / this.bytesPerPixel;
            boolean bl = this.fi.fileType == 10;
            int n6 = 0;
            int n7 = n2;
            while (n7 < n2 + n5) {
                if (this.bytesPerPixel == 4) {
                    // empty if block
                }
                int n8 = ++n6;
                int n9 = byArray[n8] & 0xFF;
                int n10 = ++n6;
                int n11 = byArray[n10] & 0xFF;
                int n12 = ++n6;
                ++n6;
                int n13 = byArray[n12] & 0xFF;
                nArray[n7] = bl ? 0xFF000000 | n13 << 16 | n11 << 8 | n9 : 0xFF000000 | n9 << 16 | n11 << 8 | n13;
                ++n7;
            }
            n2 += n5;
        }
        return nArray;
    }

    int[] readPlanarRGB(InputStream inputStream) throws IOException {
        int n = this.nPixels;
        byte[] byArray = new byte[n];
        int[] nArray = new int[this.nPixels];
        int n2 = 0;
        this.showProgress(0.12);
        int n3 = inputStream.read(byArray, 0, n);
        if (n3 == -1) {
            this.eofError();
            return nArray;
        }
        n2 += n3;
        int n4 = 0;
        while (n4 < n) {
            int n5 = byArray[n4] & 0xFF;
            nArray[n4] = 0xFF000000 | n5 << 16;
            ++n4;
        }
        this.showProgress(0.37);
        n3 = inputStream.read(byArray, 0, n);
        if (n3 == -1) {
            this.eofError();
            return nArray;
        }
        n2 += n3;
        int n6 = 0;
        while (n6 < n) {
            int n7 = byArray[n6] & 0xFF;
            int n8 = n6++;
            nArray[n8] = nArray[n8] | n7 << 8;
        }
        this.showProgress(0.62);
        n3 = inputStream.read(byArray, 0, n);
        if (n3 == -1) {
            this.eofError();
            return nArray;
        }
        n2 += n3;
        int n9 = 0;
        while (n9 < n) {
            int n10 = byArray[n9] & 0xFF;
            int n11 = n9++;
            nArray[n11] = nArray[n11] | n10;
        }
        this.showProgress(0.87);
        return nArray;
    }

    void skip(InputStream inputStream) throws IOException {
        if (this.skipCount > 0) {
            int n = 0;
            int n2 = 0;
            while (n < this.skipCount) {
                long l = inputStream.skip(this.skipCount - n);
                if (l == -1L || ++n2 > 5) break;
                n = (int)((long)n + l);
            }
        }
        this.byteCount = this.width * this.height * this.bytesPerPixel;
        this.nPixels = this.width * this.height;
        this.bufferSize = this.byteCount / 25;
        this.bufferSize = this.bufferSize < 8192 ? 8192 : this.bufferSize / 8192 * 8192;
    }

    public Object readPixels(InputStream inputStream) {
        try {
            switch (this.fi.fileType) {
                case 0: 
                case 5: {
                    this.bytesPerPixel = 1;
                    this.skip(inputStream);
                    return this.read8bitImage(inputStream);
                }
                case 1: 
                case 2: {
                    this.bytesPerPixel = 2;
                    this.skip(inputStream);
                    return this.read16bitImage(inputStream);
                }
                case 3: 
                case 4: 
                case 11: {
                    this.bytesPerPixel = 4;
                    this.skip(inputStream);
                    return this.read32bitImage(inputStream);
                }
                case 6: 
                case 9: 
                case 10: {
                    this.bytesPerPixel = this.fi.fileType == 9 ? 4 : 3;
                    this.skip(inputStream);
                    return this.readChunkyRGB(inputStream);
                }
                case 7: {
                    this.bytesPerPixel = 3;
                    this.skip(inputStream);
                    return this.readPlanarRGB(inputStream);
                }
                case 8: {
                    this.bytesPerPixel = 1;
                    this.skip(inputStream);
                    byte[] byArray = this.read8bitImage(inputStream);
                    this.expandBitmap(byArray);
                    return byArray;
                }
            }
            return null;
        }
        catch (IOException iOException) {
            IJ.write("" + iOException);
            return null;
        }
    }

    public Object readPixels(InputStream inputStream, int n) {
        this.skipCount = n;
        this.showProgressBar = false;
        Object object = this.readPixels(inputStream);
        if (this.eofErrorCount > 0) {
            return null;
        }
        return object;
    }

    public Object readPixels(String string) {
        InputStream inputStream;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            IJ.write("" + malformedURLException);
            return null;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            IJ.write("" + iOException);
            return null;
        }
        return this.readPixels(inputStream);
    }

    void expandBitmap(byte[] byArray) {
        int n = this.width / 8;
        int n2 = this.width % 8;
        if (n2 > 0) {
            ++n;
        }
        int n3 = n * this.height;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.height) {
            int n6 = n5 * n;
            int n7 = 0;
            while (n7 < n) {
                if (n4 + 8 < this.width * this.height) {
                    int n8 = byArray2[n6 + n7] & 0xFF;
                    int n9 = 7;
                    while (n9 >= 0) {
                        int n10 = (n8 & 1 << n9) != 0 ? 255 : 0;
                        byArray[n4++] = (byte)n10;
                        --n9;
                    }
                }
                ++n7;
            }
            n4 -= n2 > 0 ? 8 - n2 : 0;
            ++n5;
        }
    }
}

