/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.DicomDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.IOException;

public class DICOM
extends ImagePlus
implements PlugIn {
    public void run(String string) {
        Object object;
        FileInfo fileInfo;
        DicomDecoder dicomDecoder;
        String string2;
        block13: {
            OpenDialog openDialog = new OpenDialog("Open Dicom...", string);
            String string3 = openDialog.getDirectory();
            string2 = openDialog.getFileName();
            if (string2 == null) {
                return;
            }
            IJ.showStatus("Opening: " + string3 + string2);
            dicomDecoder = new DicomDecoder(string3, string2);
            fileInfo = null;
            try {
                fileInfo = dicomDecoder.getFileInfo();
            }
            catch (IOException iOException) {
                object = iOException.getMessage();
                IJ.showStatus("");
                if (((String)object).indexOf("EOF") < 0) {
                    IJ.showMessage("DicomDecoder", (String)object);
                    return;
                }
                if (dicomDecoder.dicmFound()) break block13;
                object = "This does not appear to be a valid\nDICOM file. It does not have the\ncharacters 'DICM' at offset 128.";
                IJ.showMessage("DicomDecoder", (String)object);
                return;
            }
        }
        if (fileInfo != null && fileInfo.width > 0 && fileInfo.height > 0 && fileInfo.offset > 0) {
            FileOpener fileOpener = new FileOpener(fileInfo);
            object = fileOpener.open(false);
            if (fileInfo.fileType == 1 && ((ImagePlus)object).getStackSize() == 1) {
                this.convertToUnsigned((ImagePlus)object, fileInfo);
            }
            if (dicomDecoder.windowWidth > 0.0) {
                ImageProcessor imageProcessor = ((ImagePlus)object).getProcessor();
                double d = dicomDecoder.windowCenter - dicomDecoder.windowWidth / 2.0;
                double d2 = dicomDecoder.windowCenter + dicomDecoder.windowWidth / 2.0;
                if (fileInfo.fileType == 1) {
                    d += 32768.0;
                    d2 += 32768.0;
                }
                imageProcessor.setMinAndMax(d, d2);
                if (IJ.debugMode) {
                    IJ.log("window: " + d + "-" + d2);
                }
            }
            if (((ImagePlus)object).getStackSize() > 1) {
                this.setStack(string2, ((ImagePlus)object).getStack());
            } else {
                this.setProcessor(string2, ((ImagePlus)object).getProcessor());
            }
            this.setCalibration(((ImagePlus)object).getCalibration());
            this.setProperty("Info", dicomDecoder.getDicomInfo());
            this.setFileInfo(fileInfo);
            if (string.equals("")) {
                this.show();
            }
        } else {
            IJ.showMessage("DicomDecoder", "Unable to decode DICOM header.");
        }
        IJ.showStatus("");
    }

    void convertToUnsigned(ImagePlus imagePlus, FileInfo fileInfo) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        short[] sArray = (short[])imageProcessor.getPixels();
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (n2 < sArray.length) {
            int n3 = sArray[n2] & 0xFFFF;
            if (n3 < n) {
                n = n3;
            }
            ++n2;
        }
        if (IJ.debugMode) {
            IJ.log("min: " + (n - 32768));
        }
        if (n >= 32768) {
            int n4 = 0;
            while (n4 < sArray.length) {
                sArray[n4] = (short)(sArray[n4] - 32768);
                ++n4;
            }
            imageProcessor.resetMinAndMax();
            Calibration calibration = imagePlus.getCalibration();
            calibration.setFunction(20, null, "Gray Value");
            fileInfo.fileType = 2;
        }
    }
}

