/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.StackProcessor;
import java.awt.Color;

public class Thresholder
implements PlugIn,
Measurements {
    private int slice;
    private double minThreshold;
    private double maxThreshold;
    boolean autoThreshold;
    ImageStack stack1;
    static boolean fill1 = true;
    static boolean fill2 = true;
    static boolean useBW = true;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if (imagePlus.getStackSize() == 1) {
            Undo.setup(4, imagePlus);
            this.applyThreshold(imagePlus);
            Undo.setup(5, imagePlus);
        } else {
            Undo.reset();
            this.applyThreshold(imagePlus);
        }
    }

    void applyThreshold(ImagePlus imagePlus) {
        if (!imagePlus.lock()) {
            return;
        }
        imagePlus.killRoi();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        double d3 = imageProcessor.getMin();
        double d4 = imageProcessor.getMax();
        boolean bl = this.autoThreshold = d == -808080.0;
        if (imagePlus.getType() != 0) {
            this.convertToByte(imagePlus);
        }
        imageProcessor = imagePlus.getProcessor();
        if (this.autoThreshold) {
            this.autoThreshold(imagePlus);
        } else {
            if (Recorder.record) {
                Recorder.record("setThreshold", (int)d, (int)d2);
            }
            this.minThreshold = (d - d3) / (d4 - d3) * 255.0;
            this.maxThreshold = (d2 - d3) / (d4 - d3) * 255.0;
        }
        boolean bl2 = true;
        if (!this.autoThreshold) {
            GenericDialog genericDialog = new GenericDialog("Apply Lut");
            genericDialog.addCheckbox("Thresholded pixels to foreground color", fill1);
            genericDialog.addCheckbox("Remaining pixels to background color", fill2);
            genericDialog.addMessage("");
            genericDialog.addCheckbox("Black foreground, white background", useBW);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                imagePlus.unlock();
                return;
            }
            fill1 = genericDialog.getNextBoolean();
            fill2 = genericDialog.getNextBoolean();
            useBW = bl2 = genericDialog.getNextBoolean();
        } else {
            fill1 = true;
            fill2 = true;
        }
        imageProcessor.resetThreshold();
        int n = imageProcessor.getPixel(0, 0);
        if (bl2) {
            imageProcessor.setColor(Color.black);
        } else {
            imageProcessor.setColor(Toolbar.getForegroundColor());
        }
        imageProcessor.drawPixel(0, 0);
        int n2 = imageProcessor.getPixel(0, 0);
        if (bl2) {
            imageProcessor.setColor(Color.white);
        } else {
            imageProcessor.setColor(Toolbar.getBackgroundColor());
        }
        imageProcessor.drawPixel(0, 0);
        int n3 = imageProcessor.getPixel(0, 0);
        imageProcessor.setColor(Toolbar.getForegroundColor());
        imageProcessor.putPixel(0, 0, n);
        int[] nArray = new int[256];
        int n4 = 0;
        while (n4 < 256) {
            nArray[n4] = (double)n4 >= this.minThreshold && (double)n4 <= this.maxThreshold ? (int)((byte)(fill1 ? n2 : (byte)n4)) : (int)((byte)(fill2 ? n3 : (byte)n4));
            ++n4;
        }
        int n5 = IJ.setupDialog(imagePlus, 0);
        if (n5 == 4096) {
            if (this.stack1 != null) {
                imagePlus.setStack(null, this.stack1);
            }
            imagePlus.unlock();
            return;
        }
        if (n5 == 32) {
            new StackProcessor(imagePlus.getStack(), imageProcessor).applyTable(nArray);
        } else {
            imageProcessor.applyTable(nArray);
        }
        imagePlus.updateAndDraw();
        imagePlus.unlock();
    }

    void convertToByte(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        int n = imagePlus.getCurrentSlice();
        this.stack1 = imagePlus.getStack();
        ImageStack imageStack = imagePlus.createEmptyStack();
        int n2 = imagePlus.getStackSize();
        int n3 = 1;
        while (n3 <= n2) {
            String string = this.stack1.getSliceLabel(1);
            imageProcessor = this.stack1.getProcessor(n3);
            imageProcessor.setMinAndMax(d, d2);
            imageStack.addSlice(string, imageProcessor.convertToByte(true));
            ++n3;
        }
        imagePlus.setStack(null, imageStack);
        imagePlus.setSlice(n);
        imagePlus.setCalibration(imagePlus.getCalibration());
    }

    void autoThreshold(ImagePlus imagePlus) {
        ImageStatistics imageStatistics = imagePlus.getStatistics(24);
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n = ((ByteProcessor)imageProcessor).getAutoThreshold();
        if (imageStatistics.max - (double)imageStatistics.mode < (double)imageStatistics.mode - imageStatistics.min) {
            this.minThreshold = imageStatistics.min;
            this.maxThreshold = n;
        } else {
            this.minThreshold = n;
            this.maxThreshold = imageStatistics.max;
        }
    }
}

