/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;

public class WindowOrganizer
implements PlugIn {
    private static final int XSTART = 4;
    private static final int YSTART = 80;
    private static final int XOFFSET = 8;
    private static final int YOFFSET = 24;
    private static final int MAXSTEP = 200;
    private static final int GAP = 2;
    private int titlebarHeight = IJ.isMacintosh() ? 40 : 20;

    public void run(String string) {
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.noImage();
            return;
        }
        if (string.equals("tile")) {
            this.tileWindows(nArray);
        } else {
            this.cascadeWindows(nArray);
        }
    }

    void tileWindows(int[] nArray) {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        boolean bl2 = true;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n9 = 0;
        while (n9 < nArray.length) {
            ImageWindow imageWindow = this.getWindow(nArray[n9]);
            if (imageWindow != null) {
                Dimension dimension2 = imageWindow.getSize();
                int n10 = dimension2.width;
                int n11 = dimension2.height + this.titlebarHeight;
                if (n9 == 0) {
                    n7 = n10;
                    n8 = n11;
                }
                if (n10 != n7 || n11 != n8) {
                    bl2 = false;
                }
                if (n10 < n5) {
                    n5 = n10;
                }
                if (n11 < n6) {
                    n6 = n11;
                }
                d += (double)n10;
                d2 += (double)n11;
            }
            ++n9;
        }
        int n12 = nArray.length;
        double d3 = d / (double)n12;
        double d4 = d2 / (double)n12;
        int n13 = (int)d3;
        int n14 = (int)d4;
        int n15 = dimension.width - 4;
        if (n13 > n15) {
            n13 = n15;
        }
        if (n14 > (n4 = dimension.height - 80)) {
            n14 = n4;
        }
        do {
            n3 = 4;
            n2 = 80;
            bl = true;
            n = 0;
            do {
                ++n;
                if (n3 + n13 > dimension.width) {
                    n3 = 4;
                    if ((n2 += n14) + n14 > dimension.height) {
                        bl = false;
                    }
                }
                n3 = n3 + n13 + 2;
            } while (bl & n < n12);
            if (bl) continue;
            n13 = (int)((double)n13 * 0.98 + 0.5);
            n14 = (int)((double)n14 * 0.98 + 0.5);
        } while (!bl);
        n = (dimension.width - 4) / (n13 + 2);
        int n16 = n12 / n;
        if (n12 % n != 0) {
            ++n16;
        }
        n3 = 4;
        n2 = 80;
        int n17 = 0;
        while (n17 < n12) {
            ImageWindow imageWindow;
            if (n3 + n13 > dimension.width) {
                n3 = 4;
                n2 += n14;
            }
            if ((imageWindow = this.getWindow(nArray[n17])) != null) {
                ((Component)imageWindow).setLocation(n3, n2);
                ImageCanvas imageCanvas = imageWindow.getCanvas();
                while ((double)imageWindow.getSize().width * 0.85 >= (double)n13 && imageCanvas.getMagnification() > 0.03125) {
                    imageCanvas.zoomOut(0, 0);
                }
                imageWindow.toFront();
            }
            n3 += n13 + 2;
            ++n17;
        }
    }

    ImageWindow getWindow(int n) {
        ImageWindow imageWindow = null;
        ImagePlus imagePlus = WindowManager.getImage(n);
        if (imagePlus != null) {
            imageWindow = imagePlus.getWindow();
        }
        return imageWindow;
    }

    void cascadeWindows(int[] nArray) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 4;
        int n2 = 80;
        int n3 = 0;
        int n4 = 4;
        int n5 = 0;
        while (n5 < nArray.length) {
            ImageWindow imageWindow = this.getWindow(nArray[n5]);
            if (imageWindow != null) {
                Dimension dimension2 = imageWindow.getSize();
                if (n5 == 0 && (n3 = (int)((double)dimension2.width * 0.8)) > 200) {
                    n3 = 200;
                }
                if ((double)n2 + (double)dimension2.height * 0.67 > (double)dimension.height) {
                    if ((double)(n4 += n3) + (double)dimension2.width * 0.67 > (double)dimension.width) {
                        n4 = 12;
                    }
                    n = n4;
                    n2 = 80;
                }
                ((Component)imageWindow).setLocation(n, n2);
                imageWindow.toFront();
                n += 8;
                n2 += 24;
            }
            ++n5;
        }
    }
}

