/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Properties;

public class Printer
implements PlugInFilter {
    private ImagePlus imp;
    private static double scaling = 100.0;
    private static boolean drawBorder = false;
    private static boolean center = true;
    private static boolean label = false;
    private static Properties printPrefs = new Properties();
    static /* synthetic */ Class class$ij$plugin$filter$Printer;

    public int setup(String string, ImagePlus imagePlus) {
        if (string.equals("setup")) {
            this.pageSetup();
            return 4096;
        }
        this.imp = imagePlus;
        IJ.register(class$ij$plugin$filter$Printer == null ? (class$ij$plugin$filter$Printer = Printer.class$("ij.plugin.filter.Printer")) : class$ij$plugin$filter$Printer);
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        this.print(this.imp);
    }

    void pageSetup() {
        GenericDialog genericDialog = new GenericDialog("Page Setup");
        genericDialog.addNumericField("Scaling (5-500%):", scaling, 0);
        genericDialog.addCheckbox("Draw Border", drawBorder);
        genericDialog.addCheckbox("Center on Page", center);
        genericDialog.addCheckbox("Print Title", label);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        scaling = genericDialog.getNextNumber();
        if (scaling < 5.0) {
            scaling = 5.0;
        }
        drawBorder = genericDialog.getNextBoolean();
        center = genericDialog.getNextBoolean();
        label = genericDialog.getNextBoolean();
    }

    void print(ImagePlus imagePlus) {
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow == null) {
            return;
        }
        ImageCanvas imageCanvas = imageWindow.getCanvas();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob printJob = toolkit.getPrintJob(imageWindow, imagePlus.getTitle(), printPrefs);
        if (printJob == null) {
            return;
        }
        imagePlus.startTiming();
        Graphics graphics = printJob.getGraphics();
        if (graphics == null) {
            return;
        }
        Dimension dimension = printJob.getPageDimension();
        if (IJ.debugMode) {
            IJ.log("pageSize: " + dimension);
        }
        double d = scaling / 100.0;
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = (int)((double)n * d);
        int n4 = (int)((double)n2 * d);
        int n5 = 20;
        int n6 = 0;
        int n7 = dimension.width - n5 * 2;
        int n8 = dimension.height - (n5 + n6) * 2;
        graphics.setColor(Color.black);
        if (label) {
            n6 = 15;
            graphics.setFont(new Font("SanSerif", 0, 12));
            graphics.drawString(imagePlus.getTitle(), n5 + 5, n5 + n6 - 3);
        }
        Image image = imagePlus.getImage();
        if (n > n7 || n2 > n8) {
            double d2 = (double)n7 / (double)n;
            double d3 = (double)n8 / (double)n2;
            d = d2 <= d3 ? d2 : d3;
            n3 = (int)((double)n * d);
            n4 = (int)((double)n2 * d);
            if (System.getProperty("os.name").startsWith("Windows") && System.getProperty("java.version").startsWith("1.3.1")) {
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                imageProcessor.setInterpolate(true);
                image = imageProcessor.resize(n3, n4).createImage();
            }
        }
        if (center && n < n7 && n2 < n8) {
            graphics.translate((dimension.width - n) / 2, n6 + (dimension.height - n2) / 2);
        } else {
            graphics.translate(n5, n5 + n6);
        }
        if (drawBorder) {
            graphics.drawRect(-1, -1, n3 + 1, n4 + 1);
        }
        graphics.drawImage(image, 0, 0, n3, n4, null);
        graphics.dispose();
        printJob.end();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

