/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class RGBStackSplitter
implements PlugInFilter {
    ImagePlus imp;
    public ImageStack red;
    public ImageStack green;
    public ImageStack blue;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 272;
    }

    public void run(ImageProcessor imageProcessor) {
        this.split(this.imp);
    }

    public void split(ImagePlus imagePlus) {
        this.split(imagePlus.getStack(), true);
        String string = imagePlus.getTitle();
        imagePlus.hide();
        new ImagePlus(string + " (red)", this.red).show();
        if (IJ.isMacOSX()) {
            IJ.wait(500);
        }
        new ImagePlus(string + " (green)", this.green).show();
        if (IJ.isMacOSX()) {
            IJ.wait(500);
        }
        new ImagePlus(string + " (blue)", this.blue).show();
    }

    public void split(ImageStack imageStack, boolean bl) {
        int n = imageStack.getWidth();
        int n2 = imageStack.getHeight();
        this.red = new ImageStack(n, n2);
        this.green = new ImageStack(n, n2);
        this.blue = new ImageStack(n, n2);
        int n3 = 1;
        int n4 = bl ? 1 : 0;
        int n5 = imageStack.getSize();
        int n6 = 1;
        while (n6 <= n5) {
            IJ.showStatus(n6 + "/" + n5);
            byte[] byArray = new byte[n * n2];
            byte[] byArray2 = new byte[n * n2];
            byte[] byArray3 = new byte[n * n2];
            ColorProcessor colorProcessor = (ColorProcessor)imageStack.getProcessor(n3);
            n3 += n4;
            colorProcessor.getRGB(byArray, byArray2, byArray3);
            if (!bl) {
                imageStack.deleteSlice(1);
            }
            this.red.addSlice(null, byArray);
            this.green.addSlice(null, byArray2);
            this.blue.addSlice(null, byArray3);
            IJ.showProgress((double)n6 / (double)n5);
            ++n6;
        }
    }
}

