/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Rectangle;

public class Scaler
implements PlugInFilter {
    private ImagePlus imp;
    private static double xscale = 0.5;
    private static double yscale = 0.5;
    private static boolean newWindow = true;
    private static boolean interpolate = true;
    static /* synthetic */ Class class$ij$plugin$filter$Scaler;

    public int setup(String string, ImagePlus imagePlus) {
        Roi roi;
        this.imp = imagePlus;
        IJ.register(class$ij$plugin$filter$Scaler == null ? (class$ij$plugin$filter$Scaler = Scaler.class$("ij.plugin.filter.Scaler")) : class$ij$plugin$filter$Scaler);
        if (imagePlus != null && (roi = imagePlus.getRoi()) != null && roi.getType() > 4) {
            imagePlus.killRoi();
        }
        return 31;
    }

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Scale", IJ.getInstance());
        genericDialog.addNumericField("X Scale (0.05-25):", xscale, 2);
        genericDialog.addNumericField("Y Scale (0.05-25):", yscale, 2);
        genericDialog.addCheckbox("Create New Window", newWindow);
        genericDialog.addCheckbox("Interpolate", interpolate);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        xscale = genericDialog.getNextNumber();
        yscale = genericDialog.getNextNumber();
        if (genericDialog.invalidNumber()) {
            IJ.error("X or Y scale are invalid.");
            return;
        }
        if (xscale > 25.0) {
            xscale = 25.0;
        }
        if (xscale < 0.05) {
            xscale = 0.05;
        }
        if (yscale > 25.0) {
            yscale = 25.0;
        }
        if (yscale < 0.05) {
            yscale = 0.05;
        }
        newWindow = genericDialog.getNextBoolean();
        interpolate = genericDialog.getNextBoolean();
        imageProcessor.setInterpolate(interpolate);
        this.imp.startTiming();
        try {
            if (newWindow) {
                Rectangle rectangle = imageProcessor.getRoi();
                int n = (int)(xscale * (double)rectangle.width);
                int n2 = (int)(yscale * (double)rectangle.height);
                ImagePlus imagePlus = this.imp.createImagePlus();
                imagePlus.setProcessor("Untitled", imageProcessor.resize(n, n2));
                Calibration calibration = imagePlus.getCalibration();
                if (calibration.scaled()) {
                    calibration.pixelWidth *= 1.0 / xscale;
                    calibration.pixelHeight *= 1.0 / yscale;
                    this.imp.setCalibration(calibration);
                }
                imagePlus.show();
                this.imp.trimProcessor();
                imagePlus.trimProcessor();
            } else {
                if (this.imp.getStackSize() > 1) {
                    Undo.reset();
                }
                StackProcessor stackProcessor = new StackProcessor(this.imp.getStack(), imageProcessor);
                stackProcessor.scale(xscale, yscale);
                this.imp.killRoi();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("Scale");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

