/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.MessageDialog;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.SaveDialog;
import ij.plugin.frame.PlugInFrame;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;

public class RoiManager
extends PlugInFrame
implements ActionListener,
ItemListener {
    Panel panel;
    static Frame instance;
    List list;
    Hashtable rois = new Hashtable();

    public RoiManager() {
        super("ROI Manager");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        this.setLayout(new FlowLayout(1, 5, 5));
        int n = 18;
        this.list = new List(n, true);
        this.list.add("012345678901234567");
        this.list.addItemListener(this);
        this.add(this.list);
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(10, 1, 5, 5));
        this.addButton("Add");
        this.addButton("Add & Draw");
        this.addButton("Delete");
        this.addButton("Open");
        this.addButton("Open All");
        this.addButton("Save");
        this.addButton("Select All");
        this.addButton("Measure");
        this.addButton("Draw");
        this.addButton("Fill");
        this.add(this.panel);
        this.pack();
        this.list.remove(0);
        GUI.center(this);
        this.show();
    }

    void addButton(String string) {
        Button button = new Button(string);
        button.addActionListener(this);
        this.panel.add(button);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        String string2 = string;
        if (string2.equals("Add")) {
            this.add();
        }
        if (string2.equals("Add & Draw")) {
            this.addAndDraw();
        } else if (string2.equals("Delete")) {
            this.delete();
        } else if (string2.equals("Open")) {
            this.open();
        } else if (string2.equals("Open All")) {
            this.openAll();
        } else if (string2.equals("Save")) {
            this.save();
        } else if (string2.equals("Select All")) {
            this.selectAll();
        } else if (string2.equals("Measure")) {
            this.measure();
        } else if (string2.equals("Draw")) {
            this.draw();
        } else if (string2.equals("Fill")) {
            this.fill();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && WindowManager.getCurrentImage() != null) {
            int n = 0;
            try {
                n = Integer.parseInt(itemEvent.getItem().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.restore(n);
        }
    }

    boolean add() {
        ImagePlus imagePlus = this.getImage();
        if (imagePlus == null) {
            return false;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            this.error("The active image does not have an ROI.");
            return false;
        }
        String string = null;
        switch (roi.getType()) {
            case 0: {
                string = "Rectangle";
                break;
            }
            case 1: {
                string = "Oval";
                break;
            }
            case 2: {
                string = "Polygon";
                break;
            }
            case 3: {
                string = "Freehand";
                break;
            }
            case 4: {
                string = "Traced";
                break;
            }
            case 5: {
                string = "Line";
                break;
            }
            case 6: {
                string = "Polyline";
                break;
            }
            case 7: {
                string = "Freeline";
            }
        }
        if (string == null) {
            return false;
        }
        Rectangle rectangle = roi.getBoundingRect();
        String string2 = string + (rectangle.x + rectangle.width / 2) + "-" + (rectangle.y + rectangle.height / 2);
        this.list.add(string2);
        this.rois.put(string2, roi.clone());
        return true;
    }

    void addAndDraw() {
        if (this.add()) {
            this.list.select(this.list.getItemCount() - 1);
            this.draw();
        }
    }

    boolean delete() {
        if (this.list.getItemCount() == 0) {
            return this.error("The ROI list is empty.");
        }
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            return this.error("At least one ROI in the list must be selected.");
        }
        int n = nArray.length - 1;
        while (n >= 0) {
            this.rois.remove(this.list.getItem(nArray[n]));
            this.list.remove(nArray[n]);
            --n;
        }
        return true;
    }

    boolean restore(int n) {
        String string = this.list.getItem(n);
        Roi roi = (Roi)this.rois.get(string);
        ImagePlus imagePlus = this.getImage();
        if (imagePlus == null) {
            return false;
        }
        Rectangle rectangle = roi.getBoundingRect();
        if (rectangle.x + rectangle.width > imagePlus.getWidth() || rectangle.y + rectangle.height > imagePlus.getHeight()) {
            return this.error("This ROI does not fit the current image.");
        }
        imagePlus.setRoi(roi);
        return true;
    }

    void open() {
        Macro.setOptions(null);
        OpenDialog openDialog = new OpenDialog("Open ROI...", "");
        String string = openDialog.getDirectory();
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return;
        }
        Opener opener = new Opener();
        String string3 = string + string2;
        Roi roi = opener.openRoi(string3);
        if (roi != null) {
            this.list.add(string2);
            this.rois.put(string2, roi);
        }
    }

    void openAll() {
        Macro.setOptions(null);
        Macro.setOptions(null);
        OpenDialog openDialog = new OpenDialog("Select a file in the folder...", "");
        if (openDialog.getFileName() == null) {
            return;
        }
        String string = openDialog.getDirectory();
        String[] stringArray = new File(string).list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            Roi roi;
            File file = new File(string + stringArray[n]);
            if (!file.isDirectory() && stringArray[n].endsWith(".roi") && (roi = new Opener().openRoi(string + stringArray[n])) != null) {
                this.list.add(stringArray[n]);
                this.rois.put(stringArray[n], roi);
            }
            ++n;
        }
    }

    boolean save() {
        if (this.list.getItemCount() == 0) {
            return this.error("The ROI list is empty.");
        }
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            return this.error("At least one ROI in the list must be selected.");
        }
        String string = this.list.getItem(nArray[0]);
        Macro.setOptions(null);
        SaveDialog saveDialog = new SaveDialog("Save ROI...", string, ".roi");
        string = saveDialog.getFileName();
        if (string == null) {
            return false;
        }
        String string2 = saveDialog.getDirectory();
        int n = 0;
        while (n < nArray.length) {
            if (!this.restore(nArray[n])) break;
            if (nArray.length > 1) {
                string = this.list.getItem(nArray[n]) + ".roi";
            }
            IJ.run("ROI...", "path='" + string2 + string + "'");
            ++n;
        }
        return true;
    }

    void selectAll() {
        boolean bl = true;
        int n = this.list.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (!this.list.isIndexSelected(n2)) {
                bl = false;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            if (bl) {
                this.list.deselect(n3);
            } else {
                this.list.select(n3);
            }
            ++n3;
        }
    }

    boolean measure() {
        ImagePlus imagePlus = this.getImage();
        if (imagePlus == null) {
            return false;
        }
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            return this.error("At least one ROI must be selected from the list.");
        }
        int n = IJ.setupDialog(imagePlus, 0);
        if (n == 4096) {
            return false;
        }
        int n2 = n == 32 ? imagePlus.getStackSize() : 1;
        int n3 = imagePlus.getCurrentSlice();
        int n4 = 1;
        while (n4 <= n2) {
            imagePlus.setSlice(n4);
            int n5 = 0;
            while (n5 < nArray.length) {
                if (!this.restore(nArray[n5])) break;
                IJ.run("Measure");
                ++n5;
            }
            ++n4;
        }
        imagePlus.setSlice(n3);
        if (nArray.length > 1) {
            IJ.run("Select None");
        }
        return true;
    }

    boolean fill() {
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            return this.error("At least one ROI must be selected from the list.");
        }
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        Undo.setup(4, imagePlus);
        int n = 0;
        while (n < nArray.length) {
            if (!this.restore(nArray[n])) break;
            IJ.run("Fill");
            IJ.run("Select None");
            ++n;
        }
        Undo.setup(5, imagePlus);
        return true;
    }

    boolean draw() {
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            return this.error("At least one ROI must be selected from the list.");
        }
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        Undo.setup(4, imagePlus);
        int n = 0;
        while (n < nArray.length) {
            if (!this.restore(nArray[n])) break;
            IJ.run("Draw");
            IJ.run("Select None");
            ++n;
        }
        Undo.setup(5, imagePlus);
        return true;
    }

    ImagePlus getImage() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            this.error("There are no images open.");
            return null;
        }
        return imagePlus;
    }

    boolean error(String string) {
        new MessageDialog((Frame)this, "ROI Manager", string);
        return false;
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            instance = null;
        }
    }

    public static RoiManager getInstance() {
        return (RoiManager)instance;
    }

    public Hashtable getROIs() {
        return this.rois;
    }

    public List getList() {
        return this.list;
    }
}

