/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.Blitter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class ColorBlitter
implements Blitter {
    private ColorProcessor ip;
    private int width;
    private int height;
    private int[] pixels;
    private int transparent = 0xFFFFFF;

    public ColorBlitter(ColorProcessor colorProcessor) {
        this.ip = colorProcessor;
        this.width = colorProcessor.getWidth();
        this.height = colorProcessor.getHeight();
        this.pixels = (int[])colorProcessor.getPixels();
    }

    public void setTransparentColor(Color color) {
        this.transparent = color.getRGB() & 0xFFFFFF;
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        int n4;
        int[] nArray;
        int n5;
        int n6 = imageProcessor.getWidth();
        int n7 = imageProcessor.getHeight();
        Rectangle rectangle = new Rectangle(n6, n7);
        rectangle.setLocation(n, n2);
        Rectangle rectangle2 = new Rectangle(this.width, this.height);
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        if (imageProcessor instanceof ByteProcessor) {
            byte[] byArray = (byte[])imageProcessor.getPixels();
            ColorModel colorModel = imageProcessor.getColorModel();
            n5 = imageProcessor.getWidth() * imageProcessor.getHeight();
            nArray = new int[n5];
            n4 = 0;
            while (n4 < n5) {
                nArray[n4] = colorModel.getRGB(byArray[n4] & 0xFF);
                ++n4;
            }
        } else {
            nArray = (int[])imageProcessor.getPixels();
        }
        rectangle = rectangle.intersection(rectangle2);
        int n8 = n < 0 ? -n : 0;
        int n9 = n2 < 0 ? -n2 : 0;
        if (n3 == 0 | n3 == 2) {
            int n10 = rectangle.y;
            while (n10 < rectangle.y + rectangle.height) {
                int n11 = (n10 - n2) * n6 + (rectangle.x - n);
                int n12 = n10 * this.width + rectangle.x;
                if (n3 == 0) {
                    int n13 = rectangle.width;
                    while (--n13 >= 0) {
                        this.pixels[n12++] = nArray[n11++];
                    }
                } else {
                    int n14 = rectangle.width;
                    while (--n14 >= 0) {
                        int n15 = nArray[n11++];
                        int n16 = this.pixels[n12];
                        int n17 = this.pixels[n12++] = (n15 & 0xFFFFFF) == this.transparent ? n16 : n15;
                    }
                }
                ++n10;
            }
            return;
        }
        int n18 = rectangle.y;
        while (n18 < rectangle.y + rectangle.height) {
            int n19 = (n18 - n2) * n6 + (rectangle.x - n);
            int n20 = n18 * this.width + rectangle.x;
            int n21 = rectangle.width;
            while (--n21 >= 0) {
                int n22 = nArray[n19++];
                n5 = (n22 & 0xFF0000) >> 16;
                int n23 = (n22 & 0xFF00) >> 8;
                n4 = n22 & 0xFF;
                int n24 = this.pixels[n20];
                int n25 = (n24 & 0xFF0000) >> 16;
                int n26 = (n24 & 0xFF00) >> 8;
                int n27 = n24 & 0xFF;
                switch (n3) {
                    case 1: {
                        break;
                    }
                    case 3: {
                        n25 = n5 + n25;
                        n26 = n23 + n26;
                        n27 = n4 + n27;
                        if (n25 > 255) {
                            n25 = 255;
                        }
                        if (n26 > 255) {
                            n26 = 255;
                        }
                        if (n27 <= 255) break;
                        n27 = 255;
                        break;
                    }
                    case 7: {
                        n25 = (n5 + n25) / 2;
                        n26 = (n23 + n26) / 2;
                        n27 = (n4 + n27) / 2;
                        break;
                    }
                    case 4: {
                        n26 -= n23;
                        n27 -= n4;
                        if ((n25 -= n5) < 0) {
                            n25 = 0;
                        }
                        if (n26 < 0) {
                            n26 = 0;
                        }
                        if (n27 >= 0) break;
                        n27 = 0;
                        break;
                    }
                    case 8: {
                        if ((n25 -= n5) < 0) {
                            n25 = -n25;
                        }
                        if ((n26 -= n23) < 0) {
                            n26 = -n26;
                        }
                        if ((n27 -= n4) >= 0) break;
                        n27 = -n27;
                        break;
                    }
                    case 5: {
                        n25 = n5 * n25;
                        n26 = n23 * n26;
                        n27 = n4 * n27;
                        if (n25 > 255) {
                            n25 = 255;
                        }
                        if (n26 > 255) {
                            n26 = 255;
                        }
                        if (n27 <= 255) break;
                        n27 = 255;
                        break;
                    }
                    case 6: {
                        n25 = n5 == 0 ? 255 : (n25 /= n5);
                        n26 = n23 == 0 ? 255 : (n26 /= n23);
                        if (n4 == 0) {
                            n27 = 255;
                            break;
                        }
                        n27 /= n4;
                        break;
                    }
                    case 9: {
                        n25 = n5 & n25;
                        n26 = n23 & n26;
                        n27 = n4 & n27;
                        break;
                    }
                    case 10: {
                        n25 = n5 | n25;
                        n26 = n23 | n26;
                        n27 = n4 | n27;
                        break;
                    }
                    case 11: {
                        n25 = n5 ^ n25;
                        n26 = n23 ^ n26;
                        n27 = n4 ^ n27;
                        break;
                    }
                    case 12: {
                        if (n5 < n25) {
                            n25 = n5;
                        }
                        if (n23 < n26) {
                            n26 = n23;
                        }
                        if (n4 >= n27) break;
                        n27 = n4;
                        break;
                    }
                    case 13: {
                        if (n5 > n25) {
                            n25 = n5;
                        }
                        if (n23 > n26) {
                            n26 = n23;
                        }
                        if (n4 <= n27) break;
                        n27 = n4;
                    }
                }
                this.pixels[n20++] = -16777216 + (n25 << 16) + (n26 << 8) + n27;
            }
            if (n18 % 20 == 0) {
                imageProcessor.showProgress((double)(n18 - rectangle.y) / (double)rectangle.height);
            }
            ++n18;
        }
        imageProcessor.hideProgress();
    }
}

