/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Rectangle;

class EllipseFitter {
    static final double HALFPI = 1.5707963267949;
    public double xCenter;
    public double yCenter;
    public double major;
    public double minor;
    public double angle;
    public double theta;
    private int bitCount;
    private double xsum;
    private double ysum;
    private double x2sum;
    private double y2sum;
    private double xysum;
    private int[] mask;
    private int left;
    private int top;
    private int width;
    private int height;
    private double n;
    private double xm;
    private double ym;
    private double u20;
    private double u02;
    private double u11;
    private ImageProcessor ip;
    private double pw;
    private double ph;

    EllipseFitter() {
    }

    public void fit(ImageProcessor imageProcessor, ImageStatistics imageStatistics) {
        this.ip = imageProcessor;
        this.mask = imageProcessor.getMask();
        Rectangle rectangle = imageProcessor.getRoi();
        this.pw = imageStatistics.pw;
        this.ph = imageStatistics.ph;
        this.left = rectangle.x;
        this.top = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        this.getEllipseParam();
    }

    void getEllipseParam() {
        double d = 1.772453851;
        if (this.mask == null) {
            this.major = (double)(this.width * 2) / d;
            this.minor = (double)(this.height * 2) / d;
            this.angle = 0.0;
            this.theta = 0.0;
            if (this.major < this.minor) {
                double d2 = this.major;
                this.major = this.minor;
                this.minor = d2;
                this.angle = 90.0;
                this.theta = 1.5707963267948966;
            }
            this.xCenter = (double)this.left + (double)this.width / 2.0;
            this.yCenter = (double)this.top + (double)this.height / 2.0;
            return;
        }
        this.computeSums();
        this.getMoments();
        double d3 = 4.0 * Math.abs(this.u02 * this.u20 - this.u11 * this.u11);
        if (d3 < 1.0E-6) {
            d3 = 1.0E-6;
        }
        double d4 = this.u02 / d3;
        double d5 = this.u11 / d3;
        double d6 = this.u20 / d3;
        double d7 = this.xm;
        double d8 = this.ym;
        double d9 = d4 - d6;
        if (d9 == 0.0) {
            d9 = 1.0E-6;
        }
        this.theta = 0.5 * Math.atan(2.0 * d5 / d9);
        if (this.theta < 0.0) {
            this.theta += 1.5707963267949;
        }
        if (d5 > 0.0) {
            this.theta += 1.5707963267949;
        } else if (d5 == 0.0) {
            if (d6 > d4) {
                this.theta = 0.0;
                d9 = d6;
                d6 = d4;
                d4 = d9;
            } else if (d4 != d6) {
                this.theta = 1.5707963267949;
            }
        }
        d9 = Math.sin(this.theta);
        if (d9 == 0.0) {
            d9 = 1.0E-6;
        }
        double d10 = d5 * Math.cos(this.theta) / d9;
        this.major = Math.sqrt(1.0 / Math.abs(d6 + d10));
        this.minor = Math.sqrt(1.0 / Math.abs(d4 - d10));
        double d11 = Math.sqrt((double)this.bitCount / (Math.PI * this.major * this.minor));
        this.major = this.major * d11 * 2.0;
        this.minor = this.minor * d11 * 2.0;
        this.angle = 180.0 * this.theta / Math.PI;
        if (this.angle == 180.0) {
            this.angle = 0.0;
        }
        if (this.major < this.minor) {
            d9 = this.major;
            this.major = this.minor;
            this.minor = d9;
        }
        this.xCenter = (double)this.left + d7 + 0.5;
        this.yCenter = (double)this.top + d8 + 0.5;
    }

    void computeSums() {
        this.xsum = 0.0;
        this.ysum = 0.0;
        this.x2sum = 0.0;
        this.y2sum = 0.0;
        this.xysum = 0.0;
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            int n3 = 0;
            int n4 = n * this.width;
            int n5 = 0;
            while (n5 < this.width) {
                if (this.mask[n4 + n5] == -16777216) {
                    ++n2;
                    n3 += n5;
                    this.x2sum += (double)(n5 * n5);
                }
                ++n5;
            }
            this.xsum += (double)n3;
            this.ysum += (double)(n2 * n);
            double d = n;
            double d2 = n3;
            this.xysum += d2 * d;
            this.y2sum += d * d * (double)n2;
            this.bitCount += n2;
            ++n;
        }
    }

    void getMoments() {
        if (this.bitCount == 0) {
            return;
        }
        this.x2sum += 0.08333333 * (double)this.bitCount;
        this.y2sum += 0.08333333 * (double)this.bitCount;
        this.n = this.bitCount;
        double d = this.xsum / this.n;
        double d2 = this.ysum / this.n;
        double d3 = this.x2sum / this.n;
        double d4 = this.y2sum / this.n;
        double d5 = this.xysum / this.n;
        this.xm = d;
        this.ym = d2;
        this.u20 = d3 - d * d;
        this.u02 = d4 - d2 * d2;
        this.u11 = d5 - d * d2;
    }

    public void drawEllipse(ImageProcessor imageProcessor) {
        int n;
        if (this.major == 0.0 && this.minor == 0.0) {
            return;
        }
        int n2 = (int)Math.round(this.xCenter);
        int n3 = (int)Math.round(this.yCenter);
        int n4 = imageProcessor.getHeight();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        double d = Math.sin(this.theta);
        double d2 = Math.cos(this.theta);
        double d3 = 1.0 / this.sqr(this.major / 2.0);
        double d4 = 1.0 / this.sqr(this.minor / 2.0);
        double d5 = d3 * this.sqr(d2) + d4 * this.sqr(d);
        double d6 = (d3 - d4) * d * d2;
        double d7 = d3 * this.sqr(d) + d4 * this.sqr(d2);
        double d8 = -d6 / d5;
        double d9 = 1.0 / d5;
        double d10 = (this.sqr(d6) - d5 * d7) / this.sqr(d5);
        int n5 = (int)Math.floor(Math.sqrt(Math.abs(d9 / d10)));
        if (n5 > n4) {
            n5 = n4;
        }
        if (n5 < 1) {
            n5 = 1;
        }
        int n6 = -n5;
        int n7 = 0;
        while (n7 <= n5) {
            double d11 = Math.sqrt(d10 * this.sqr(n7) + d9);
            double d12 = d8 * (double)n7;
            nArray[n7] = (int)Math.round(d12 - d11);
            nArray2[n7] = (int)Math.round(d12 + d11);
            ++n7;
        }
        int n8 = nArray[n5 - 1];
        int n9 = n6;
        while (n9 < n5) {
            n = n9 < 0 ? nArray2[-n9] : -nArray[n9];
            imageProcessor.moveTo(n2 + n8, n3 + n9);
            imageProcessor.lineTo(n2 + n, n3 + n9);
            n8 = n;
            ++n9;
        }
        int n10 = n5;
        while (n10 > n6) {
            n = n10 < 0 ? nArray[-n10] : -nArray2[n10];
            imageProcessor.moveTo(n2 + n8, n3 + n10);
            imageProcessor.lineTo(n2 + n, n3 + n10);
            n8 = n;
            --n10;
        }
    }

    private double sqr(double d) {
        return d * d;
    }
}

