/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class FloatStatistics
extends ImageStatistics {
    public FloatStatistics(ImageProcessor imageProcessor) {
        this(imageProcessor, 27, null);
    }

    public FloatStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        this.setup(imageProcessor, calibration);
        this.getStatistics(imageProcessor);
        if ((n & 8) != 0) {
            this.getMode();
        }
        if ((n & 0x800) != 0) {
            this.fitEllipse(imageProcessor);
        } else if ((n & 0x20) != 0) {
            this.getCentroid(imageProcessor);
        }
        if ((n & 0x40) != 0) {
            this.getCenterOfMass(imageProcessor);
        }
    }

    void getStatistics(ImageProcessor imageProcessor) {
        double d;
        int n;
        int n2;
        int n3;
        float[] fArray = (float[])imageProcessor.getPixels();
        this.nBins = imageProcessor.getHistogramSize();
        this.histogram = new int[this.nBins];
        double d2 = 0.0;
        double d3 = 0.0;
        int[] nArray = imageProcessor.getMask();
        double d4 = Double.MAX_VALUE;
        double d5 = -1.7976931348623157E308;
        if (nArray != null) {
            int n4 = this.ry;
            int n5 = 0;
            while (n4 < this.ry + this.rh) {
                n3 = n4 * this.width + this.rx;
                n2 = n5 * this.rw;
                n = this.rx;
                while (n < this.rx + this.rw) {
                    if (nArray[n2++] == -16777216) {
                        d = fArray[n3];
                        if (d < d4) {
                            d4 = d;
                        }
                        if (d > d5) {
                            d5 = d;
                        }
                    }
                    ++n3;
                    ++n;
                }
                ++n4;
                ++n5;
            }
        } else {
            n3 = this.ry;
            while (n3 < this.ry + this.rh) {
                n2 = n3 * this.width + this.rx;
                n = this.rx;
                while (n < this.rx + this.rw) {
                    int n6 = n2++;
                    d = fArray[n6];
                    if (d < d4) {
                        d4 = d;
                    }
                    if (d > d5) {
                        d5 = d;
                    }
                    ++n;
                }
                ++n3;
            }
        }
        this.min = d4;
        this.max = d5;
        this.histMin = this.min;
        this.histMax = this.max;
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double d6 = (double)this.nBins / (this.histMax - this.histMin);
        this.pixelCount = 0;
        int n7 = this.ry;
        int n8 = 0;
        while (n7 < this.ry + this.rh) {
            int n9 = n7 * this.width + this.rx;
            int n10 = n8 * this.rw;
            int n11 = this.rx;
            while (n11 < this.rx + this.rw) {
                if (nArray == null || nArray[n10++] == -16777216) {
                    d = fArray[n9];
                    ++this.pixelCount;
                    d2 += d;
                    d3 += d * d;
                    int n12 = (int)(d6 * (d - this.histMin));
                    if (n12 >= this.nBins) {
                        n12 = this.nBins - 1;
                    }
                    int n13 = n12;
                    this.histogram[n13] = this.histogram[n13] + 1;
                }
                ++n9;
                ++n11;
            }
            ++n7;
            ++n8;
        }
        this.min = d4;
        this.max = d5;
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.mean = d2 / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, d2, d3);
    }

    void getMode() {
        this.maxCount = 0;
        int n = 0;
        while (n < this.nBins) {
            int n2 = this.histogram[n];
            if (n2 > this.maxCount) {
                this.maxCount = n2;
                this.mode = n;
            }
            ++n;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize;
    }

    void getCenterOfMass(ImageProcessor imageProcessor) {
        float[] fArray = (float[])imageProcessor.getPixels();
        int[] nArray = imageProcessor.getMask();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.ry;
        int n2 = 0;
        while (n < this.ry + this.rh) {
            int n3 = n * this.width + this.rx;
            int n4 = n2 * this.rw;
            int n5 = this.rx;
            while (n5 < this.rx + this.rw) {
                if (nArray == null || nArray[n4++] == -16777216) {
                    double d4 = (double)fArray[n3] + Double.MIN_VALUE;
                    d += d4;
                    d2 += (double)n5 * d4;
                    d3 += (double)n * d4;
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
        this.xCenterOfMass = (d2 / d + 0.5) * this.pw;
        this.yCenterOfMass = (d3 / d + 0.5) * this.ph;
    }
}

