/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.process.ImageProcessor;

public class Undo {
    public static final int NOTHING = 0;
    public static final int FILTER = 1;
    public static final int TYPE_CONVERSION = 2;
    public static final int PASTE = 3;
    public static final int COMPOUND_FILTER = 4;
    public static final int COMPOUND_FILTER_DONE = 5;
    private static int whatToUndo = 0;
    private static int imageID;
    private static ImageProcessor ipCopy;

    public static void setup(int n, ImagePlus imagePlus) {
        ImageProcessor imageProcessor;
        if (imagePlus == null) {
            Undo.reset();
            return;
        }
        if (n == 1 && whatToUndo == 4) {
            return;
        }
        if (n == 5) {
            if (whatToUndo == 4) {
                whatToUndo = n;
            }
            return;
        }
        whatToUndo = n;
        imageID = imagePlus.getID();
        ipCopy = n == 2 ? imagePlus.getProcessor() : (n == 4 ? ((imageProcessor = imagePlus.getProcessor()) != null ? imageProcessor.duplicate() : null) : null);
    }

    public static void reset() {
        whatToUndo = 0;
        imageID = 0;
        ipCopy = null;
    }

    public static void undo() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imageID != imagePlus.getID()) {
            Undo.reset();
            return;
        }
        switch (whatToUndo) {
            case 1: {
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                if (imageProcessor == null) break;
                imageProcessor.reset();
                imagePlus.updateAndDraw();
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                if (ipCopy == null) break;
                imagePlus.setProcessor(null, ipCopy);
                break;
            }
            case 3: {
                Roi roi = imagePlus.getRoi();
                if (roi == null) break;
                roi.abortPaste();
            }
        }
        Undo.reset();
    }

    static {
        ipCopy = null;
    }
}

