/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.NewImage;
import ij.gui.ProfilePlot;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ClipboardOwner {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int LINE = 2;
    private static final int LEFT_MARGIN = 50;
    private static final int RIGHT_MARGIN = 20;
    private static final int TOP_MARGIN = 20;
    private static final int BOTTOM_MARGIN = 30;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final String MIN = "pp.min";
    private static final String MAX = "pp.max";
    private static final String PLOT_WIDTH = "pp.width";
    private static final String PLOT_HEIGHT = "pp.height";
    private static final String OPTIONS = "pp.options";
    private static final int SAVE_X_VALUES = 1;
    private static final int AUTO_CLOSE = 2;
    private int frameWidth;
    private int frameHeight;
    private int xloc;
    private int yloc;
    private Rectangle frame = null;
    private float[] xValues;
    private float[] yValues;
    private float[] errorBars;
    private int nPoints;
    private double xScale;
    private double yScale;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private Button list;
    private Button save;
    private Button copy;
    private Label coordinates;
    private static String defaultDirectory = null;
    private String xLabel;
    private String yLabel;
    private Font font = new Font("Helvetica", 0, 12);
    private boolean fixedYScale;
    private ImageProcessor ip;
    private static int options;
    public static boolean saveXValues;
    public static boolean autoClose;
    public static int plotWidth;
    public static int plotHeight;
    static /* synthetic */ Class class$ij$gui$PlotWindow;

    public PlotWindow(String string, String string2, String string3, float[] fArray, float[] fArray2) {
        super(NewImage.createByteImage(string, plotWidth + 50 + 20, plotHeight + 20 + 30, 1, 0));
        this.xLabel = string2;
        this.yLabel = string3;
        this.xValues = fArray;
        this.yValues = fArray2;
        double[] dArray = Tools.getMinMax(fArray);
        this.xMin = dArray[0];
        this.xMax = dArray[1];
        dArray = Tools.getMinMax(fArray2);
        this.yMin = dArray[0];
        this.yMax = dArray[1];
        this.fixedYScale = false;
        this.nPoints = fArray.length;
    }

    public PlotWindow(String string, String string2, String string3, double[] dArray, double[] dArray2) {
        this(string, string2, string3, Tools.toFloat(dArray), Tools.toFloat(dArray2));
    }

    public void setLimits(double d, double d2, double d3, double d4) {
        this.xMin = d;
        this.xMax = d2;
        this.yMin = d3;
        this.yMax = d4;
        this.fixedYScale = true;
    }

    public void addPoints(float[] fArray, float[] fArray2, int n) {
        this.setup();
        switch (n) {
            case 0: 
            case 1: {
                int n2 = 0;
                while (n2 < fArray.length) {
                    int n3 = 50 + (int)(((double)fArray[n2] - this.xMin) * this.xScale);
                    int n4 = 20 + this.frameHeight - (int)(((double)fArray2[n2] - this.yMin) * this.yScale);
                    this.drawShape(n, n3, n4, 5);
                    ++n2;
                }
                break;
            }
            case 2: {
                int[] nArray = new int[fArray.length];
                int[] nArray2 = new int[fArray2.length];
                int n5 = 0;
                while (n5 < fArray.length) {
                    nArray[n5] = 50 + (int)(((double)fArray[n5] - this.xMin) * this.xScale);
                    nArray2[n5] = 20 + this.frameHeight - (int)(((double)fArray2[n5] - this.yMin) * this.yScale);
                    ++n5;
                }
                this.drawPolyline(this.ip, nArray, nArray2, fArray.length);
            }
        }
    }

    public void addPoints(double[] dArray, double[] dArray2, int n) {
        this.addPoints(Tools.toFloat(dArray), Tools.toFloat(dArray2), n);
    }

    void drawShape(int n, int n2, int n3, int n4) {
        int n5 = n2 - n4 / 2;
        int n6 = n3 - n4 / 2;
        if (n == 1) {
            this.ip.drawLine(n5, n6, n5 + n4, n6 + n4);
            this.ip.drawLine(n5 + n4, n6, n5, n6 + n4);
        } else {
            this.ip.drawLine(n2 - 1, n3 - 2, n2 + 1, n3 - 2);
            this.ip.drawLine(n2 - 1, n3 + 2, n2 + 1, n3 + 2);
            this.ip.drawLine(n2 + 2, n3 + 1, n2 + 2, n3 - 1);
            this.ip.drawLine(n2 - 2, n3 + 1, n2 - 2, n3 - 1);
        }
    }

    public void addErrorBars(float[] fArray) {
        if (fArray.length != this.nPoints) {
            throw new IllegalArgumentException("errorBars.length != npoints");
        }
        this.errorBars = fArray;
    }

    public void addLabel(double d, double d2, String string) {
        this.setup();
        int n = 50 + (int)(d * (double)this.frameWidth);
        int n2 = 20 + (int)(d2 * (double)this.frameHeight);
        this.ip.drawString(string, n, n2);
    }

    public void setColor(Color color) {
        this.setup();
        this.ip = this.ip.convertToRGB();
        this.ip.setColor(color);
    }

    public void draw() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.list = new Button(" List ");
        this.list.addActionListener(this);
        panel.add(this.list);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        panel.add(this.save);
        this.copy = new Button("Copy...");
        this.copy.addActionListener(this);
        panel.add(this.copy);
        this.coordinates = new Label("                     ");
        this.coordinates.setFont(new Font("Monospaced", 0, 12));
        panel.add(this.coordinates);
        this.add(panel);
        this.drawPlot();
        this.pack();
        if (this.ip instanceof ColorProcessor) {
            this.imp.setProcessor(null, this.ip);
        } else {
            this.imp.updateAndDraw();
        }
    }

    void setup() {
        if (this.ip != null) {
            return;
        }
        this.ip = this.imp.getProcessor();
        this.ip.setColor(Color.black);
        if (Line.getWidth() > 3) {
            this.ip.setLineWidth(1);
        }
        this.ip.setFont(this.font);
        this.ip.setAntialiasedText(true);
        if (this.frameWidth == 0) {
            this.frameWidth = plotWidth;
            this.frameHeight = plotHeight;
        }
        this.frame = new Rectangle(50, 20, this.frameWidth, this.frameHeight);
        this.xScale = this.xMax - this.xMin == 0.0 ? 1.0 : (double)this.frame.width / (this.xMax - this.xMin);
        this.yScale = this.yMax - this.yMin == 0.0 ? 1.0 : (double)this.frame.height / (this.yMax - this.yMin);
    }

    String d2s(double d) {
        if ((double)Math.round(d) == d) {
            return IJ.d2s(d, 0);
        }
        return IJ.d2s(d);
    }

    public void mouseMoved(int n, int n2) {
        if (this.frame == null || this.coordinates == null) {
            return;
        }
        if (this.frame.contains(n, n2)) {
            this.coordinates.setText("X=" + this.d2s((double)(n -= this.frame.x) / this.xScale + this.xMin) + ", Y=" + this.d2s((double)(this.frameHeight - (n2 -= this.frame.y)) / this.yScale + this.yMin));
        } else {
            this.coordinates.setText("");
        }
    }

    void drawPlot() {
        this.setup();
        int[] nArray = new int[this.nPoints];
        int[] nArray2 = new int[this.nPoints];
        int n = 0;
        while (n < this.nPoints) {
            double d = this.yValues[n];
            if (d < this.yMin) {
                d = this.yMin;
            }
            if (d > this.yMax) {
                d = this.yMax;
            }
            nArray[n] = 50 + (int)(((double)this.xValues[n] - this.xMin) * this.xScale);
            nArray2[n] = 20 + this.frame.height - (int)((d - this.yMin) * this.yScale);
            ++n;
        }
        this.drawPolyline(this.ip, nArray, nArray2, this.nPoints);
        if (this.errorBars != null) {
            nArray = new int[2];
            nArray2 = new int[2];
            int n2 = 0;
            while (n2 < this.nPoints) {
                nArray[0] = nArray[1] = 50 + (int)(((double)this.xValues[n2] - this.xMin) * this.xScale);
                nArray2[0] = 20 + this.frame.height - (int)(((double)this.yValues[n2] - this.yMin - (double)this.errorBars[n2]) * this.yScale);
                nArray2[1] = 20 + this.frame.height - (int)(((double)this.yValues[n2] - this.yMin + (double)this.errorBars[n2]) * this.yScale);
                this.drawPolyline(this.ip, nArray, nArray2, 2);
                ++n2;
            }
        }
        if (this.ip instanceof ColorProcessor) {
            this.ip.setColor(Color.black);
        }
        this.ip.drawRect(this.frame.x, this.frame.y, this.frame.width + 1, this.frame.height + 1);
        String string = this.d2s(this.yMax);
        int n3 = this.ip.getStringWidth(string);
        if (n3 + 4 > 50) {
            this.ip.drawString(string, 4, 16);
        } else {
            this.ip.drawString(string, 50 - this.ip.getStringWidth(string) - 4, 30);
        }
        string = this.d2s(this.yMin);
        n3 = this.ip.getStringWidth(string);
        if (n3 + 4 > 50) {
            this.ip.drawString(string, 4, 20 + this.frame.height);
        } else {
            this.ip.drawString(string, 50 - this.ip.getStringWidth(string) - 4, 20 + this.frame.height);
        }
        int n4 = 50;
        int n5 = 20 + this.frame.height + 15;
        this.ip.drawString(this.d2s(this.xMin), n4, n5);
        string = this.d2s(this.xMax);
        this.ip.drawString(string, n4 + this.frame.width - this.ip.getStringWidth(string) + 6, n5);
        this.ip.drawString(this.xLabel, 50 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, n5 + 3);
        this.drawYLabel(this.yLabel, 50, 20, this.frame.height);
    }

    void drawPolyline(ImageProcessor imageProcessor, int[] nArray, int[] nArray2, int n) {
        imageProcessor.moveTo(nArray[0], nArray2[0]);
        int n2 = 0;
        while (n2 < n) {
            imageProcessor.lineTo(nArray[n2], nArray2[n2]);
            ++n2;
        }
    }

    void drawYLabel(String string, int n, int n2, int n3) {
        if (string.equals("")) {
            return;
        }
        FontMetrics fontMetrics = this.ip.getFontMetrics();
        int n4 = fontMetrics.stringWidth(string) + 5;
        int n5 = fontMetrics.getHeight() + 5;
        ImageProcessor imageProcessor = new ByteProcessor(n4, n5);
        ((ImageProcessor)imageProcessor).setColor(Color.white);
        imageProcessor.fill();
        ((ImageProcessor)imageProcessor).setColor(Color.black);
        imageProcessor.setFont(this.font);
        imageProcessor.setAntialiasedText(true);
        int n6 = fontMetrics.getDescent();
        imageProcessor.drawString(string, 0, n5 - n6);
        imageProcessor = imageProcessor.rotateLeft();
        int n7 = n2 + (n3 - this.ip.getStringWidth(string)) / 2;
        if (n7 < n2) {
            n7 = n2;
        }
        int n8 = n - n5 - 2;
        this.ip.insert(imageProcessor, n8, n7);
    }

    void showList() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.errorBars != null) {
            string = saveXValues ? "X\tY\tErrorBar" : "Y\tErrorBar";
            int n = 0;
            while (n < this.nPoints) {
                if (saveXValues) {
                    stringBuffer.append(this.d2s(this.xValues[n]) + "\t" + this.d2s(this.yValues[n]) + "\t" + this.d2s(this.errorBars[n]) + "\n");
                } else {
                    stringBuffer.append(this.d2s(this.yValues[n]) + "\t" + this.d2s(this.errorBars[n]) + "\n");
                }
                ++n;
            }
        } else {
            string = saveXValues ? "X\tY" : "Y";
            int n = 0;
            while (n < this.nPoints) {
                if (saveXValues) {
                    stringBuffer.append(this.d2s(this.xValues[n]) + "\t" + this.d2s(this.yValues[n]) + "\n");
                } else {
                    stringBuffer.append(this.d2s(this.yValues[n]) + "\n");
                }
                ++n;
            }
        }
        TextWindow textWindow = new TextWindow("Plot Values", string, stringBuffer.toString(), 200, 400);
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void saveAsText() {
        String string;
        FileDialog fileDialog = new FileDialog((Frame)this, "Save as Text...", 1);
        if (defaultDirectory != null) {
            fileDialog.setDirectory(defaultDirectory);
        }
        fileDialog.show();
        String string2 = fileDialog.getFile();
        defaultDirectory = string = fileDialog.getDirectory();
        fileDialog.dispose();
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string + string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            printWriter = new PrintWriter(bufferedOutputStream);
        }
        catch (IOException iOException) {
            IJ.error("" + iOException);
            return;
        }
        IJ.wait(250);
        IJ.showStatus("Saving plot values...");
        int n = 0;
        while (n < this.nPoints) {
            if (saveXValues) {
                printWriter.println(this.d2s(this.xValues[n]) + "\t" + this.d2s(this.yValues[n]));
            } else {
                printWriter.println(this.d2s(this.yValues[n]));
            }
            ++n;
        }
        printWriter.close();
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            clipboard = null;
        }
        if (clipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying plot values...");
        CharArrayWriter charArrayWriter = new CharArrayWriter(this.nPoints * 4);
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        int n = 0;
        while (n < this.nPoints) {
            if (saveXValues) {
                printWriter.print(this.d2s(this.xValues[n]) + "\t" + this.d2s(this.yValues[n]) + "\n");
            } else {
                printWriter.print(this.d2s(this.yValues[n]) + "\n");
            }
            ++n;
        }
        String string = charArrayWriter.toString();
        printWriter.close();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
        IJ.showStatus(string.length() + " characters copied to Clipboard");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.list) {
            this.showList();
        } else if (object == this.save) {
            this.saveAsText();
        } else {
            this.copyToClipboard();
        }
    }

    public static void savePreferences(Properties properties) {
        double d = ProfilePlot.getFixedMin();
        double d2 = ProfilePlot.getFixedMax();
        if ((d != 0.0 || d2 != 0.0) && d < d2) {
            ((Hashtable)properties).put(MIN, Double.toString(d));
            ((Hashtable)properties).put(MAX, Double.toString(d2));
        }
        if (plotWidth != 450 || plotHeight != 200) {
            ((Hashtable)properties).put(PLOT_WIDTH, Integer.toString(plotWidth));
            ((Hashtable)properties).put(PLOT_HEIGHT, Integer.toString(plotHeight));
        }
        int n = 0;
        if (saveXValues) {
            n |= 1;
        }
        if (autoClose) {
            n |= 2;
        }
        ((Hashtable)properties).put(OPTIONS, Integer.toString(n));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        plotWidth = 450;
        plotHeight = 200;
        IJ.register(class$ij$gui$PlotWindow == null ? (class$ij$gui$PlotWindow = PlotWindow.class$("ij.gui.PlotWindow")) : class$ij$gui$PlotWindow);
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
        plotWidth = Prefs.getInt(PLOT_WIDTH, 450);
        plotHeight = Prefs.getInt(PLOT_HEIGHT, 200);
    }
}

