/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.Symbol;
import ij.macro.Variable;

public class Program
implements MacroConstants {
    static final int STACK_SIZE = 1000;
    private int maxSymbols = 1000;
    private int maxProgramSize = 5000;
    private int pc = -1;
    Variable[] stack;
    int topOfStack = -1;
    int topOfGlobals = -1;
    int startOfLocals = 0;
    int stLoc = -1;
    int symTabLoc;
    Symbol[] table = new Symbol[this.maxSymbols];
    int[] code = new int[this.maxProgramSize];

    public Program() {
        this.addKeywords();
        this.addFunctions();
        this.addNumericFunctions();
        this.addStringFunctions();
    }

    public int[] getCode() {
        return this.code;
    }

    public Symbol[] getSymbolTable() {
        return this.table;
    }

    void addKeywords() {
        int n = 0;
        while (n < MacroConstants.keywords.length) {
            this.table[++this.stLoc] = new Symbol(MacroConstants.keywordIDs[n], MacroConstants.keywords[n]);
            ++n;
        }
    }

    void addFunctions() {
        int n = 0;
        while (n < MacroConstants.functions.length) {
            this.table[++this.stLoc] = new Symbol(MacroConstants.functionIDs[n], MacroConstants.functions[n]);
            ++n;
        }
    }

    void addNumericFunctions() {
        int n = 0;
        while (n < MacroConstants.numericFunctions.length) {
            this.table[++this.stLoc] = new Symbol(MacroConstants.numericFunctionIDs[n], MacroConstants.numericFunctions[n]);
            ++n;
        }
    }

    void addStringFunctions() {
        int n = 0;
        while (n < MacroConstants.stringFunctions.length) {
            this.table[++this.stLoc] = new Symbol(MacroConstants.stringFunctionIDs[n], MacroConstants.stringFunctions[n]);
            ++n;
        }
    }

    void addSymbol(Symbol symbol) {
        if (this.stLoc < this.maxSymbols - 1) {
            ++this.stLoc;
        }
        this.table[this.stLoc] = symbol;
    }

    void addToken(int n) {
        if (this.pc < this.maxProgramSize - 1) {
            ++this.pc;
        }
        this.code[this.pc] = n;
    }

    Symbol lookupWord(String string) {
        Symbol symbol = null;
        int n = 0;
        while (n < this.maxSymbols) {
            symbol = this.table[n];
            if (symbol == null) break;
            String string2 = symbol.str;
            if (string2 != null && string.equals(string2)) {
                this.symTabLoc = n;
                break;
            }
            ++n;
        }
        return symbol;
    }

    final Variable lookupVariable(int n) {
        Variable variable = null;
        int n2 = this.topOfStack;
        while (n2 >= this.startOfLocals) {
            if (this.stack[n2].symTabIndex == n) {
                variable = this.stack[n2];
                break;
            }
            --n2;
        }
        if (variable == null) {
            int n3 = this.topOfGlobals;
            while (n3 >= 0) {
                if (this.stack[n3].symTabIndex == n) {
                    variable = this.stack[n3];
                    break;
                }
                --n3;
            }
        }
        return variable;
    }

    Variable push(int n, double d, String string, Interpreter interpreter) {
        Variable variable = new Variable(n, d, string);
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        if (this.topOfStack >= 998) {
            interpreter.error("Stack overflow");
        } else {
            ++this.topOfStack;
        }
        this.stack[this.topOfStack] = variable;
        return variable;
    }

    void trimStack(int n, int n2) {
        int n3 = n + 1;
        while (n3 <= this.topOfStack) {
            this.stack[n3] = null;
            ++n3;
        }
        this.topOfStack = n;
        this.startOfLocals = n2;
    }

    public void dumpSymbolTable() {
        IJ.log("");
        IJ.log("Symbol Table");
        int n = 0;
        while (n <= this.maxSymbols) {
            Symbol symbol = this.table[n];
            if (symbol == null) break;
            IJ.log(n + " " + symbol);
            ++n;
        }
    }

    public void dumpProgram() {
        IJ.log("");
        IJ.log("Tokenized Program");
        int n = 0;
        while (n <= this.pc) {
            IJ.log(n + "\t" + (this.code[n] & 0xFFFF) + "  " + this.decodeToken(this.code[n]));
            ++n;
        }
    }

    public String decodeToken(int n) {
        return this.decodeToken(n & 0xFFFF, n >> 16);
    }

    String decodeToken(int n, int n2) {
        String string;
        block0 : switch (n) {
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                string = this.table[n2].str;
                break;
            }
            case 133: {
                string = "\"" + this.table[n2].str + "\"";
                break;
            }
            case 130: {
                double d = this.table[n2].value;
                if ((double)((int)d) == d) {
                    string = IJ.d2s(d, 0);
                    break;
                }
                string = "" + d;
                break;
            }
            case 132: {
                string = "EOL";
                break;
            }
            case 128: {
                string = "EOF";
                break;
            }
            default: {
                if (n < 32) {
                    switch (n) {
                        case 1: {
                            string = "++";
                            break block0;
                        }
                        case 2: {
                            string = "--";
                            break block0;
                        }
                        case 3: {
                            string = "==";
                            break block0;
                        }
                        case 4: {
                            string = "!=";
                            break block0;
                        }
                        case 5: {
                            string = ">";
                            break block0;
                        }
                        case 6: {
                            string = ">=";
                            break block0;
                        }
                        case 7: {
                            string = "<";
                            break block0;
                        }
                        case 8: {
                            string = "<=";
                            break block0;
                        }
                    }
                    string = "";
                    break;
                }
                if (n >= 200) {
                    string = this.table[n2].str;
                    break;
                }
                char[] cArray = new char[]{(char)n};
                string = new String(cArray);
            }
        }
        return string;
    }
}

