/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;

public class Animator
implements PlugIn {
    private static double animationSpeed = Prefs.getDouble("fps", 7.0);
    private static boolean oscillate;
    private ImagePlus imp;
    private StackWindow swin;
    private int slice;
    private int nSlices;
    static /* synthetic */ Class class$ij$plugin$Animator;

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.nSlices = this.imp.getStackSize();
        if (this.nSlices < 2) {
            IJ.error("Stack required.");
            return;
        }
        ImageWindow imageWindow = this.imp.getWindow();
        if (!(imageWindow instanceof StackWindow)) {
            return;
        }
        this.swin = (StackWindow)imageWindow;
        ImageStack imageStack = this.imp.getStack();
        this.slice = this.imp.getCurrentSlice();
        IJ.register(class$ij$plugin$Animator == null ? (class$ij$plugin$Animator = Animator.class$("ij.plugin.Animator")) : class$ij$plugin$Animator);
        if (string.equals("options")) {
            this.doOptions();
            return;
        }
        if (string.equals("start")) {
            this.startAnimation();
            return;
        }
        if (this.swin.running) {
            this.stopAnimation();
        }
        if (string.equals("stop")) {
            return;
        }
        if (string.equals("next")) {
            this.nextSlice();
            return;
        }
        if (string.equals("previous")) {
            this.previousSlice();
            return;
        }
        if (string.equals("set")) {
            this.setSlice();
            return;
        }
    }

    void stopAnimation() {
        this.swin.running = false;
        IJ.wait(500 + (int)(1000.0 / animationSpeed));
        this.imp.unlock();
    }

    void startAnimation() {
        if (this.swin.running) {
            this.stopAnimation();
            return;
        }
        this.imp.unlock();
        this.swin.running = true;
        long l = System.currentTimeMillis();
        Thread.currentThread().setPriority(1);
        int n = 1;
        Calibration calibration = this.imp.getCalibration();
        if (calibration.frameInterval != 0.0) {
            animationSpeed = 1.0 / calibration.frameInterval;
        }
        while (this.swin.running) {
            long l2 = System.currentTimeMillis();
            if (l2 < l) {
                IJ.wait((int)(l - l2));
            } else {
                Thread.yield();
            }
            l += (long)(1000.0 / animationSpeed);
            this.slice += n;
            if (this.slice < 1) {
                this.slice = 2;
                n = 1;
            }
            if (this.slice > this.nSlices) {
                if (oscillate) {
                    this.slice = this.nSlices - 1;
                    n = -1;
                } else {
                    this.slice = 1;
                    n = 1;
                }
            }
            this.swin.showSlice(this.slice);
        }
    }

    void doOptions() {
        boolean bl = !this.swin.running;
        boolean bl2 = oscillate;
        Calibration calibration = this.imp.getCalibration();
        if (calibration.frameInterval != 0.0) {
            animationSpeed = 1.0 / calibration.frameInterval;
        }
        GenericDialog genericDialog = new GenericDialog("Animation Options");
        genericDialog.addNumericField("Speed (1-100 fps):", animationSpeed, 0);
        genericDialog.addCheckbox("Loop Back and Forth", oscillate);
        genericDialog.addCheckbox("Start Animation", bl);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        double d = genericDialog.getNextNumber();
        oscillate = genericDialog.getNextBoolean();
        bl = genericDialog.getNextBoolean();
        if (d > 100.0) {
            d = 100.0;
        }
        if (d < 1.0) {
            d = 1.0;
        }
        if ((animationSpeed = d) != 0.0) {
            calibration.frameInterval = 1.0 / animationSpeed;
        }
        if (bl && !this.swin.running) {
            this.startAnimation();
        }
    }

    void nextSlice() {
        if (!this.imp.lock()) {
            return;
        }
        this.slice = IJ.altKeyDown() ? (this.slice += 10) : ++this.slice;
        if (this.slice > this.nSlices) {
            this.slice = this.nSlices;
        }
        this.swin.showSlice(this.slice);
        this.imp.updateStatusbarValue();
        this.imp.unlock();
    }

    void previousSlice() {
        if (!this.imp.lock()) {
            return;
        }
        this.slice = IJ.altKeyDown() ? (this.slice -= 10) : --this.slice;
        if (this.slice < 1) {
            this.slice = 1;
        }
        this.swin.showSlice(this.slice);
        this.imp.updateStatusbarValue();
        this.imp.unlock();
    }

    void setSlice() {
        GenericDialog genericDialog = new GenericDialog("Set Slice");
        genericDialog.addNumericField("Slice Number (1-" + this.nSlices + "):", this.slice, 0);
        genericDialog.showDialog();
        if (!genericDialog.wasCanceled()) {
            this.imp.setSlice((int)genericDialog.getNextNumber());
        }
    }

    public static double getFrameRate() {
        return animationSpeed;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

