/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Color;

public class MontageMaker
implements PlugIn {
    private static int columns;
    private static int rows;
    private static int first;
    private static int last;
    private static int inc;
    private static double scale;
    private static boolean label;
    private static boolean borders;
    private static int saveID;
    static /* synthetic */ Class class$ij$plugin$MontageMaker;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus.getStackSize() == 1) {
            IJ.error("Stack required");
            return;
        }
        this.makeMontage(imagePlus);
        saveID = imagePlus.getID();
        IJ.register(class$ij$plugin$MontageMaker == null ? (class$ij$plugin$MontageMaker = MontageMaker.class$("ij.plugin.MontageMaker")) : class$ij$plugin$MontageMaker);
    }

    public void makeMontage(ImagePlus imagePlus) {
        int n = imagePlus.getStackSize();
        if (columns == 0 || imagePlus.getID() != saveID) {
            rows = columns = (int)Math.sqrt(n);
            int n2 = n - columns * rows;
            if (n2 > 0) {
                columns += (int)Math.ceil((double)n2 / (double)rows);
            }
            scale = 1.0;
            if (imagePlus.getWidth() * columns > 800) {
                scale = 0.5;
            }
            if (imagePlus.getWidth() * columns > 1600) {
                scale = 0.25;
            }
            inc = 1;
            first = 1;
            last = n;
        }
        GenericDialog genericDialog = new GenericDialog("Make Montage", IJ.getInstance());
        genericDialog.addNumericField("Columns:", columns, 0);
        genericDialog.addNumericField("Rows:", rows, 0);
        genericDialog.addNumericField("Scale Factor:", scale, 2);
        genericDialog.addNumericField("First Slice:", first, 0);
        genericDialog.addNumericField("Last Slice:", last, 0);
        genericDialog.addNumericField("Increment:", inc, 0);
        genericDialog.addCheckbox("Label Slices", label);
        genericDialog.addCheckbox("Borders", borders);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        columns = (int)genericDialog.getNextNumber();
        rows = (int)genericDialog.getNextNumber();
        scale = genericDialog.getNextNumber();
        first = (int)genericDialog.getNextNumber();
        last = (int)genericDialog.getNextNumber();
        inc = (int)genericDialog.getNextNumber();
        if (first < 1) {
            first = 1;
        }
        if (last > n) {
            last = n;
        }
        if (inc < 1) {
            inc = 1;
        }
        if (genericDialog.invalidNumber()) {
            IJ.error("Invalid number");
            return;
        }
        label = genericDialog.getNextBoolean();
        borders = genericDialog.getNextBoolean();
        this.makeMontage(imagePlus, columns, rows, scale, first, last, inc, label, borders);
    }

    public void makeMontage(ImagePlus imagePlus, int n, int n2, double d, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int n6;
        Object object;
        boolean bl3;
        int n7 = imagePlus.getWidth();
        int n8 = imagePlus.getHeight();
        int n9 = imagePlus.getStackSize();
        int n10 = (int)((double)n7 * d);
        int n11 = (int)((double)n8 * d);
        int n12 = n10 * n;
        int n13 = n11 * n2;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n12, n13);
        ImageStatistics imageStatistics = imagePlus.getStatistics();
        boolean bl4 = bl3 = imageStatistics.mode < 200;
        if (imagePlus.isInvertedLut()) {
            boolean bl5 = bl3 = !bl3;
        }
        if (imageProcessor instanceof ShortProcessor || imageProcessor instanceof FloatProcessor) {
            bl3 = true;
        }
        if (bl3) {
            object = imagePlus.getCalibration().getCTable();
            int n14 = n6 = object != null && object[0] == -32768.0f ? 1 : 0;
            if (n6 != 0) {
                imageProcessor2.setValue(32768.0);
            } else {
                imageProcessor2.setColor(Color.black);
            }
            imageProcessor2.fill();
            imageProcessor2.setColor(Color.white);
        } else {
            imageProcessor2.setColor(Color.white);
            imageProcessor2.fill();
            imageProcessor2.setColor(Color.black);
        }
        object = imagePlus.getStack();
        n6 = 0;
        int n15 = 0;
        int n16 = n3;
        while (n16 <= n4) {
            ImageProcessor imageProcessor3 = object.getProcessor(n16);
            if (d != 1.0) {
                imageProcessor3 = imageProcessor3.resize(n10, n11);
            }
            imageProcessor2.insert(imageProcessor3, n6, n15);
            if (bl2) {
                this.drawBorder(imageProcessor2, n6, n15, n10, n11);
            }
            if (bl) {
                this.drawLabel(imageProcessor2, n16, n6, n15, n10, n11);
            }
            if ((n6 += n10) >= n12) {
                n6 = 0;
                if ((n15 += n11) >= n13) break;
            }
            IJ.showProgress((double)(n16 - n3) / (double)(n4 - n3));
            n16 += n5;
        }
        if (bl2) {
            this.drawBorder(imageProcessor2, 0, 0, n12 - 1, n13 - 1);
        }
        IJ.showProgress(1.0);
        ImagePlus imagePlus2 = new ImagePlus("Montage", imageProcessor2);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        Calibration calibration = imagePlus2.getCalibration();
        if (calibration.scaled()) {
            calibration.pixelWidth /= d;
            calibration.pixelHeight /= d;
        }
        imagePlus2.show();
    }

    void drawBorder(ImageProcessor imageProcessor, int n, int n2, int n3, int n4) {
        imageProcessor.moveTo(n, n2);
        imageProcessor.lineTo(n + n3, n2);
        imageProcessor.lineTo(n + n3, n2 + n4);
        imageProcessor.lineTo(n, n2 + n4);
        imageProcessor.lineTo(n, n2);
    }

    void drawLabel(ImageProcessor imageProcessor, int n, int n2, int n3, int n4, int n5) {
        String string = "" + n;
        int n6 = imageProcessor.getStringWidth(string);
        imageProcessor.moveTo(n2 += n4 / 2 - n6 / 2, n3 += n5);
        imageProcessor.drawString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        label = false;
        borders = false;
    }
}

