/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.io.SaveDialog;
import ij.plugin.Animator;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class AVIWriter
implements PlugInFilter {
    private ImagePlus imp;
    private RandomAccessFile raFile;
    private int bytesPerPixel;
    private File file;
    private int bufferFactor;
    private int xDim;
    private int yDim;
    private int zDim;
    private int tDim;
    private int[] lutBufferRemapped = null;
    private int microSecPerFrame;
    private int xPad;
    private byte[] bufferWrite;
    private int bufferSize;
    private int indexA;
    private int indexB;
    private float opacityPrime;
    private int bufferAdr;
    private byte[] lutWrite = null;
    private int[] dcLength = null;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        try {
            this.writeImage(this.imp);
            IJ.showStatus("");
        }
        catch (IOException iOException) {
            IJ.showMessage("AVI Writer", "An error occured writing the file.\n \n" + iOException);
        }
        IJ.showStatus("");
    }

    public void writeImage(ImagePlus imagePlus) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        float f = 0.0f;
        float f2 = 0.0f;
        long l = 0L;
        long l2 = 0L;
        this.bytesPerPixel = imagePlus.getType() == 4 ? 3 : 1;
        this.lutBufferRemapped = new int[1];
        SaveDialog saveDialog = new SaveDialog("Save as AVI...", imagePlus.getTitle(), ".avi");
        String string = saveDialog.getFileName();
        if (string == null) {
            return;
        }
        String string2 = saveDialog.getDirectory();
        this.file = new File(string2 + string);
        this.raFile = new RandomAccessFile(this.file, "rw");
        imagePlus.startTiming();
        this.writeString("RIFF");
        long l3 = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeString("AVI ");
        this.writeString("LIST");
        long l4 = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeString("hdrl");
        this.writeString("avih");
        this.writeInt(56);
        this.microSecPerFrame = (int)(1.0 / Animator.getFrameRate() * 1000000.0);
        this.writeInt(this.microSecPerFrame);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(16);
        this.tDim = 1;
        this.zDim = imagePlus.getStackSize();
        this.yDim = imagePlus.getHeight();
        this.xDim = imagePlus.getWidth();
        this.xPad = 0;
        int n = this.xDim % 4;
        if (n != 0) {
            this.xPad = 4 - n;
            this.xDim += this.xPad;
        }
        this.writeInt(this.zDim * this.tDim);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt(0);
        this.writeInt(this.xDim - this.xPad);
        this.writeInt(this.yDim);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeString("LIST");
        long l5 = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeString("strl");
        this.writeString("strh");
        this.writeInt(56);
        this.writeString("vids");
        this.writeString("DIB ");
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt((int)Animator.getFrameRate());
        this.writeInt(0);
        this.writeInt(this.tDim * this.zDim);
        this.writeInt(0);
        this.writeInt(-1);
        this.writeInt(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeString("strf");
        long l6 = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeInt(40);
        this.writeInt(this.xDim);
        this.writeInt(this.yDim);
        this.writeShort(1);
        int n2 = this.bytesPerPixel == 3 ? 24 : 8;
        this.writeShort((short)n2);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        if (n2 == 8) {
            this.writeInt(256);
        } else {
            this.writeInt(0);
        }
        this.writeInt(0);
        if (this.bytesPerPixel == 1) {
            this.createLUT();
            this.raFile.write(this.lutWrite);
        }
        long l7 = this.raFile.getFilePointer();
        this.raFile.seek(l6);
        this.writeInt((int)(l7 - (l6 + 4L)));
        this.raFile.seek(l7);
        this.writeString("strn");
        this.writeInt(16);
        this.writeString("FileAVI write  ");
        this.raFile.write(0);
        long l8 = this.raFile.getFilePointer();
        this.raFile.seek(l4);
        this.writeInt((int)(l8 - (l4 + 4L)));
        this.raFile.seek(l5);
        this.writeInt((int)(l8 - (l5 + 4L)));
        this.raFile.seek(l8);
        this.writeString("JUNK");
        int n3 = (int)(4084L - (l8 + 8L));
        this.writeInt(n3);
        int n4 = 0;
        while (n4 < n3 / 2) {
            this.writeShort(0);
            ++n4;
        }
        this.writeString("LIST");
        long l9 = this.raFile.getFilePointer();
        this.writeInt(0);
        long l10 = this.raFile.getFilePointer();
        this.writeString("movi");
        long[] lArray = new long[this.tDim * this.zDim];
        long[] lArray2 = new long[this.tDim * this.zDim];
        this.dcLength = new int[this.tDim * this.zDim];
        byte[] byArray = new byte[]{48, 48, 100, 98};
        this.bufferWrite = new byte[this.bytesPerPixel * this.xDim * this.yDim];
        int n5 = 0;
        while (n5 < this.zDim) {
            IJ.showProgress((double)n5 / (double)this.zDim);
            this.raFile.write(byArray);
            lArray[n5] = this.raFile.getFilePointer();
            this.writeInt(this.bytesPerPixel * this.xDim * this.yDim);
            if (this.bytesPerPixel == 1) {
                this.writeByteFrame(n5 + 1);
            } else {
                this.writeRGBFrame(n5 + 1);
            }
            ++n5;
        }
        long l11 = this.raFile.getFilePointer();
        this.raFile.seek(l9);
        this.writeInt((int)(l11 - (l9 + 4L)));
        this.raFile.seek(l11);
        this.writeString("idx1");
        long l12 = this.raFile.getFilePointer();
        this.writeInt(0);
        n5 = 0;
        while (n5 < this.zDim) {
            this.raFile.write(byArray);
            if (n5 == 0) {
                this.writeInt(16);
            } else {
                this.writeInt(0);
            }
            this.writeInt((int)(lArray[n5] - 4L - l10));
            this.writeInt(this.bytesPerPixel * this.xDim * this.yDim);
            ++n5;
        }
        long l13 = this.raFile.getFilePointer();
        this.raFile.seek(l3);
        this.writeInt((int)(l13 - (l3 + 4L)));
        this.raFile.seek(l12);
        this.writeInt((int)(l13 - (l12 + 4L)));
        this.raFile.close();
        IJ.showProgress(1.0);
    }

    public void writeByteFrame(int n) throws IOException {
        ImageProcessor imageProcessor = this.imp.getStack().getProcessor(n);
        imageProcessor = imageProcessor.convertToByte(true);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n2 = this.imp.getWidth();
        int n3 = this.imp.getHeight();
        int n4 = 0;
        int n5 = n3 - 1;
        while (n5 >= 0) {
            int n6 = n5 * n2;
            int n7 = 0;
            while (n7 < n2) {
                this.bufferWrite[n4++] = byArray[n6++];
                ++n7;
            }
            int n8 = 0;
            while (n8 < this.xPad) {
                this.bufferWrite[n4++] = 0;
                ++n8;
            }
            --n5;
        }
        this.raFile.write(this.bufferWrite);
    }

    public void writeRGBFrame(int n) throws IOException {
        ImageProcessor imageProcessor = this.imp.getStack().getProcessor(n);
        imageProcessor = imageProcessor.convertToRGB();
        int[] nArray = (int[])imageProcessor.getPixels();
        int n2 = this.imp.getWidth();
        int n3 = this.imp.getHeight();
        int n4 = 0;
        int n5 = n3 - 1;
        while (n5 >= 0) {
            int n6 = n5 * n2;
            int n7 = 0;
            while (n7 < n2) {
                int n8 = nArray[n6++];
                this.bufferWrite[n4++] = (byte)(n8 & 0xFF);
                this.bufferWrite[n4++] = (byte)((n8 & 0xFF00) >> 8);
                this.bufferWrite[n4++] = (byte)((n8 & 0xFF0000) >> 16);
                ++n7;
            }
            int n9 = 0;
            while (n9 < this.xPad) {
                this.bufferWrite[n4++] = 0;
                this.bufferWrite[n4++] = 0;
                this.bufferWrite[n4++] = 0;
                ++n9;
            }
            --n5;
        }
        this.raFile.write(this.bufferWrite);
    }

    public void createLUT() {
        LookUpTable lookUpTable = this.imp.createLut();
        IndexColorModel indexColorModel = (IndexColorModel)lookUpTable.getColorModel();
        int n = indexColorModel.getMapSize();
        this.lutWrite = new byte[1024];
        int n2 = 0;
        while (n2 < 256) {
            if (n2 < n) {
                this.lutWrite[4 * n2] = (byte)indexColorModel.getBlue(n2);
                this.lutWrite[4 * n2 + 1] = (byte)indexColorModel.getGreen(n2);
                this.lutWrite[4 * n2 + 2] = (byte)indexColorModel.getRed(n2);
                this.lutWrite[4 * n2 + 3] = 0;
            }
            ++n2;
        }
    }

    final void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF8");
        this.raFile.write(byArray);
    }

    final void writeInt(int n) throws IOException {
        this.raFile.write(n & 0xFF);
        this.raFile.write(n >>> 8 & 0xFF);
        this.raFile.write(n >>> 16 & 0xFF);
        this.raFile.write(n >>> 24 & 0xFF);
    }

    final void writeShort(int n) throws IOException {
        this.raFile.write(n & 0xFF);
        this.raFile.write(n >>> 8 & 0xFF);
    }
}

