/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.measure.Calibration;
import ij.plugin.RGBStackMerge;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.RGBStackSplitter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;

public class Projector
implements PlugInFilter {
    static final int xAxis = 0;
    static final int yAxis = 1;
    static final int zAxis = 2;
    static final int nearestPoint = 0;
    static final int brightestPoint = 1;
    static final int meanValue = 2;
    static final int BIGPOWEROF2 = 8192;
    String[] axisList = new String[]{"X-Axis", "Y-Axis", "Z-Axis"};
    String[] methodList = new String[]{"Nearest Point", "Brightest Point", "Mean Value"};
    private static int axisOfRotation = 0;
    private static int projectionMethod = 0;
    private double sliceInterval = 1.0;
    private static int initAngle = 0;
    private static int totalAngle = 360;
    private static int angleInc = 10;
    private static int opacity = 0;
    private static int depthCueSurf = 0;
    private static int depthCueInt = 50;
    private static boolean interpolate;
    private static boolean debugMode;
    private int transparencyLower = 1;
    private int transparencyUpper = 255;
    ImagePlus imp;
    ImageStack stack;
    ImageStack stack2;
    int width;
    int height;
    int imageWidth;
    int left;
    int right;
    int top;
    int bottom;
    byte[] projArray;
    byte[] opaArray;
    byte[] brightCueArray;
    short[] zBuffer;
    short[] cueZBuffer;
    short[] countBuffer;
    int[] sumBuffer;
    boolean isRGB;
    String label = "";
    static /* synthetic */ Class class$ij$plugin$filter$Projector;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        IJ.register(class$ij$plugin$filter$Projector == null ? (class$ij$plugin$filter$Projector = Projector.class$("ij.plugin.filter.Projector")) : class$ij$plugin$filter$Projector);
        return 2193;
    }

    public void run(ImageProcessor imageProcessor) {
        if (imageProcessor.isInvertedLut() && !IJ.showMessageWithCancel("3D Project", "Stacks with inverter LUTs may not project correctly.\nTo create a standard LUT, invert the stack (Edit/Invert)\nand invert the LUT (Image/Lookup Tables/Invert LUT).")) {
            return;
        }
        if (!this.showDialog()) {
            return;
        }
        this.imp.startTiming();
        boolean bl = this.isRGB = this.imp.getType() == 4;
        if (interpolate && this.sliceInterval != 1.0) {
            this.imp = this.zScale(this.imp);
            this.sliceInterval = 1.0;
        }
        if (this.isRGB) {
            this.doRGBProjections(this.imp);
        } else {
            this.doProjections(this.imp);
        }
    }

    public boolean showDialog() {
        ImageProcessor imageProcessor = this.imp.getProcessor();
        double d = imageProcessor.getMinThreshold();
        if (d != -808080.0) {
            this.transparencyLower = (int)d;
            this.transparencyUpper = (int)imageProcessor.getMaxThreshold();
        }
        Calibration calibration = this.imp.getCalibration();
        GenericDialog genericDialog = new GenericDialog("3D Projection");
        genericDialog.addChoice("Projection Method:", this.methodList, this.methodList[projectionMethod]);
        genericDialog.addChoice("Axis of Rotation:", this.axisList, this.axisList[axisOfRotation]);
        genericDialog.addNumericField("Slice Spacing (" + calibration.getUnits() + "):", calibration.pixelDepth, 1);
        genericDialog.addNumericField("Initial Angle (0-359 degrees):", initAngle, 0);
        genericDialog.addNumericField("Total Rotation (0-359 degrees):", totalAngle, 0);
        genericDialog.addNumericField("Rotation Angle Increment:", angleInc, 0);
        genericDialog.addNumericField("Lower Transparency Bound:", this.transparencyLower, 0);
        genericDialog.addNumericField("Upper Transparency Bound:", this.transparencyUpper, 0);
        genericDialog.addNumericField("Opacity (0-100%):", opacity, 0);
        genericDialog.addNumericField("Surface Depth-Cueing (0-100%):", 100 - depthCueSurf, 0);
        genericDialog.addNumericField("Interior Depth-Cueing (0-100%):", 100 - depthCueInt, 0);
        genericDialog.addCheckbox("Interpolate When Slice Spacing > 1.0", interpolate);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        projectionMethod = genericDialog.getNextChoiceIndex();
        axisOfRotation = genericDialog.getNextChoiceIndex();
        calibration.pixelDepth = genericDialog.getNextNumber();
        if (calibration.pixelWidth == 0.0) {
            calibration.pixelWidth = 1.0;
        }
        this.sliceInterval = calibration.pixelDepth / calibration.pixelWidth;
        initAngle = (int)genericDialog.getNextNumber();
        totalAngle = (int)genericDialog.getNextNumber();
        angleInc = (int)genericDialog.getNextNumber();
        this.transparencyLower = (int)genericDialog.getNextNumber();
        this.transparencyUpper = (int)genericDialog.getNextNumber();
        opacity = (int)genericDialog.getNextNumber();
        depthCueSurf = 100 - (int)genericDialog.getNextNumber();
        depthCueInt = 100 - (int)genericDialog.getNextNumber();
        interpolate = genericDialog.getNextBoolean();
        return true;
    }

    public void doRGBProjections(ImagePlus imagePlus) {
        RGBStackSplitter rGBStackSplitter = new RGBStackSplitter();
        rGBStackSplitter.split(imagePlus.getStack(), true);
        ImagePlus imagePlus2 = new ImagePlus("Red", rGBStackSplitter.red);
        ImagePlus imagePlus3 = new ImagePlus("Green", rGBStackSplitter.green);
        ImagePlus imagePlus4 = new ImagePlus("Blue", rGBStackSplitter.blue);
        Calibration calibration = imagePlus.getCalibration();
        imagePlus2.setCalibration(calibration);
        imagePlus3.setCalibration(calibration);
        imagePlus4.setCalibration(calibration);
        this.label = "Red: ";
        imagePlus2 = this.doProjections(imagePlus2);
        if (imagePlus2 == null) {
            return;
        }
        imagePlus2.hide();
        this.label = "Green: ";
        imagePlus3 = this.doProjections(imagePlus3);
        if (imagePlus3 == null) {
            return;
        }
        imagePlus3.hide();
        this.label = "Blue: ";
        imagePlus4 = this.doProjections(imagePlus4);
        if (imagePlus4 == null) {
            return;
        }
        imagePlus4.hide();
        int n = imagePlus2.getWidth();
        int n2 = imagePlus2.getHeight();
        int n3 = imagePlus2.getStackSize();
        RGBStackMerge rGBStackMerge = new RGBStackMerge();
        ImageStack imageStack = rGBStackMerge.mergeStacks(n, n2, n3, imagePlus2.getStack(), imagePlus3.getStack(), imagePlus4.getStack(), true);
        new ImagePlus("Projection of  " + imagePlus.getShortTitle(), imageStack).show();
    }

    /*
     * Unable to fully structure code
     */
    public ImagePlus doProjections(ImagePlus var1_1) {
        block48: {
            block49: {
                block50: {
                    var22_2 = true;
                    this.stack = var1_1.getStack();
                    if (Projector.angleInc == 0 && Projector.totalAngle != 0) {
                        Projector.angleInc = 5;
                    }
                    var21_3 = 0;
                    var20_4 = 0;
                    if (Projector.angleInc != 0) ** GOTO lbl12
                    var20_4 = 1;
                    break block50;
lbl-1000:
                    // 1 sources

                    {
                        ++var20_4;
                        var21_3 += Projector.angleInc;
lbl12:
                        // 2 sources

                        ** while (var21_3 <= Projector.totalAngle)
                    }
                }
                if (var21_3 > 360) {
                    --var20_4;
                }
                if (var20_4 <= 0) {
                    var20_4 = 1;
                }
                var23_5 = var1_1.getProcessor();
                var24_6 = var23_5.getRoi();
                this.left = var24_6.x;
                this.top = var24_6.y;
                this.right = var24_6.x + var24_6.width;
                this.bottom = var24_6.y + var24_6.height;
                var2_7 = var1_1.getStackSize();
                this.imageWidth = var1_1.getWidth();
                this.width = this.right - this.left;
                this.height = this.bottom - this.top;
                var5_8 = (this.left + this.right) / 2;
                var6_9 = (this.top + this.bottom) / 2;
                var7_10 = (int)((double)var2_7 * this.sliceInterval / 2.0 + 0.5);
                var3_11 = 0;
                var4_12 = 0;
                if (var22_2 && Projector.axisOfRotation != 2) {
                    switch (Projector.axisOfRotation) {
                        case 0: {
                            var4_12 = (int)(Math.sqrt((double)var2_7 * this.sliceInterval * (double)var2_7 * this.sliceInterval + (double)(this.height * this.height)) + 0.5);
                            var3_11 = this.width;
                            break;
                        }
                        case 1: {
                            var3_11 = (int)(Math.sqrt((double)var2_7 * this.sliceInterval * (double)var2_7 * this.sliceInterval + (double)(this.width * this.width)) + 0.5);
                            var4_12 = this.height;
                        }
                    }
                } else {
                    var3_11 = (int)(Math.sqrt((double)var2_7 * this.sliceInterval * (double)var2_7 * this.sliceInterval + (double)(this.width * this.width)) + 0.5);
                    var4_12 = (int)(Math.sqrt((double)var2_7 * this.sliceInterval * (double)var2_7 * this.sliceInterval + (double)(this.height * this.height)) + 0.5);
                }
                if (var3_11 % 1 == 1) {
                    ++var3_11;
                }
                var25_13 = var3_11 * var4_12;
                try {
                    this.allocateArrays(var20_4, var3_11, var4_12);
                    break block48;
                }
                catch (OutOfMemoryError var26_14) {
                    var27_16 = this.stack2.getImageArray();
                    if (var27_16 == null) break block49;
                    var28_18 = 0;
                    ** while (var28_18 < var27_16.length)
                }
lbl-1000:
                // 1 sources

                {
                    var27_16[var28_18] = null;
                    ++var28_18;
                    continue;
                }
            }
            this.stack2 = null;
            IJ.showMessage("Projector - Out of Memory", "To use less memory, use a rectanguar\nselection,  reduce \"Total Rotation\",\nand/or increase \"Angle Increment\".");
            return null;
        }
        var26_15 = new ImagePlus("Projections of " + var1_1.getShortTitle(), this.stack2);
        var26_15.show();
        var27_17 = var1_1.getWindow();
        if (var27_17 != null) {
            var27_17.running = true;
        }
        var8_21 = Projector.initAngle;
        var19_22 = 0;
        while (var19_22 < var20_4) {
            IJ.showStatus(var19_22 + "/" + var20_4);
            IJ.showProgress((double)var19_22 / (double)var20_4);
            var9_23 = (double)var8_21 * 3.141592653589793 / 180.0;
            var12_25 = (int)(8192.0 * Math.cos(var9_23) + 0.5);
            var11_24 = (int)(8192.0 * Math.sin(var9_23) + 0.5);
            this.projArray = (byte[])this.stack2.getPixels(var19_22 + 1);
            if (this.projArray == null) break;
            if (Projector.projectionMethod == 0 || Projector.opacity > 0) {
                var28_19 = 0;
                while (var28_19 < var25_13) {
                    this.zBuffer[var28_19] = 32767;
                    ++var28_19;
                }
            }
            if (Projector.opacity > 0 && Projector.projectionMethod != 0) {
                var28_19 = 0;
                while (var28_19 < var25_13) {
                    this.opaArray[var28_19] = 0;
                    ++var28_19;
                }
            }
            if (Projector.projectionMethod == 1 && Projector.depthCueInt < 100) {
                var28_19 = 0;
                while (var28_19 < var25_13) {
                    this.brightCueArray[var28_19] = 0;
                    ++var28_19;
                }
                var29_31 = 0;
                while (var29_31 < var25_13) {
                    this.cueZBuffer[var29_31] = 0;
                    ++var29_31;
                }
            }
            if (Projector.projectionMethod == 2) {
                var28_19 = 0;
                while (var28_19 < var25_13) {
                    this.sumBuffer[var28_19] = 0;
                    ++var28_19;
                }
                var29_31 = 0;
                while (var29_31 < var25_13) {
                    this.countBuffer[var29_31] = 0;
                    ++var29_31;
                }
            }
            switch (Projector.axisOfRotation) {
                case 0: {
                    this.doOneProjectionX(var2_7, var6_9, var7_10, var3_11, var4_12, var12_25, var11_24);
                    break;
                }
                case 1: {
                    this.doOneProjectionY(var2_7, var5_8, var7_10, var3_11, var4_12, var12_25, var11_24);
                    break;
                }
                case 2: {
                    this.doOneProjectionZ(var2_7, var5_8, var6_9, var7_10, var3_11, var4_12, var12_25, var11_24);
                }
            }
            if (Projector.projectionMethod == 2) {
                var29_31 = 0;
                while (var29_31 < var25_13) {
                    var28_19 = this.countBuffer[var29_31];
                    if (var28_19 != 0) {
                        this.projArray[var29_31] = (byte)(this.sumBuffer[var29_31] / var28_19);
                    }
                    ++var29_31;
                }
            }
            if (Projector.opacity > 0 && Projector.projectionMethod != 0) {
                var28_19 = 0;
                while (var28_19 < var25_13) {
                    this.projArray[var28_19] = (byte)((Projector.opacity * (this.opaArray[var28_19] & 255) + (100 - Projector.opacity) * (this.projArray[var28_19] & 255)) / 100);
                    ++var28_19;
                }
            }
            if (Projector.axisOfRotation == 2) {
                var28_19 = var3_11;
                while (var28_19 < var25_13 - var3_11) {
                    var14_26 = this.projArray[var28_19] & 255;
                    var15_27 = this.projArray[var28_19 - 1] & 255;
                    var16_28 = this.projArray[var28_19 + 1] & 255;
                    var17_29 = this.projArray[var28_19 - var3_11] & 255;
                    var18_30 = this.projArray[var28_19 + var3_11] & 255;
                    if (var14_26 == 0 && var15_27 != 0 && var16_28 != 0 && var17_29 != 0 && var18_30 != 0) {
                        this.projArray[var28_19] = (byte)((var15_27 + var16_28 + var17_29 + var18_30) / 4);
                    }
                    ++var28_19;
                }
            }
            var8_21 = (var8_21 + Projector.angleInc) % 360;
            if (var26_15.getWindow() == null) break;
            var26_15.setSlice(var19_22 + 1);
            if (var27_17 != null && !var27_17.running) break;
            ++var19_22;
        }
        IJ.showProgress(1.0);
        if (Projector.debugMode) {
            if (this.projArray != null) {
                new ImagePlus("projArray", new ByteProcessor(var3_11, var4_12, this.projArray, null)).show();
            }
            if (this.opaArray != null) {
                new ImagePlus("opaArray", new ByteProcessor(var3_11, var4_12, this.opaArray, null)).show();
            }
            if (this.brightCueArray != null) {
                new ImagePlus("brightCueArray", new ByteProcessor(var3_11, var4_12, this.brightCueArray, null)).show();
            }
            if (this.zBuffer != null) {
                new ImagePlus("zBuffer", new ShortProcessor(var3_11, var4_12, this.zBuffer, null)).show();
            }
            if (this.cueZBuffer != null) {
                new ImagePlus("cueZBuffer", new ShortProcessor(var3_11, var4_12, this.cueZBuffer, null)).show();
            }
            if (this.countBuffer != null) {
                new ImagePlus("countBuffer", new ShortProcessor(var3_11, var4_12, this.countBuffer, null)).show();
            }
            if (this.sumBuffer != null) {
                var28_20 = new float[var3_11 * var4_12];
                var29_31 = 0;
                while (var29_31 < var3_11 * var4_12) {
                    var28_20[var29_31] = this.sumBuffer[var29_31];
                    ++var29_31;
                }
                new ImagePlus("sumBuffer", new FloatProcessor(var3_11, var4_12, var28_20, null)).show();
            }
        }
        return var26_15;
    }

    void allocateArrays(int n, int n2, int n3) {
        int n4 = n2 * n3;
        ColorModel colorModel = this.imp.getProcessor().getColorModel();
        if (this.isRGB) {
            colorModel = null;
        }
        this.stack2 = new ImageStack(n2, n3, colorModel);
        this.projArray = new byte[n4];
        int n5 = 0;
        while (n5 < n) {
            this.stack2.addSlice(null, new byte[n4]);
            ++n5;
        }
        if (projectionMethod == 0 || opacity > 0) {
            this.zBuffer = new short[n4];
        }
        if (opacity > 0 && projectionMethod != 0) {
            this.opaArray = new byte[n4];
        }
        if (projectionMethod == 1 && depthCueInt < 100) {
            this.brightCueArray = new byte[n4];
            this.cueZBuffer = new short[n4];
        }
        if (projectionMethod == 2) {
            this.sumBuffer = new int[n4];
            this.countBuffer = new short[n4];
        }
    }

    void doOneProjectionX(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n4 * n5;
        int n9 = n3 + n5 / 2;
        int n10 = n3 - n5 / 2;
        int n11 = 100 * (n9 - n10);
        int n12 = 100 - depthCueInt;
        int n13 = 100 - depthCueSurf;
        boolean bl = depthCueInt < 100;
        boolean bl2 = depthCueSurf < 100;
        boolean bl3 = projectionMethod == 0 || opacity > 0;
        boolean bl4 = opacity > 0 && projectionMethod != 0;
        boolean bl5 = projectionMethod == 2;
        boolean bl6 = projectionMethod == 1;
        int n14 = (this.top - n2 - 1) * n6;
        int n15 = (this.top - n2 - 1) * n7;
        int n16 = (n5 - this.bottom + this.top) / 2 * n4 + (n4 - this.right + this.left) / 2 - 1;
        int n17 = 1;
        while (n17 <= n) {
            byte[] byArray = (byte[])this.stack.getPixels(n17);
            int n18 = (int)((double)(n17 - 1) * this.sliceInterval + 0.5) - n3;
            int n19 = n18 * n6;
            int n20 = n18 * n7;
            int n21 = n14;
            int n22 = n15;
            int n23 = this.top;
            while (n23 < this.bottom) {
                int n24 = ((n21 += n6) - n20) / 8192 + n2 - this.top;
                int n25 = ((n22 += n7) + n19) / 8192 + n3;
                int n26 = n16 + n24 * n4;
                int n27 = n23 * this.imageWidth;
                int n28 = this.left;
                while (n28 < this.right) {
                    int n29 = byArray[n27 + n28] & 0xFF;
                    if (++n26 >= n8 || n26 < 0) {
                        n26 = 0;
                    }
                    if (n29 <= this.transparencyUpper && n29 >= this.transparencyLower) {
                        if (bl3 && n25 < this.zBuffer[n26]) {
                            this.zBuffer[n26] = (short)n25;
                            if (bl4) {
                                this.opaArray[n26] = bl2 ? (byte)(depthCueSurf * n29 / 100 + n13 * n29 * (n9 - n25) / n11) : (byte)n29;
                            } else {
                                this.projArray[n26] = bl2 ? (byte)(depthCueSurf * n29 / 100 + n13 * n29 * (n9 - n25) / n11) : (byte)n29;
                            }
                        }
                        if (bl5) {
                            int n30 = n26;
                            this.sumBuffer[n30] = this.sumBuffer[n30] + n29;
                            int n31 = n26;
                            this.countBuffer[n31] = (short)(this.countBuffer[n31] + 1);
                        } else if (bl6) {
                            if (bl) {
                                if (n29 > (this.brightCueArray[n26] & 0xFF) || n29 == (this.brightCueArray[n26] & 0xFF) && n25 > this.cueZBuffer[n26]) {
                                    this.brightCueArray[n26] = (byte)n29;
                                    this.cueZBuffer[n26] = (short)n25;
                                    this.projArray[n26] = (byte)(255 - (depthCueInt * (255 - n29) / 100 + n12 * (255 - n29) * (n9 - n25) / n11));
                                }
                            } else if (n29 > (this.projArray[n26] & 0xFF)) {
                                this.projArray[n26] = (byte)n29;
                            }
                        }
                    }
                    ++n28;
                }
                ++n23;
            }
            ++n17;
        }
    }

    void doOneProjectionY(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n4 * n5;
        int n9 = n3 + n4 / 2;
        int n10 = n3 - n4 / 2;
        int n11 = 100 * (n9 - n10);
        int n12 = 100 - depthCueInt;
        int n13 = 100 - depthCueSurf;
        boolean bl = depthCueInt < 100;
        boolean bl2 = depthCueSurf < 100;
        boolean bl3 = projectionMethod == 0 || opacity > 0;
        boolean bl4 = opacity > 0 && projectionMethod != 0;
        boolean bl5 = projectionMethod == 2;
        boolean bl6 = projectionMethod == 1;
        int n14 = (this.left - n2 - 1) * n6;
        int n15 = (this.left - n2 - 1) * n7;
        int n16 = 1;
        while (n16 <= n) {
            byte[] byArray = (byte[])this.stack.getPixels(n16);
            int n17 = (int)((double)(n16 - 1) * this.sliceInterval + 0.5) - n3;
            int n18 = n17 * n6;
            int n19 = n17 * n7;
            int n20 = (n5 - this.bottom + this.top) / 2 * n4 + (n4 - this.right + this.left) / 2 - n4;
            int n21 = this.top;
            while (n21 < this.bottom) {
                int n22 = n14;
                int n23 = n15;
                n20 += n4;
                int n24 = n21 * this.imageWidth;
                int n25 = this.left;
                while (n25 < this.right) {
                    int n26 = byArray[n24 + n25] & 0xFF;
                    n22 += n6;
                    n23 += n7;
                    if (n26 <= this.transparencyUpper && n26 >= this.transparencyLower) {
                        int n27 = (n22 + n19) / 8192 + n2 - this.left;
                        int n28 = (n18 - n23) / 8192 + n3;
                        int n29 = n20 + n27;
                        if (n29 >= n8 || n29 < 0) {
                            n29 = 0;
                        }
                        if (bl3 && n28 < this.zBuffer[n29]) {
                            this.zBuffer[n29] = (short)n28;
                            if (bl4) {
                                this.opaArray[n29] = bl2 ? (byte)(depthCueSurf * n26 / 100 + n13 * n26 * (n9 - n28) / n11) : (byte)n26;
                            } else {
                                this.projArray[n29] = bl2 ? (byte)(depthCueSurf * n26 / 100 + n13 * n26 * (n9 - n28) / n11) : (byte)n26;
                            }
                        }
                        if (bl5) {
                            int n30 = n29;
                            this.sumBuffer[n30] = this.sumBuffer[n30] + n26;
                            int n31 = n29;
                            this.countBuffer[n31] = (short)(this.countBuffer[n31] + 1);
                        } else if (bl6) {
                            if (bl) {
                                if (n26 > (this.brightCueArray[n29] & 0xFF) || n26 == (this.brightCueArray[n29] & 0xFF) && n28 > this.cueZBuffer[n29]) {
                                    this.brightCueArray[n29] = (byte)n26;
                                    this.cueZBuffer[n29] = (short)n28;
                                    this.projArray[n29] = (byte)(depthCueInt * n26 / 100 + n12 * n26 * (n9 - n28) / n11);
                                }
                            } else if (n26 > (this.projArray[n29] & 0xFF)) {
                                this.projArray[n29] = (byte)n26;
                            }
                        }
                    }
                    ++n25;
                }
                ++n21;
            }
            ++n16;
        }
    }

    void doOneProjectionZ(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n5 * n6;
        int n10 = (int)((double)(n - 1) * this.sliceInterval + 0.5) - n4;
        int n11 = -n4;
        int n12 = 100 * (n10 - n11);
        int n13 = 100 - depthCueInt;
        int n14 = 100 - depthCueSurf;
        boolean bl = depthCueInt < 100;
        boolean bl2 = depthCueSurf < 100;
        boolean bl3 = projectionMethod == 0 || opacity > 0;
        boolean bl4 = opacity > 0 && projectionMethod != 0;
        boolean bl5 = projectionMethod == 2;
        boolean bl6 = projectionMethod == 1;
        int n15 = (this.left - n2 - 1) * n7;
        int n16 = (this.left - n2 - 1) * n8;
        int n17 = (this.top - n3 - 1) * n7;
        int n18 = (this.top - n3 - 1) * n8;
        int n19 = (n6 - this.bottom + this.top) / 2 * n5 + (n5 - this.right + this.left) / 2 - 1;
        int n20 = 1;
        while (n20 <= n) {
            byte[] byArray = (byte[])this.stack.getPixels(n20);
            int n21 = (int)((double)(n20 - 1) * this.sliceInterval + 0.5) - n4;
            int n22 = n17;
            int n23 = n18;
            int n24 = this.top;
            while (n24 < this.bottom) {
                n22 += n7;
                n23 += n8;
                int n25 = n15;
                int n26 = n16;
                int n27 = n24 * this.imageWidth;
                int n28 = this.left;
                while (n28 < this.right) {
                    int n29 = byArray[n27 + n28] & 0xFF;
                    n25 += n7;
                    n26 += n8;
                    if (n29 <= this.transparencyUpper && n29 >= this.transparencyLower) {
                        int n30 = (n26 + n22) / 8192 + n3 - this.top;
                        int n31 = (n25 - n23) / 8192 + n2 - this.left;
                        int n32 = n19 + n30 * n5 + n31;
                        if (n32 >= n9 || n32 < 0) {
                            n32 = 0;
                        }
                        if (bl3 && n21 < this.zBuffer[n32]) {
                            this.zBuffer[n32] = (short)n21;
                            if (bl4) {
                                this.opaArray[n32] = bl2 ? (byte)(depthCueSurf * n29 / 100 + n14 * n29 * (n10 - n21) / n12) : (byte)n29;
                            } else if (bl2) {
                                int n33 = depthCueSurf * n29 / 100 + n14 * n29 * (n10 - n21) / n12;
                                this.projArray[n32] = (byte)n33;
                            } else {
                                this.projArray[n32] = (byte)n29;
                            }
                        }
                        if (bl5) {
                            int n34 = n32;
                            this.sumBuffer[n34] = this.sumBuffer[n34] + n29;
                            int n35 = n32;
                            this.countBuffer[n35] = (short)(this.countBuffer[n35] + 1);
                        } else if (bl6) {
                            if (bl) {
                                if (n29 > (this.brightCueArray[n32] & 0xFF) || n29 == (this.brightCueArray[n32] & 0xFF) && n21 > this.cueZBuffer[n32]) {
                                    this.brightCueArray[n32] = (byte)n29;
                                    this.cueZBuffer[n32] = (short)n21;
                                    this.projArray[n32] = (byte)(depthCueInt * n29 / 100 + n13 * n29 * (n10 - n21) / n12);
                                }
                            } else if (n29 > (this.projArray[n32] & 0xFF)) {
                                this.projArray[n32] = (byte)n29;
                            }
                        }
                    }
                    ++n28;
                }
                ++n24;
            }
            ++n20;
        }
    }

    ImagePlus zScale(ImagePlus imagePlus) {
        IJ.showStatus("Z Scaling...");
        ImageStack imageStack = imagePlus.getStack();
        int n = imageStack.getSize();
        ImagePlus imagePlus2 = null;
        String string = imagePlus.getTitle();
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = (int)((double)imageStack.getSize() * this.sliceInterval + 0.5);
        imagePlus2 = this.isRGB ? NewImage.createRGBImage(string, n2, n3, n4, 1) : NewImage.createByteImage(string, n2, n3, n4, 1);
        ImageStack imageStack2 = imagePlus2.getStack();
        ImageProcessor imageProcessor = imagePlus.getProcessor().createProcessor(n2, n);
        imageProcessor.setInterpolate(true);
        int[] nArray = new int[n2];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n) {
                if (this.isRGB) {
                    this.getRGBRow(imageStack, n5, n6, n2, nArray);
                } else {
                    this.getByteRow(imageStack, n5, n6, n2, nArray);
                }
                imageProcessor.putRow(0, n6, nArray, n2);
                ++n6;
            }
            ImageProcessor imageProcessor2 = imageProcessor.resize(n2, n4);
            int n7 = 0;
            while (n7 < n4) {
                imageProcessor2.getRow(0, n7, nArray, n2);
                if (this.isRGB) {
                    this.putRGBRow(imageStack2, n5, n7, n2, nArray);
                } else {
                    this.putByteRow(imageStack2, n5, n7, n2, nArray);
                }
                ++n7;
            }
            ++n5;
        }
        return imagePlus2;
    }

    public void getByteRow(ImageStack imageStack, int n, int n2, int n3, int[] nArray) {
        byte[] byArray = (byte[])imageStack.getPixels(n2 + 1);
        int n4 = n * n3;
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5] = byArray[n4++] & 0xFF;
            ++n5;
        }
    }

    public void putByteRow(ImageStack imageStack, int n, int n2, int n3, int[] nArray) {
        byte[] byArray = (byte[])imageStack.getPixels(n2 + 1);
        int n4 = n * n3;
        int n5 = 0;
        while (n5 < n3) {
            byArray[n4++] = (byte)nArray[n5];
            ++n5;
        }
    }

    public void getRGBRow(ImageStack imageStack, int n, int n2, int n3, int[] nArray) {
        int[] nArray2 = (int[])imageStack.getPixels(n2 + 1);
        int n4 = n * n3;
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5] = nArray2[n4++];
            ++n5;
        }
    }

    public void putRGBRow(ImageStack imageStack, int n, int n2, int n3, int[] nArray) {
        int[] nArray2 = (int[])imageStack.getPixels(n2 + 1);
        int n4 = n * n3;
        int n5 = 0;
        while (n5 < n3) {
            nArray2[n4++] = nArray[n5];
            ++n5;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

