/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.ImagePlus;
import ij.measure.Measurements;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

class ThresholdPlot
extends Canvas
implements Measurements,
MouseListener {
    static final int WIDTH = 256;
    static final int HEIGHT = 48;
    double minThreshold = 85.0;
    double maxThreshold = 170.0;
    int[] histogram;
    Color[] hColors;
    int hmax;
    Image os;
    Graphics osg;
    int mode;

    public ThresholdPlot() {
        this.addMouseListener(this);
        this.setSize(257, 49);
    }

    void setHistogram(ImagePlus imagePlus) {
        Object object;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (!(imageProcessor instanceof ByteProcessor)) {
            double d = imageProcessor.getMin();
            double d2 = imageProcessor.getMax();
            imageProcessor.setMinAndMax(d, d2);
            object = imageProcessor.getRoi();
            imageProcessor = new ByteProcessor(imageProcessor.createImage());
            imageProcessor.setRoi((Rectangle)object);
        }
        imageProcessor.setMask(imagePlus.getMask());
        ImageStatistics imageStatistics = ImageStatistics.getStatistics(imageProcessor, 9, null);
        int n = 0;
        this.histogram = imageStatistics.histogram;
        int n2 = 0;
        while (n2 < imageStatistics.nBins) {
            if (this.histogram[n2] > n && n2 != imageStatistics.mode) {
                n = this.histogram[n2];
            }
            ++n2;
        }
        this.hmax = imageStatistics.maxCount;
        if (this.hmax > n * 2 && n != 0) {
            this.histogram[imageStatistics.mode] = this.hmax = (int)((double)n * 1.5);
        }
        this.os = null;
        ColorModel colorModel = imageProcessor.getColorModel();
        if (!(colorModel instanceof IndexColorModel)) {
            return;
        }
        object = (IndexColorModel)colorModel;
        int n3 = ((IndexColorModel)object).getMapSize();
        if (n3 != 256) {
            return;
        }
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        ((IndexColorModel)object).getReds(byArray);
        ((IndexColorModel)object).getGreens(byArray2);
        ((IndexColorModel)object).getBlues(byArray3);
        this.hColors = new Color[256];
        int n4 = 0;
        while (n4 < 256) {
            this.hColors[n4] = new Color(byArray[n4] & 0xFF, byArray2[n4] & 0xFF, byArray3[n4] & 0xFF);
            ++n4;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.histogram != null) {
            if (this.os == null) {
                this.os = this.createImage(256, 48);
                this.osg = this.os.getGraphics();
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, 256, 48);
                this.osg.setColor(Color.gray);
                int n = 0;
                while (n < 256) {
                    if (this.hColors != null) {
                        this.osg.setColor(this.hColors[n]);
                    }
                    this.osg.drawLine(n, 48, n, 48 - 48 * this.histogram[n] / this.hmax);
                    ++n;
                }
                this.osg.dispose();
            }
            graphics.drawImage(this.os, 0, 0, this);
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, 256, 48);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, 256, 48);
        if (this.mode == 0) {
            graphics.setColor(Color.red);
        } else if (this.mode == 2) {
            graphics.setColor(Color.blue);
            graphics.drawRect(1, 1, (int)this.minThreshold - 2, 48);
            graphics.drawRect(1, 0, (int)this.minThreshold - 2, 0);
            graphics.setColor(Color.green);
            graphics.drawRect((int)this.maxThreshold + 1, 1, 256 - (int)this.maxThreshold, 48);
            graphics.drawRect((int)this.maxThreshold + 1, 0, 256 - (int)this.maxThreshold, 0);
            return;
        }
        graphics.drawRect((int)this.minThreshold, 1, (int)(this.maxThreshold - this.minThreshold), 48);
        graphics.drawLine((int)this.minThreshold, 0, (int)this.maxThreshold, 0);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

