/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ShortStatistics
extends ImageStatistics {
    public ShortStatistics(ImageProcessor imageProcessor) {
        this(imageProcessor, 27, null);
    }

    public ShortStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        int n2;
        int n3;
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        this.setup(imageProcessor, calibration);
        this.nBins = 256;
        double d = imageProcessor.getMinThreshold();
        if ((n & 0x100) == 0 || d == -808080.0) {
            n3 = 0;
            n2 = 65535;
        } else {
            n3 = (int)d;
            n2 = (int)imageProcessor.getMaxThreshold();
        }
        int[] nArray = imageProcessor.getHistogram();
        float[] fArray = calibration != null ? calibration.getCTable() : null;
        this.getRawMinAndMax(nArray, n3, n2);
        this.histMin = this.min;
        this.histMax = this.max;
        this.getStatistics(nArray, (int)this.min, (int)this.max, fArray);
        if ((n & 8) != 0) {
            this.getMode(fArray);
        }
        if ((n & 0x800) != 0) {
            this.fitEllipse(imageProcessor);
        } else if ((n & 0x20) != 0) {
            this.getCentroid(imageProcessor, n3, n2);
        }
        if ((n & 0x40) != 0) {
            this.getCenterOfMass(imageProcessor, n3, n2);
        }
        if ((n & 0x10) != 0 && fArray != null) {
            this.getCalibratedMinAndMax(nArray, (int)this.min, (int)this.max, fArray);
        }
    }

    void getRawMinAndMax(int[] nArray, int n, int n2) {
        int n3 = n;
        while (nArray[n3] == 0 && n3 < 65535) {
            ++n3;
        }
        this.min = n3;
        int n4 = n2;
        while (nArray[n4] == 0 && n4 > 0) {
            --n4;
        }
        this.max = n4;
    }

    void getStatistics(int[] nArray, int n, int n2, float[] fArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = (double)this.nBins / (this.histMax - this.histMin);
        int n3 = (int)this.histMin;
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        this.histogram = new int[this.nBins];
        int n4 = n;
        while (n4 <= n2) {
            int n5 = nArray[n4];
            this.pixelCount += n5;
            double d4 = fArray == null ? (double)n4 : (double)fArray[n4];
            d += d4 * (double)n5;
            d2 += d4 * d4 * (double)n5;
            int n6 = (int)(d3 * (double)(n4 - n3));
            if (n6 >= this.nBins) {
                n6 = this.nBins - 1;
            }
            int n7 = n6;
            this.histogram[n7] = this.histogram[n7] + n5;
            ++n4;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.umean = this.mean = d / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, d, d2);
    }

    void getMode(float[] fArray) {
        this.maxCount = 0;
        int n = 0;
        while (n < this.nBins) {
            int n2 = this.histogram[n];
            if (n2 > this.maxCount) {
                this.maxCount = n2;
                this.mode = n;
            }
            ++n;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize;
        if (fArray != null) {
            this.dmode = fArray[(int)this.dmode];
        }
    }

    void getCentroid(ImageProcessor imageProcessor, int n, int n2) {
        short[] sArray = (short[])imageProcessor.getPixels();
        int[] nArray = imageProcessor.getMask();
        boolean bl = n > 0 || n2 < 65535;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.ry;
        int n7 = 0;
        while (n6 < this.ry + this.rh) {
            int n8 = n6 * this.width + this.rx;
            int n9 = n7 * this.rw;
            int n10 = this.rx;
            while (n10 < this.rx + this.rw) {
                if (nArray == null || nArray[n9++] == -16777216) {
                    if (bl) {
                        int n11 = sArray[n8] & 0xFFFF;
                        if (n11 >= n && n11 <= n2) {
                            ++n3;
                            n4 += n10;
                            n5 += n6;
                        }
                    } else {
                        ++n3;
                        n4 += n10;
                        n5 += n6;
                    }
                }
                ++n8;
                ++n10;
            }
            ++n6;
            ++n7;
        }
        this.xCentroid = ((double)n4 / (double)n3 + 0.5) * this.pw;
        this.yCentroid = ((double)n5 / (double)n3 + 0.5) * this.ph;
    }

    void getCenterOfMass(ImageProcessor imageProcessor, int n, int n2) {
        short[] sArray = (short[])imageProcessor.getPixels();
        int[] nArray = imageProcessor.getMask();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = this.ry;
        int n4 = 0;
        while (n3 < this.ry + this.rh) {
            int n5 = n3 * this.width + this.rx;
            int n6 = n4 * this.rw;
            int n7 = this.rx;
            while (n7 < this.rx + this.rw) {
                int n8;
                if ((nArray == null || nArray[n6++] == -16777216) && (n8 = sArray[n5] & 0xFFFF) >= n && n8 <= n2) {
                    d += (double)n8;
                    d2 += (double)(n7 * n8);
                    d3 += (double)(n3 * n8);
                }
                ++n5;
                ++n7;
            }
            ++n3;
            ++n4;
        }
        this.xCenterOfMass = (d2 / d + 0.5) * this.pw;
        this.yCenterOfMass = (d3 / d + 0.5) * this.ph;
    }

    void getCalibratedMinAndMax(int[] nArray, int n, int n2, float[] fArray) {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        double d = 0.0;
        int n3 = n;
        while (n3 <= n2) {
            if (nArray[n3] > 0) {
                d = fArray[n3];
                if (d < this.min) {
                    this.min = d;
                }
                if (d > this.max) {
                    this.max = d;
                }
            }
            ++n3;
        }
    }
}

