/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.BinaryDatatypeValidator;
import org.apache.xerces.validators.datatype.BooleanDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactory;
import org.apache.xerces.validators.datatype.DecimalDatatypeValidator;
import org.apache.xerces.validators.datatype.DoubleDatatypeValidator;
import org.apache.xerces.validators.datatype.ENTITYDatatypeValidator;
import org.apache.xerces.validators.datatype.FloatDatatypeValidator;
import org.apache.xerces.validators.datatype.IDDatatypeValidator;
import org.apache.xerces.validators.datatype.IDREFDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.ListDatatypeValidator;
import org.apache.xerces.validators.datatype.NOTATIONDatatypeValidator;
import org.apache.xerces.validators.datatype.QNameDatatypeValidator;
import org.apache.xerces.validators.datatype.RecurringDurationDatatypeValidator;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;
import org.apache.xerces.validators.datatype.TimeDurationDatatypeValidator;
import org.apache.xerces.validators.datatype.URIReferenceDatatypeValidator;

public class DatatypeValidatorFactoryImpl
implements DatatypeValidatorFactory {
    private static final boolean fDebug = false;
    private static DatatypeValidatorFactoryImpl _instance = new DatatypeValidatorFactoryImpl();
    private Hashtable fRegistry = new Hashtable();
    static /* synthetic */ Class class$org$apache$xerces$validators$datatype$DatatypeValidator;
    static /* synthetic */ Class class$java$util$Hashtable;

    private DatatypeValidatorFactoryImpl() {
        this.initializeRegistry();
    }

    void initializeRegistry() {
        Object var1_1 = null;
        try {
            this.fRegistry.put("string", new StringDatatypeValidator());
            this.fRegistry.put("boolean", new BooleanDatatypeValidator());
            this.fRegistry.put("float", new FloatDatatypeValidator());
            this.fRegistry.put("double", new DoubleDatatypeValidator());
            this.fRegistry.put("decimal", new DecimalDatatypeValidator());
            this.fRegistry.put("timeDuration", new TimeDurationDatatypeValidator());
            this.fRegistry.put("recurringDuration", new RecurringDurationDatatypeValidator());
            this.fRegistry.put("binary", new BinaryDatatypeValidator());
            this.fRegistry.put("uriReference", new URIReferenceDatatypeValidator());
            this.fRegistry.put("ID", new IDDatatypeValidator());
            this.fRegistry.put("IDREF", new IDREFDatatypeValidator());
            this.fRegistry.put("ENTITY", new ENTITYDatatypeValidator());
            this.fRegistry.put("NOTATION", new NOTATIONDatatypeValidator());
            this.fRegistry.put("QName", new QNameDatatypeValidator());
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("pattern", "([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]+)(-[a-zA-Z]+)*");
            this.createDatatypeValidator("language", new StringDatatypeValidator(), hashtable, false);
            this.createDatatypeValidator("IDREFS", new IDREFDatatypeValidator(), null, true);
            this.createDatatypeValidator("ENTITIES", new ENTITYDatatypeValidator(), null, true);
            hashtable = new Hashtable();
            hashtable.put("pattern", "\\c+");
            this.createDatatypeValidator("NMTOKEN", new StringDatatypeValidator(), hashtable, false);
            this.createDatatypeValidator("NMTOKENS", this.getDatatypeValidator("NMTOKEN"), null, true);
            hashtable = new Hashtable();
            hashtable.put("pattern", "\\i\\c*");
            this.createDatatypeValidator("Name", new StringDatatypeValidator(), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("pattern", "[\\i-[:]][\\c-[:]]*");
            this.createDatatypeValidator("NCName", new StringDatatypeValidator(), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("scale", "0");
            this.createDatatypeValidator("integer", new DecimalDatatypeValidator(), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("maxInclusive", "0");
            this.createDatatypeValidator("nonPositiveInteger", this.getDatatypeValidator("integer"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("maxInclusive", "-1");
            this.createDatatypeValidator("negativeInteger", this.getDatatypeValidator("nonPositiveInteger"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("maxInclusive", "9223372036854775807");
            hashtable.put("minInclusive", "-9223372036854775808");
            this.createDatatypeValidator("long", this.getDatatypeValidator("integer"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("maxInclusive", "2147483647");
            hashtable.put("minInclusive", "-2147483648");
            this.createDatatypeValidator("int", this.getDatatypeValidator("long"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("maxInclusive", "32767");
            hashtable.put("minInclusive", "-32768");
            this.createDatatypeValidator("short", this.getDatatypeValidator("int"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("maxInclusive", "127");
            hashtable.put("minInclusive", "-128");
            this.createDatatypeValidator("byte", this.getDatatypeValidator("short"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("minInclusive", "0");
            this.createDatatypeValidator("nonNegativeInteger", this.getDatatypeValidator("integer"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("maxInclusive", "18446744073709551615");
            this.createDatatypeValidator("unsignedLong", this.getDatatypeValidator("nonNegativeInteger"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("maxInclusive", "4294967295");
            this.createDatatypeValidator("unsignedInt", this.getDatatypeValidator("unsignedLong"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("maxInclusive", "65535");
            this.createDatatypeValidator("unsignedShort", this.getDatatypeValidator("unsignedInt"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("maxInclusive", "255");
            this.createDatatypeValidator("unsignedByte", this.getDatatypeValidator("unsignedShort"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("minInclusive", "1");
            this.createDatatypeValidator("positiveInteger", this.getDatatypeValidator("nonNegativeInteger"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("duration", "P0Y");
            hashtable.put("period", "P0Y");
            this.createDatatypeValidator("timeInstant", this.getDatatypeValidator("recurringDuration"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("duration", "P0Y");
            this.createDatatypeValidator("time", this.getDatatypeValidator("recurringDuration"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("period", "P0Y");
            this.createDatatypeValidator("timePeriod", this.getDatatypeValidator("recurringDuration"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("duration", "PT24H");
            this.createDatatypeValidator("date", this.getDatatypeValidator("timePeriod"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("duration", "P1M");
            this.createDatatypeValidator("month", this.getDatatypeValidator("timePeriod"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("duration", "P1Y");
            this.createDatatypeValidator("year", this.getDatatypeValidator("timePeriod"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("duration", "P100Y");
            this.createDatatypeValidator("century", this.getDatatypeValidator("timePeriod"), hashtable, false);
            hashtable = new Hashtable();
            hashtable.put("period", "P1Y");
            hashtable.put("duration", "PT24H");
            this.createDatatypeValidator("recurringDate", this.getDatatypeValidator("recurringDuration"), hashtable, false);
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            invalidDatatypeFacetException.printStackTrace();
        }
    }

    public void resetRegistry() {
        this.fRegistry.clear();
        this.initializeRegistry();
    }

    public DatatypeValidator createDatatypeValidator(String string, DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        DatatypeValidator datatypeValidator2 = null;
        if (false) {
            System.out.println("type name = " + string);
        }
        if (datatypeValidator != null) {
            if (bl) {
                datatypeValidator2 = new ListDatatypeValidator(datatypeValidator, hashtable, bl);
            } else {
                try {
                    Class<?> clazz = datatypeValidator.getClass();
                    Class[] classArray = new Class[]{class$org$apache$xerces$validators$datatype$DatatypeValidator == null ? (class$org$apache$xerces$validators$datatype$DatatypeValidator = DatatypeValidatorFactoryImpl.class$("org.apache.xerces.validators.datatype.DatatypeValidator")) : class$org$apache$xerces$validators$datatype$DatatypeValidator, class$java$util$Hashtable == null ? (class$java$util$Hashtable = DatatypeValidatorFactoryImpl.class$("java.util.Hashtable")) : class$java$util$Hashtable, Boolean.TYPE};
                    Object[] objectArray = new Object[]{datatypeValidator, hashtable, Boolean.FALSE};
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    datatypeValidator2 = (DatatypeValidator)DatatypeValidatorFactoryImpl.createDatatypeValidator(constructor, objectArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
            }
            if (datatypeValidator2 != null) {
                this.addValidator(string, datatypeValidator2);
            }
        }
        return datatypeValidator2;
    }

    private static Object createDatatypeValidator(Constructor constructor, Object[] objectArray) throws InvalidDatatypeFacetException {
        Object var2_2 = null;
        try {
            var2_2 = constructor.newInstance(objectArray);
            return var2_2;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvalidDatatypeFacetException(invocationTargetException.getTargetException().getMessage());
        }
    }

    public DatatypeValidator getDatatypeValidator(String string) {
        AbstractDatatypeValidator abstractDatatypeValidator = null;
        if (string != null && this.fRegistry != null && this.fRegistry.containsKey(string)) {
            abstractDatatypeValidator = (AbstractDatatypeValidator)this.fRegistry.get(string);
        }
        return abstractDatatypeValidator;
    }

    private void addValidator(String string, DatatypeValidator datatypeValidator) {
        this.fRegistry.put(string, datatypeValidator);
    }

    public static DatatypeValidatorFactoryImpl getDatatypeRegistry() {
        return _instance;
    }

    public static void main(String[] stringArray) {
        DatatypeValidatorFactoryImpl datatypeValidatorFactoryImpl = DatatypeValidatorFactoryImpl.getDatatypeRegistry();
        DatatypeValidator datatypeValidator = datatypeValidatorFactoryImpl.getDatatypeValidator("NTOKEN");
        DatatypeValidator datatypeValidator2 = datatypeValidatorFactoryImpl.getDatatypeValidator("NTOKENS");
        System.out.println("NMTOKEN = " + datatypeValidator);
        System.out.println("NMTOKENS = " + datatypeValidator2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

