/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TextEncoder {
    private ImageProcessor ip;
    private Calibration cal;
    private int precision;

    public TextEncoder(ImageProcessor imageProcessor, Calibration calibration, int n) {
        this.ip = imageProcessor;
        this.cal = calibration;
        this.precision = n;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        boolean bl;
        PrintWriter printWriter = new PrintWriter(dataOutputStream);
        boolean bl2 = bl = this.cal != null && this.cal.calibrated();
        if (bl) {
            this.ip.setCalibrationTable(this.cal.getCTable());
        } else {
            this.ip.setCalibrationTable(null);
        }
        boolean bl3 = !bl && (this.ip instanceof ByteProcessor || this.ip instanceof ShortProcessor);
        int n = this.ip.getWidth();
        int n2 = this.ip.getHeight();
        int n3 = n2 / 20;
        if (n3 < 1) {
            n3 = 1;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                double d = this.ip.getPixelValue(n5, n4);
                if (bl3) {
                    printWriter.print((int)d);
                } else {
                    printWriter.print(IJ.d2s(d, this.precision));
                }
                if (n5 != n - 1) {
                    printWriter.print("\t");
                }
                ++n5;
            }
            printWriter.println();
            if (n4 % n3 == 0) {
                IJ.showProgress((double)n4 / (double)n2);
            }
            ++n4;
        }
        printWriter.close();
        IJ.showProgress(1.0);
    }
}

