/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class ListDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    DatatypeValidator fBaseValidator = null;
    private int fLength = 0;
    private int fMaxLength = Integer.MAX_VALUE;
    private int fMinLength = 0;
    private String fPattern = null;
    private Vector fEnumeration = null;
    private int fFacetsDefined = 0;
    private boolean fDerivedByList = false;
    private RegularExpression fRegex = null;

    public ListDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public ListDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
        this.fDerivedByList = bl;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                if (string2.equals("length")) {
                    ++this.fFacetsDefined;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("Length value '" + string + "' is invalid.");
                    }
                    if (this.fLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("Length value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (string2.equals("minLength")) {
                    this.fFacetsDefined += 2;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fMinLength = Integer.parseInt(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                    }
                }
                if (string2.equals("maxLength")) {
                    this.fFacetsDefined += 4;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fMaxLength = Integer.parseInt(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                    }
                }
                if (string2.equals("enumeration")) {
                    this.fFacetsDefined += 16;
                    this.fEnumeration = (Vector)hashtable.get(string2);
                    continue;
                }
                throw new InvalidDatatypeFacetException("invalid facet tag : " + string2);
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                }
            }
            if ((this.fFacetsDefined & 6) != 0 && this.fMinLength > this.fMaxLength) {
                throw new InvalidDatatypeFacetException("Value of minLength = " + this.fMinLength + "must be greater that the value of maxLength" + this.fMaxLength);
            }
        }
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (string == null && object != null) {
            this.fBaseValidator.validate(string, object);
        } else {
            this.checkContent(string, object);
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Hashtable getFacets() {
        return null;
    }

    public int compare(String string, String string2) {
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        ListDatatypeValidator listDatatypeValidator = null;
        try {
            listDatatypeValidator = new ListDatatypeValidator();
            listDatatypeValidator.fLocale = this.fLocale;
            listDatatypeValidator.fBaseValidator = this.fBaseValidator;
            listDatatypeValidator.fLength = this.fLength;
            listDatatypeValidator.fMaxLength = this.fMaxLength;
            listDatatypeValidator.fMinLength = this.fMinLength;
            listDatatypeValidator.fPattern = this.fPattern;
            listDatatypeValidator.fEnumeration = this.fEnumeration;
            listDatatypeValidator.fFacetsDefined = this.fFacetsDefined;
            listDatatypeValidator.fDerivedByList = this.fDerivedByList;
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            invalidDatatypeFacetException.printStackTrace();
        }
        return listDatatypeValidator;
    }

    private void checkContent(String string, Object object) throws InvalidDatatypeValueException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            int n = stringTokenizer.countTokens();
            if ((this.fFacetsDefined & 4) != 0 && n > this.fMaxLength) {
                throw new InvalidDatatypeValueException("Value '" + string + "' with length ='" + n + "' tokens" + "' exceeds maximum length facet of '" + this.fMaxLength + "' tokens.");
            }
            if ((this.fFacetsDefined & 2) != 0 && n < this.fMinLength) {
                throw new InvalidDatatypeValueException("Value '" + string + "' with length ='" + n + "' tokens" + "' is less than minimum length facet of '" + this.fMinLength + "' tokens.");
            }
            if ((this.fFacetsDefined & 1) != 0 && n != this.fLength) {
                throw new InvalidDatatypeValueException("Value '" + string + "' with length ='" + n + "' tokens" + "' is not equal to length facet of '" + this.fLength + "' tokens.");
            }
            if ((this.fFacetsDefined & 0x10) != 0 && !this.fEnumeration.contains(string)) {
                throw new InvalidDatatypeValueException("Value '" + string + "' must be one of " + this.fEnumeration);
            }
            if (this.fDerivedByList) {
                while (stringTokenizer.hasMoreTokens()) {
                    if (this.fBaseValidator == null) continue;
                    this.fBaseValidator.validate(stringTokenizer.nextToken(), object);
                }
            } else if (this.fBaseValidator != null) {
                this.fBaseValidator.validate(string, object);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }
}

