/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube.util;

import de.globalcube.bean.ConfigBean;
import de.globalcube.bean.GeneralBean;
import de.globalcube.bean.ReportBean;
import de.globalcube.bean.ScorecardBean;
import de.globalcube.cognos.CognosWrapper;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.GifEncoder;
import ij.process.ImageConverter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Vector;
import javax.swing.ImageIcon;

public class Utility {
    private static ConfigBean configBean;

    public static synchronized void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void setConfigBean(ConfigBean configBean) {
        Utility.configBean = configBean;
    }

    public static ConfigBean getConfigBean() {
        return configBean;
    }

    public static String checkPath(String string) {
        if (string != null && string.trim().length() > 0 && !string.endsWith("/") && !string.endsWith("\\")) {
            string = string + "\\";
        }
        return string;
    }

    public static void createDir(String string) {
        File file = new File(Utility.checkPath(string));
        file.mkdirs();
    }

    public static boolean isValidReport(ReportBean reportBean) {
        if (reportBean == null) {
            return false;
        }
        if (reportBean.getActive().equals("J") && reportBean.getReportFile() != null && reportBean.getRowData() != 0 && reportBean.getColData() != 0) {
            File file = new File(Utility.getConfigBean().getGeneral().getReportPath() + reportBean.getReportFile() + ".PPR");
            return file.exists();
        }
        return false;
    }

    public static int convertToInt(String string) {
        try {
            int n = 0;
            if (string != null && string.length() > 0) {
                n = new Integer(string);
            }
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static boolean isNumeric(String string) {
        try {
            int n = 0;
            if (string != null && string.length() > 0) {
                n = new Integer(string);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static double convertToDouble(String string) {
        try {
            double d = 0.0;
            if (string != null && string.length() > 0) {
                d = new Double(string);
            }
            return d;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static boolean isDouble(String string) {
        try {
            double d = 0.0;
            if (string != null && string.length() > 0) {
                d = new Double(string);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ImageIcon getImageIcon(String string) {
        return new ImageIcon("Images/" + string + ".gif");
    }

    public static boolean checkGeneralConfiguration() {
        boolean bl = false;
        GeneralBean generalBean = null;
        if (configBean == null) {
            return bl;
        }
        generalBean = configBean.getGeneral();
        if (generalBean == null || generalBean.getReportPath() == null || generalBean.getPublishPath() == null || generalBean.getPublishAlarmPath() == null || generalBean.getPublishImagePath() == null || generalBean.getWebServerName() == null || generalBean.getPortalStartPage() == null || generalBean.getPdfURL() == null || generalBean.getReportURL() == null) {
            return bl;
        }
        return true;
    }

    public static void writeToFile(String string, StringBuffer stringBuffer) {
        try {
            Utility.createDir(new File(string).getParentFile().getAbsolutePath());
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(stringBuffer.toString().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void initReports() {
        CognosWrapper cognosWrapper = null;
        double d = 0.0;
        Vector vector = Utility.getConfigBean().getScorecards();
        ScorecardBean scorecardBean = null;
        Vector vector2 = null;
        ReportBean reportBean = null;
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                scorecardBean = (ScorecardBean)vector.elementAt(n);
                vector2 = scorecardBean.getReports();
                if (vector2 != null) {
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        reportBean = (ReportBean)vector2.elementAt(n2);
                        if (Utility.isValidReport(reportBean)) {
                            cognosWrapper = new CognosWrapper(Utility.getConfigBean().getGeneral().getReportPath() + reportBean.getReportFile() + ".PPR");
                            d = cognosWrapper.getCellValue(reportBean.getRowData(), reportBean.getColData());
                            if (d != -1.0) {
                                reportBean.setCurrentValue(d);
                            }
                            cognosWrapper = null;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public static void runFile(String string) {
        String string2 = "rundll32 url.dll,FileProtocolHandler " + string;
        Utility.run(string2);
    }

    public static void run(String string) {
        try {
            Runtime.getRuntime().exec(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void JPG2GIF(String string, String string2) {
        try {
            ImagePlus imagePlus = new ImagePlus(string);
            ImageConverter imageConverter = new ImageConverter(imagePlus);
            imageConverter.convertRGBtoIndexedColor(256);
            FileInfo fileInfo = imagePlus.getFileInfo();
            byte[] byArray = (byte[])imagePlus.getProcessor().getPixels();
            GifEncoder gifEncoder = new GifEncoder(fileInfo.width, fileInfo.height, byArray, fileInfo.reds, fileInfo.greens, fileInfo.blues);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            gifEncoder.write((OutputStream)bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            System.out.println("Error while trying to convert JPG to GIF");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void copyFile(File file, File file2) {
        block21: {
            Exception exception2222;
            FilterOutputStream filterOutputStream;
            BufferedInputStream bufferedInputStream;
            block19: {
                int n;
                bufferedInputStream = null;
                filterOutputStream = null;
                if (!file.exists()) {
                    return;
                }
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                file2.getParentFile().mkdirs();
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                while ((n = bufferedInputStream.read()) >= 0) {
                    ((BufferedOutputStream)filterOutputStream).write(n);
                }
                Object var6_6 = null;
                if (bufferedInputStream == null) break block19;
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            break block21;
            {
                catch (Exception exception3) {
                    Exception exception42222;
                    exception3.printStackTrace();
                    Object var6_7 = null;
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (Exception exception42222) {
                            exception42222.printStackTrace();
                        }
                    }
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (Exception exception42222) {
                            exception42222.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Exception exception52222;
                Object var6_8 = null;
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception52222) {
                        exception52222.printStackTrace();
                    }
                }
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception52222) {
                        exception52222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    public static String URLEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String URLMailEncode(String string) {
        return Utility.replaceAll(string, ' ', "%20");
    }

    public static String replaceAll(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == c) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String LPAD(String string, char c, int n) {
        int n2 = string.length();
        if (n > n2) {
            int n3 = 0;
            while (n3 < n - n2) {
                string = c + string;
                ++n3;
            }
        }
        return string;
    }
}

