/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.Functions;
import ij.macro.MacroConstants;
import ij.macro.Program;
import ij.macro.ReturnException;
import ij.macro.Symbol;
import ij.macro.Tokenizer;
import ij.macro.Variable;

public class Interpreter
implements MacroConstants {
    static final int MAX_ARGS = 20;
    Tokenizer tok;
    int pc;
    int token;
    int tokenAddress;
    double tokenValue;
    String tokenString;
    boolean looseSyntax = true;
    double darg1;
    double darg2;
    double darg3;
    double darg4;
    int lineNumber;
    boolean ignoreEOL = true;
    boolean statusUpdated;
    boolean showingProgress;
    static Interpreter instance;
    boolean done;
    Program pgm;
    Functions func;
    boolean inFunction;

    public void run(String string) {
        Tokenizer tokenizer = new Tokenizer();
        Program program = tokenizer.tokenize(string);
        this.run(program);
    }

    public void run(Program program) {
        this.pgm = program;
        this.pc = -1;
        instance = this;
        this.func = new Functions(this, program);
        IJ.showStatus("interpreting");
        if ((program.code[this.pc + 1] & 0xFF) == 200 && (program.code[this.pc + 2] & 0xFF) == 133) {
            this.getToken();
            this.getToken();
        }
        this.doStatements();
        this.func.updateDisplay();
        instance = null;
        if (!this.statusUpdated) {
            IJ.showStatus("");
        }
        if (this.showingProgress) {
            IJ.showProgress(1.0);
        }
    }

    public void runMacro(Program program, int n) {
        this.pgm = program;
        this.pc = n - 1;
        instance = this;
        IJ.showStatus("interpreting");
        this.func = new Functions(this, program);
        program.startOfLocals = 0;
        this.doBlock();
        this.func.updateDisplay();
        instance = null;
        if (!this.statusUpdated) {
            IJ.showStatus("");
        }
        if (this.showingProgress) {
            IJ.showProgress(1.0);
        }
    }

    public void pushGlobals(Program program) {
        this.pgm = program;
        this.pc = -1;
        instance = this;
        this.func = new Functions(this, program);
        while (!this.done) {
            this.getToken();
            switch (this.token) {
                case 201: {
                    this.doVar();
                    break;
                }
                case 200: {
                    this.skipMacro();
                    break;
                }
                case 207: {
                    this.skipFunction();
                    break;
                }
            }
        }
        instance = null;
        program.topOfGlobals = program.topOfStack;
    }

    /*
     * Unable to fully structure code
     */
    final void getToken() {
        if (this.done) {
            return;
        }
        this.token = this.pgm.code[++this.pc];
        if (this.token > 127) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.token = this.pgm.code[++this.pc];
lbl7:
            // 2 sources

            ** while (this.token == 132 && this.ignoreEOL)
        }
lbl8:
        // 1 sources

        this.tokenAddress = this.token >> 16;
        this.token &= 65535;
        var1_1 = this.pgm.table[this.tokenAddress];
        this.tokenString = var1_1.str;
        this.tokenValue = var1_1.value;
        this.done = this.token == 128;
    }

    final int nextToken() {
        return this.pgm.code[this.pc + 1] & 0xFFFF;
    }

    final void putTokenBack() {
        --this.pc;
        if (this.pc < 0) {
            this.pc = -1;
        }
    }

    void doStatements() {
        while (!this.done) {
            this.doStatement();
        }
    }

    final void doStatement() {
        this.getToken();
        switch (this.token) {
            case 201: {
                this.doVar();
                break;
            }
            case 134: {
                this.func.doFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 137: {
                this.runUserFunction();
                break;
            }
            case 208: {
                this.doReturn();
                break;
            }
            case 129: {
                this.doAssignment();
                break;
            }
            case 1: 
            case 40: {
                this.putTokenBack();
                this.getAssignmentExpression();
                break;
            }
            case 202: {
                this.doIf();
                return;
            }
            case 203: {
                this.error("Else without if");
                return;
            }
            case 206: {
                this.doFor();
                return;
            }
            case 204: {
                this.doWhile();
                return;
            }
            case 205: {
                this.doDo();
                return;
            }
            case 200: {
                this.skipMacro();
                return;
            }
            case 207: {
                this.skipFunction();
                return;
            }
            case 59: {
                return;
            }
            case 123: {
                this.putTokenBack();
                this.doBlock();
                return;
            }
            case 130: 
            case 133: 
            case 135: 
            case 136: {
                this.putTokenBack();
                IJ.log(this.getString());
                return;
            }
            case 128: {
                break;
            }
            default: {
                this.error("Statement cannot begin with '" + this.pgm.decodeToken(this.token, this.tokenAddress) + "'");
            }
        }
        if (!this.looseSyntax) {
            this.getToken();
            if (this.token != 59) {
                this.error("';' expected");
            }
        }
    }

    Variable runUserFunction() {
        int n = (int)this.tokenValue;
        int n2 = this.pgm.startOfLocals;
        this.pgm.startOfLocals = this.pgm.topOfStack + 1;
        int n3 = this.pgm.topOfStack;
        int n4 = this.pushArgs();
        int n5 = this.pc;
        Variable variable = null;
        this.pc = n;
        this.setupArgs(n4);
        boolean bl = this.inFunction;
        this.inFunction = true;
        try {
            this.doBlock();
        }
        catch (ReturnException returnException) {
            variable = new Variable(0, returnException.value, returnException.str);
        }
        this.inFunction = bl;
        this.pc = n5;
        this.pgm.trimStack(n3, n2);
        return variable;
    }

    int pushArgs() {
        this.getLeftParen();
        int n = 0;
        double[] dArray = new double[20];
        if (this.nextToken() != 41) {
            do {
                if (n == 20) {
                    this.error("Too many arguments");
                }
                dArray[n] = this.getExpression();
                ++n;
                this.getToken();
            } while (this.token == 44);
            this.putTokenBack();
        }
        int n2 = n;
        while (n > 0) {
            this.pgm.push(0, dArray[--n], null, this);
        }
        this.getRightParen();
        return n2;
    }

    void setupArgs(int n) {
        this.getLeftParen();
        int n2 = this.pgm.topOfStack;
        int n3 = n;
        if (this.nextToken() != 41) {
            do {
                this.getToken();
                if (n2 >= 0) {
                    this.pgm.stack[n2].symTabIndex = this.tokenAddress;
                }
                --n2;
                --n3;
                this.getToken();
            } while (this.token == 44);
            this.putTokenBack();
        }
        if (n3 != 0) {
            this.error(n + " argument" + (n == 1 ? "" : "s") + " expected");
        }
        this.getRightParen();
    }

    void doReturn() {
        if (this.inFunction) {
            double d = 0.0;
            String string = null;
            this.getToken();
            if (this.token != 59) {
                Variable variable;
                boolean bl;
                boolean bl2 = bl = this.token == 133 || this.token == 136;
                if (this.token == 129 && (variable = this.pgm.lookupVariable(this.tokenAddress)) != null) {
                    if (this.nextToken() == 59) {
                        throw new ReturnException(variable.getValue(), variable.getString());
                    }
                    bl = variable.getString() != null;
                }
                this.putTokenBack();
                if (bl) {
                    string = this.getString();
                } else {
                    d = this.getExpression();
                }
            }
            throw new ReturnException(d, string);
        }
        this.error("Return outside of function");
    }

    /*
     * Unable to fully structure code
     */
    void doFor() {
        var1_1 = this.looseSyntax;
        this.looseSyntax = false;
        this.getToken();
        if (this.token != 40) {
            this.error("'(' expected");
        }
        this.getToken();
        if (this.token != 201) {
            this.putTokenBack();
        }
        do {
            if (this.nextToken() != 59) {
                this.getAssignmentExpression();
            }
            this.getToken();
        } while (this.token == 44);
        if (this.token != 59) {
            this.error("';' expected");
        }
        var2_2 = this.pc;
        var4_3 = 0;
        var5_4 = 1.0;
        while (true) {
            block12: {
                if (this.pgm.code[this.pc + 1] != 59) {
                    var5_4 = this.getLogicalExpression();
                }
                if (var4_3 == 0) {
                    this.checkBoolean(var5_4);
                }
                this.getToken();
                if (this.token != 59) {
                    this.error("';' expected");
                }
                var7_5 = this.pc;
                if (var4_3 == 0) ** GOTO lbl35
                this.pc = var4_3;
                break block12;
lbl-1000:
                // 1 sources

                {
                    this.getToken();
                    if (this.token != 123 && this.token != 59 && this.token != 40 && !this.done) continue;
                    this.error("')' expected");
lbl35:
                    // 3 sources

                    ** while (this.token != 41)
                }
            }
            var4_3 = this.pc;
            if (var5_4 != 1.0) break;
            this.doStatement();
            this.pc = var7_5;
            do {
                if (this.nextToken() != 41) {
                    this.getAssignmentExpression();
                }
                this.getToken();
            } while (this.token == 44);
            this.pc = var2_2;
        }
        this.skipStatement();
        this.looseSyntax = var1_1;
    }

    void doWhile() {
        boolean bl;
        this.looseSyntax = false;
        int n = this.pc;
        do {
            this.pc = n;
            bl = this.getBoolean();
            if (bl) {
                this.doStatement();
                continue;
            }
            this.skipStatement();
        } while (bl && !this.done);
    }

    void doDo() {
        boolean bl;
        this.looseSyntax = false;
        int n = this.pc;
        do {
            this.doStatement();
            this.getToken();
            if (this.token != 204) {
                this.error("'while' expected");
            }
            if (!(bl = this.getBoolean())) continue;
            this.pc = n;
        } while (bl && !this.done);
    }

    final void doBlock() {
        this.getToken();
        if (this.token != 123) {
            this.error("'{' expected");
        }
        while (!this.done) {
            this.getToken();
            if (this.token == 125) break;
            this.putTokenBack();
            this.doStatement();
        }
        if (this.token != 125) {
            this.error("'}' expected");
        }
    }

    final void skipStatement() {
        this.getToken();
        switch (this.token) {
            case 1: 
            case 40: 
            case 129: 
            case 134: 
            case 137: 
            case 201: 
            case 208: {
                this.skipSimpleStatement();
                break;
            }
            case 202: {
                this.skipParens();
                this.skipStatement();
                this.getToken();
                if (this.token == 203) {
                    this.skipStatement();
                    break;
                }
                this.putTokenBack();
                break;
            }
            case 206: {
                this.skipParens();
                this.skipStatement();
                break;
            }
            case 204: {
                this.skipParens();
                this.skipStatement();
                break;
            }
            case 205: {
                this.skipStatement();
                this.getToken();
                this.skipParens();
                break;
            }
            case 59: {
                break;
            }
            case 123: {
                this.putTokenBack();
                this.skipBlock();
                break;
            }
            default: {
                this.error("Skipped statement cannot begin with '" + this.pgm.decodeToken(this.token, this.tokenAddress) + "'");
            }
        }
    }

    final void skipBlock() {
        int n = 0;
        do {
            this.getToken();
            if (this.token == 123) {
                ++n;
                continue;
            }
            if (this.token == 125) {
                --n;
                continue;
            }
            if (!this.done) continue;
            this.error("'}' expected");
            return;
        } while (n > 0);
    }

    final void skipParens() {
        int n = 0;
        do {
            this.getToken();
            if (this.token == 40) {
                ++n;
                continue;
            }
            if (this.token == 41) {
                --n;
                continue;
            }
            if (!this.done) continue;
            this.error("')' expected");
            return;
        } while (n > 0);
    }

    final void skipSimpleStatement() {
        boolean bl = this.done;
        this.getToken();
        while (!bl && !this.done) {
            if (this.token == 59) {
                bl = true;
                continue;
            }
            this.getToken();
        }
    }

    void skipFunction() {
        this.getToken();
        this.skipParens();
        this.skipBlock();
    }

    void skipMacro() {
        this.getToken();
        this.skipBlock();
    }

    final void doAssignment() {
        int n = this.pgm.code[this.pc + 2] & 0xFF;
        if (n == 133 || n == 136) {
            this.doStringAssignment();
        } else {
            this.putTokenBack();
            this.getAssignmentExpression();
        }
    }

    final void doStringAssignment() {
        Variable variable = this.pgm.lookupVariable(this.tokenAddress);
        if (variable == null) {
            if (this.nextToken() == 61) {
                variable = this.pgm.push(this.tokenAddress, 0.0, null, this);
            } else {
                this.error("Undefined identifier");
            }
        }
        this.getToken();
        if (this.token != 61) {
            this.error("'=' expected");
            return;
        }
        variable.setString(this.getString());
    }

    final void doIf() {
        this.looseSyntax = false;
        boolean bl = this.getBoolean();
        if (bl) {
            this.doStatement();
        } else {
            this.skipStatement();
        }
        this.getToken();
        if (this.token == 203) {
            if (bl) {
                this.skipStatement();
            } else {
                this.doStatement();
            }
        } else {
            this.putTokenBack();
        }
    }

    final boolean getBoolean() {
        this.getLeftParen();
        double d = this.getLogicalExpression();
        this.checkBoolean(d);
        this.getRightParen();
        return d != 0.0;
    }

    final double getLogicalExpression() {
        double d = this.getBooleanExpression();
        int n = this.nextToken();
        if (n != 13 && n != 14) {
            return d;
        }
        this.checkBoolean(d);
        this.getToken();
        int n2 = this.token;
        double d2 = this.getBooleanExpression();
        this.checkBoolean(d2);
        if (n2 == 13) {
            return (int)d & (int)d2;
        }
        if (n2 == 14) {
            return (int)d | (int)d2;
        }
        return d;
    }

    final double getBooleanExpression() {
        double d = this.getExpression();
        int n = this.nextToken();
        if (n >= 3 && n <= 8) {
            this.getToken();
            int n2 = this.token;
            double d2 = this.getExpression();
            switch (n2) {
                case 3: {
                    d = d == d2 ? 1.0 : 0.0;
                    break;
                }
                case 4: {
                    d = d != d2 ? 1.0 : 0.0;
                    break;
                }
                case 5: {
                    d = d > d2 ? 1.0 : 0.0;
                    break;
                }
                case 6: {
                    d = d >= d2 ? 1.0 : 0.0;
                    break;
                }
                case 7: {
                    d = d < d2 ? 1.0 : 0.0;
                    break;
                }
                case 8: {
                    d = d <= d2 ? 1.0 : 0.0;
                }
            }
        }
        return d;
    }

    final double getAssignmentExpression() {
        int n = this.pgm.code[this.pc + 2];
        if ((this.pgm.code[this.pc + 1] & 0xFF) == 129 && (n == 61 || n == 9 || n == 10 || n == 11 || n == 12)) {
            this.getToken();
            Variable variable = this.pgm.lookupVariable(this.tokenAddress);
            if (variable == null) {
                variable = this.pgm.push(this.tokenAddress, 0.0, null, this);
            }
            this.getToken();
            double d = 0.0;
            if (this.token == 61) {
                d = this.getAssignmentExpression();
            } else {
                d = variable.getValue();
                switch (this.token) {
                    case 9: {
                        d += this.getAssignmentExpression();
                        break;
                    }
                    case 10: {
                        d -= this.getAssignmentExpression();
                        break;
                    }
                    case 11: {
                        d *= this.getAssignmentExpression();
                        break;
                    }
                    case 12: {
                        d /= this.getAssignmentExpression();
                    }
                }
            }
            variable.setValue(d);
            return d;
        }
        return this.getLogicalExpression();
    }

    final void checkBoolean(double d) {
        if (d != 0.0 && d != 1.0) {
            this.error("Boolean expression expected");
        }
    }

    void doVar() {
        this.getToken();
        while (this.token == 129) {
            if (this.nextToken() == 61) {
                this.doAssignment();
            } else {
                Variable variable = this.pgm.lookupVariable(this.tokenAddress);
                if (variable == null) {
                    this.pgm.push(this.tokenAddress, 0.0, null, this);
                }
            }
            this.getToken();
            if (this.token == 44) {
                this.getToken();
                continue;
            }
            this.putTokenBack();
            break;
        }
    }

    final void getLeftParen() {
        this.getToken();
        if (this.token != 40) {
            this.error("'(' expected");
        }
    }

    final void getRightParen() {
        this.getToken();
        if (this.token != 41) {
            this.error("')' expected");
        }
    }

    final void getParens() {
        this.getLeftParen();
        this.getRightParen();
    }

    final void getComma() {
        this.getToken();
        if (this.token != 44) {
            if (this.looseSyntax) {
                this.putTokenBack();
            } else {
                this.error("',' expected");
            }
        }
    }

    void error(String string) {
        boolean bl = !this.done;
        this.token = 128;
        this.tokenString = "";
        IJ.showStatus("");
        if (bl) {
            String string2 = this.getErrorLine();
            IJ.showMessage("Macro Error", string + " in line " + this.lineNumber + ".\n \n" + string2);
            throw new RuntimeException("Macro canceled");
        }
        this.done = true;
    }

    String getErrorLine() {
        int n = this.pc;
        this.lineNumber = 1;
        this.ignoreEOL = false;
        this.pc = -1;
        int n2 = -1;
        while (this.pc < n) {
            this.getToken();
            if (this.token != 132) continue;
            ++this.lineNumber;
            n2 = this.pc;
        }
        String string = "";
        this.pc = n2;
        this.getToken();
        while (this.token != 132 && !this.done) {
            String string2 = this.pgm.decodeToken(this.token, this.tokenAddress);
            if (this.pc == n) {
                string2 = "<" + string2 + ">";
            }
            string = string + string2 + " ";
            this.getToken();
        }
        return string;
    }

    final String getString() {
        String string = this.getStringTerm();
        while (true) {
            this.getToken();
            if (this.token != 43) break;
            string = string + this.getStringTerm();
        }
        this.putTokenBack();
        return string;
    }

    final String getStringTerm() {
        String string;
        this.getToken();
        switch (this.token) {
            case 133: {
                string = this.tokenString;
                break;
            }
            case 136: {
                string = this.func.getStringFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 137: {
                Variable variable = this.runUserFunction();
                if (variable == null) {
                    this.error("No return value");
                }
                if ((string = variable.getString()) != null) break;
                double d = variable.getValue();
                if ((double)((int)d) == d) {
                    string = IJ.d2s(d, 0);
                    break;
                }
                string = "" + d;
                break;
            }
            case 129: {
                string = this.lookupStringVariable();
                if (string != null) break;
            }
            default: {
                this.putTokenBack();
                double d = this.getStringExpression();
                if ((double)((int)d) == d) {
                    string = IJ.d2s(d, 0);
                    break;
                }
                string = "" + d;
                if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d == Double.NaN || string.length() - string.indexOf(46) <= 6 || string.indexOf(69) != -1) break;
                string = IJ.d2s(d, 4);
            }
        }
        return string;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.tokenAddress];
        return symbol.type == 2000;
    }

    final double getExpression() {
        double d = this.getTerm();
        while (true) {
            int n;
            if ((n = this.nextToken()) == 43) {
                this.getToken();
                d += this.getTerm();
                continue;
            }
            if (n != 45) break;
            this.getToken();
            d -= this.getTerm();
        }
        return d;
    }

    final double getTerm() {
        double d = this.getFactor();
        boolean bl = false;
        while (!bl) {
            int n = this.nextToken();
            switch (n) {
                case 42: {
                    this.getToken();
                    d *= this.getFactor();
                    break;
                }
                case 47: {
                    this.getToken();
                    d /= this.getFactor();
                    break;
                }
                case 37: {
                    this.getToken();
                    d %= this.getFactor();
                    break;
                }
                case 38: {
                    this.getToken();
                    d = (int)d & (int)this.getFactor();
                    break;
                }
                case 124: {
                    this.getToken();
                    d = (int)d | (int)this.getFactor();
                    break;
                }
                case 94: {
                    this.getToken();
                    d = (int)d ^ (int)this.getFactor();
                    break;
                }
                case 15: {
                    this.getToken();
                    d = (int)d >> (int)this.getFactor();
                    break;
                }
                case 16: {
                    this.getToken();
                    d = (int)d << (int)this.getFactor();
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        return d;
    }

    final double getFactor() {
        double d = 0.0;
        Variable variable = null;
        this.getToken();
        switch (this.token) {
            case 130: {
                d = this.tokenValue;
                break;
            }
            case 135: {
                d = this.func.getFunctionValue(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 137: {
                variable = this.runUserFunction();
                if (variable == null) {
                    this.error("No return value");
                }
                if (variable.getString() != null) {
                    this.error("Numeric return value expected");
                    break;
                }
                d = variable.getValue();
                break;
            }
            case 213: {
                d = 1.0;
                break;
            }
            case 214: {
                d = 0.0;
                break;
            }
            case 215: {
                d = Math.PI;
                break;
            }
            case 129: {
                variable = this.lookupNumericVariable();
                if (variable == null) {
                    return 0.0;
                }
                d = variable.getValue();
                int n = this.nextToken();
                if (n != 1 && n != 2) break;
                this.getToken();
                if (this.token == 1) {
                    variable.setValue(variable.getValue() + 1.0);
                    break;
                }
                variable.setValue(variable.getValue() - 1.0);
                break;
            }
            case 40: {
                d = this.getLogicalExpression();
                this.getRightParen();
                break;
            }
            case 1: {
                d = this.getFactor();
                d += 1.0;
                break;
            }
            case 2: {
                d = this.getFactor();
                d -= 1.0;
                break;
            }
            case 33: {
                d = this.getFactor();
                if (d == 0.0 || d == 1.0) {
                    d = d == 0.0 ? 1.0 : 0.0;
                    break;
                }
                this.error("Boolean expected");
                break;
            }
            case 45: {
                d = -this.getFactor();
                break;
            }
            case 126: {
                d = ~((int)this.getFactor());
                break;
            }
            default: {
                this.error("Number or numeric function expected");
            }
        }
        return d;
    }

    final double getStringExpression() {
        double d;
        block3: {
            d = this.getTerm();
            while (true) {
                this.getToken();
                if (this.token == 43) {
                    this.getToken();
                    if (this.token == 133 || this.token == 136) {
                        this.putTokenBack();
                        this.putTokenBack();
                        break block3;
                    }
                    this.putTokenBack();
                    d += this.getTerm();
                    continue;
                }
                if (this.token != 45) break;
                d -= this.getTerm();
            }
            this.putTokenBack();
        }
        return d;
    }

    final Variable lookupNumericVariable() {
        Variable variable = null;
        if (this.pgm.stack == null) {
            this.undefined();
            return variable;
        }
        boolean bl = false;
        int n = this.pgm.topOfStack;
        while (n >= 0) {
            if (this.pgm.stack[n].symTabIndex == this.tokenAddress) {
                bl = true;
                variable = this.pgm.stack[n];
                break;
            }
            --n;
        }
        if (!bl) {
            this.undefined();
        }
        return variable;
    }

    final String lookupStringVariable() {
        if (this.pgm.stack == null) {
            this.undefined();
            return "";
        }
        boolean bl = false;
        String string = null;
        int n = this.pgm.topOfStack;
        while (n >= 0) {
            if (this.pgm.stack[n].symTabIndex == this.tokenAddress) {
                bl = true;
                string = this.pgm.stack[n].getString();
                break;
            }
            --n;
        }
        if (!bl) {
            this.undefined();
        }
        return string;
    }

    void undefined() {
        if (this.nextToken() == 40) {
            this.error("Undefined identifier");
        } else {
            this.error("Undefined variable");
        }
    }

    void dump() {
        this.getParens();
        if (!this.done) {
            this.pgm.dumpSymbolTable();
            this.pgm.dumpProgram();
            this.dumpStack();
        }
    }

    void dumpStack() {
        IJ.log("");
        IJ.log("Stack");
        if (this.pgm.stack != null) {
            int n = this.pgm.topOfStack;
            while (n >= 0) {
                IJ.log(n + " " + this.pgm.stack[n] + " " + this.pgm.table[this.pgm.stack[n].symTabIndex].str);
                --n;
            }
        }
    }

    public static void abort() {
        if (instance != null) {
            Interpreter.instance.done = true;
            IJ.beep();
            IJ.showStatus("Macro aborted");
        }
    }
}

