/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;

public class ResultsTable {
    public static final int MAX_COLUMNS = 50;
    public static final int COLUMN_NOT_FOUND = -1;
    public static final int COLUMN_IN_USE = -2;
    public static final int TABLE_FULL = -3;
    public static final int AREA = 0;
    public static final int MEAN = 1;
    public static final int STD_DEV = 2;
    public static final int MODE = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int X_CENTROID = 6;
    public static final int Y_CENTROID = 7;
    public static final int X_CENTER_OF_MASS = 8;
    public static final int Y_CENTER_OF_MASS = 9;
    public static final int PERIMETER = 10;
    public static final int ROI_X = 11;
    public static final int ROI_Y = 12;
    public static final int ROI_WIDTH = 13;
    public static final int ROI_HEIGHT = 14;
    public static final int MAJOR = 15;
    public static final int MINOR = 16;
    public static final int ANGLE = 17;
    public static final int CIRCULARITY = 18;
    public static final int FERET = 19;
    private String[] headings = new String[50];
    private String[] defaultHeadings = new String[]{"Area", "Mean", "StdDev", "Mode", "Min", "Max", "X", "Y", "XM", "YM", "Perim.", "BX", "BY", "Width", "Height", "Major", "Minor", "Angle", "Circ.", "Feret"};
    private int counter;
    private float[][] columns = new float[50][];
    private String[] rowLabels;
    private int maxRows = 100;
    private int lastColumn = -1;
    private StringBuffer sb;
    private int precision = 3;
    private String rowLabelHeading = "";

    public ResultsTable() {
        int n = 0;
        while (n < this.defaultHeadings.length) {
            this.headings[n] = this.defaultHeadings[n];
            ++n;
        }
    }

    public synchronized void incrementCounter() {
        ++this.counter;
        if (this.counter == this.maxRows) {
            if (this.rowLabels != null) {
                String[] stringArray = new String[this.maxRows * 2];
                System.arraycopy(this.rowLabels, 0, stringArray, 0, this.maxRows);
                this.rowLabels = stringArray;
            }
            int n = 0;
            while (n < 50) {
                if (this.columns[n] != null) {
                    float[] fArray = new float[this.maxRows * 2];
                    System.arraycopy(this.columns[n], 0, fArray, 0, this.maxRows);
                    this.columns[n] = fArray;
                }
                ++n;
            }
            this.maxRows *= 2;
        }
    }

    public int getCounter() {
        return this.counter;
    }

    public void addValue(int n, double d) {
        if (n < 0 || n >= 50) {
            throw new IllegalArgumentException("Index out of range: " + n);
        }
        if (this.counter == 0) {
            throw new IllegalArgumentException("Counter==0");
        }
        if (this.columns[n] == null) {
            this.columns[n] = new float[this.maxRows];
            if (this.headings[n] == null) {
                this.headings[n] = "---";
            }
            if (n > this.lastColumn) {
                this.lastColumn = n;
            }
        }
        this.columns[n][this.counter - 1] = (float)d;
    }

    public void addValue(String string, double d) {
        int n = this.getColumnIndex(string);
        if (n == -1 && (n = this.getFreeColumn(string)) == -3) {
            throw new IllegalArgumentException("table is full");
        }
        this.addValue(n, d);
    }

    public void addLabel(String string, String string2) {
        if (this.counter == 0) {
            throw new IllegalArgumentException("Counter==0");
        }
        if (this.rowLabels == null) {
            this.rowLabels = new String[this.maxRows];
        }
        this.rowLabels[this.counter - 1] = string2;
        if (string != null) {
            this.rowLabelHeading = string;
        }
    }

    public void disableRowLabels() {
        this.rowLabels = null;
    }

    public float[] getColumn(int n) {
        if (n < 0 || n >= 50) {
            throw new IllegalArgumentException("Index out of range: " + n);
        }
        if (this.columns[n] == null) {
            return null;
        }
        float[] fArray = new float[this.counter];
        int n2 = 0;
        while (n2 < this.counter) {
            fArray[n2] = this.columns[n][n2];
            ++n2;
        }
        return fArray;
    }

    public int getColumnIndex(String string) {
        int n = 0;
        while (n < this.headings.length) {
            if (this.headings[n] == null) {
                return -1;
            }
            if (this.headings[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getFreeColumn(String string) {
        int n = 0;
        while (n < this.headings.length) {
            if (this.headings[n] == null) {
                this.columns[n] = new float[this.maxRows];
                this.headings[n] = string;
                if (n > this.lastColumn) {
                    this.lastColumn = n;
                }
                return n;
            }
            if (this.headings[n].equals(string)) {
                return -2;
            }
            ++n;
        }
        return -3;
    }

    public float getValue(int n, int n2) {
        if (this.columns[n] == null) {
            throw new IllegalArgumentException("Column not defined: " + n);
        }
        if (n >= 50 || n2 >= this.counter) {
            throw new IllegalArgumentException("Index out of range: " + n + "," + n2);
        }
        return this.columns[n][n2];
    }

    public void setValue(int n, int n2, double d) {
        if (n < 0 || n >= 50) {
            throw new IllegalArgumentException("Column out of range: " + n);
        }
        if (n2 >= this.counter) {
            throw new IllegalArgumentException("row>=counter");
        }
        if (this.columns[n] == null) {
            this.columns[n] = new float[this.maxRows];
            if (n > this.lastColumn) {
                this.lastColumn = n;
            }
        }
        this.columns[n][n2] = (float)d;
    }

    public String getColumnHeadings() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(" \t");
        if (this.rowLabels != null) {
            stringBuffer.append(this.rowLabelHeading + "\t");
        }
        int n = 0;
        while (n <= this.lastColumn) {
            if (this.columns[n] != null) {
                String string = this.headings[n];
                if (string == null) {
                    string = "---";
                }
                stringBuffer.append(string + "\t");
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public String getColumnHeading(int n) {
        if (n < 0 || n >= 50) {
            throw new IllegalArgumentException("Index out of range: " + n);
        }
        return this.headings[n];
    }

    public String getRowAsString(int n) {
        if (n < 0 || n >= this.counter) {
            throw new IllegalArgumentException("Row out of range: " + n);
        }
        if (this.sb == null) {
            this.sb = new StringBuffer(200);
        } else {
            this.sb.setLength(0);
        }
        this.sb.append(Integer.toString(n + 1));
        this.sb.append("\t");
        if (this.rowLabels != null) {
            if (this.rowLabels[n] != null) {
                this.sb.append(this.rowLabels[n]);
            }
            this.sb.append("\t");
        }
        int n2 = 0;
        while (n2 <= this.lastColumn) {
            if (this.columns[n2] != null) {
                this.sb.append(this.n(this.columns[n2][n]));
            }
            ++n2;
        }
        return new String(this.sb);
    }

    public void setHeading(int n, String string) {
        if (n < 0 || n >= this.headings.length) {
            throw new IllegalArgumentException("Column out of range: " + n);
        }
        this.headings[n] = string;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    String n(double d) {
        String string = (double)Math.round(d) == d ? IJ.d2s(d, 0) : IJ.d2s(d, this.precision);
        return string + "\t";
    }

    public synchronized void reset() {
        this.counter = 0;
        this.maxRows = 100;
        int n = 0;
        while (n <= this.lastColumn) {
            this.columns[n] = null;
            if (n < this.defaultHeadings.length) {
                this.headings[n] = this.defaultHeadings[n];
            }
            ++n;
        }
        this.lastColumn = -1;
    }

    public String toString() {
        return "ctr=" + this.counter + ", hdr=" + this.getColumnHeadings();
    }
}

