/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.FolderOpenerDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;

public class FolderOpener
implements PlugIn {
    private static boolean grayscale;
    private static boolean halfSize;
    private int n;
    private int start;
    private int increment;
    private String filter;
    static /* synthetic */ Class class$ij$plugin$FolderOpener;

    public void run(String string) {
        OpenDialog openDialog = new OpenDialog("Image Sequence...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return;
        }
        String[] stringArray = new File(string2).list();
        if (stringArray == null) {
            return;
        }
        IJ.register(class$ij$plugin$FolderOpener == null ? (class$ij$plugin$FolderOpener = FolderOpener.class$("ij.plugin.FolderOpener")) : class$ij$plugin$FolderOpener);
        StringSorter.sort(stringArray);
        if (IJ.debugMode) {
            IJ.log("FolderOpener: " + string2 + " (" + stringArray.length + " files)");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ImageStack imageStack = null;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        try {
            int n4;
            int n5 = 0;
            while (n5 < stringArray.length) {
                ImagePlus imagePlus;
                if (!stringArray[n5].endsWith(".txt") && (imagePlus = new Opener().openImage(string2, stringArray[n5])) != null) {
                    n = imagePlus.getWidth();
                    n2 = imagePlus.getHeight();
                    n3 = imagePlus.getType();
                    if (this.showDialog(imagePlus, stringArray)) break;
                    return;
                }
                ++n5;
            }
            if (this.n < 1) {
                this.n = stringArray.length;
            }
            if (this.start < 1 || this.start > stringArray.length) {
                this.start = 1;
            }
            if (this.start + this.n - 1 > stringArray.length) {
                this.n = stringArray.length - this.start + 1;
            }
            int n6 = this.n;
            if (this.filter.equals("") || this.filter.equals("*")) {
                this.filter = null;
            }
            if (this.filter != null) {
                n6 = 0;
                n4 = this.start - 1;
                while (n4 < this.start - 1 + this.n) {
                    if (stringArray[n4].indexOf(this.filter) >= 0) {
                        ++n6;
                    }
                    ++n4;
                }
                if (n6 == 0) {
                    IJ.error("None of the " + this.n + " files contain\n the string '" + this.filter + "' in their name.");
                    return;
                }
            }
            this.n = n6;
            n4 = 0;
            int n7 = 0;
            int n8 = this.start - 1;
            while (n8 < stringArray.length) {
                if (!(stringArray[n8].endsWith(".txt") || this.filter != null && stringArray[n8].indexOf(this.filter) < 0 || n7++ % this.increment != 0)) {
                    Object object;
                    ImagePlus imagePlus = new Opener().openImage(string2, stringArray[n8]);
                    if (imagePlus != null && imageStack == null) {
                        n = imagePlus.getWidth();
                        n2 = imagePlus.getHeight();
                        n3 = imagePlus.getType();
                        object = imagePlus.getProcessor().getColorModel();
                        imageStack = halfSize ? new ImageStack(n / 2, n2 / 2, (ColorModel)object) : new ImageStack(n, n2, (ColorModel)object);
                    }
                    if (imagePlus == null) {
                        IJ.log(stringArray[n8] + ": unable to open");
                    } else if (imagePlus.getWidth() != n || imagePlus.getHeight() != n2) {
                        IJ.log(stringArray[n8] + ": wrong dimensions");
                    } else if (imagePlus.getType() != n3) {
                        IJ.log(stringArray[n8] + ": wrong type");
                    } else {
                        n4 = imageStack.getSize() + 1;
                        IJ.showStatus(n4 + "/" + this.n);
                        IJ.showProgress((double)n4 / (double)this.n);
                        object = imagePlus.getProcessor();
                        if (grayscale) {
                            if (this.nonStandardLut((ImageProcessor)object)) {
                                object = new ColorProcessor(imagePlus.getImage());
                            }
                            object = ((ImageProcessor)object).convertToByte(true);
                        }
                        if (halfSize) {
                            object = ((ImageProcessor)object).resize(n / 2, n2 / 2);
                        }
                        if (((ImageProcessor)object).getMin() < d) {
                            d = ((ImageProcessor)object).getMin();
                        }
                        if (((ImageProcessor)object).getMax() > d2) {
                            d2 = ((ImageProcessor)object).getMax();
                        }
                        imageStack.addSlice(imagePlus.getTitle(), (ImageProcessor)object);
                    }
                    if (n4 >= this.n) break;
                }
                ++n8;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("FolderOpener");
            imageStack.trim();
        }
        if (imageStack != null && imageStack.getSize() > 0) {
            ImagePlus imagePlus = new ImagePlus("Stack", imageStack);
            if (imagePlus.getType() == 1 || imagePlus.getType() == 2) {
                imagePlus.getProcessor().setMinAndMax(d, d2);
            }
            imagePlus.show();
        }
        IJ.showProgress(1.0);
    }

    boolean nonStandardLut(ImageProcessor imageProcessor) {
        ColorModel colorModel = imageProcessor.getColorModel();
        if (!(colorModel instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        int n = indexColorModel.getMapSize();
        if (n != 256) {
            return true;
        }
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        boolean bl = true;
        int n2 = (byArray[1] & 0xFF) - (byArray[0] & 0xFF);
        int n3 = 0;
        while (n3 < 256) {
            if (byArray[n3] != byArray2[n3] || byArray2[n3] != byArray3[n3]) {
                bl = false;
                break;
            }
            if (n3 > 0 && (byArray[n3] & 0xFF) - (byArray[n3 - 1] & 0xFF) != n2) {
                bl = false;
                break;
            }
            ++n3;
        }
        return !bl;
    }

    boolean showDialog(ImagePlus imagePlus, String[] stringArray) {
        int n = stringArray.length;
        FolderOpenerDialog folderOpenerDialog = new FolderOpenerDialog("Sequence Options", imagePlus, stringArray);
        folderOpenerDialog.addNumericField("Number of Images: ", n, 0);
        folderOpenerDialog.addNumericField("Starting Image: ", 1.0, 0);
        folderOpenerDialog.addNumericField("Increment: ", 1.0, 0);
        folderOpenerDialog.addStringField("File Name Contains: ", "");
        folderOpenerDialog.addCheckbox("Convert to 8-bit Grayscale", grayscale);
        folderOpenerDialog.addCheckbox("Open 1/2 Size", halfSize);
        folderOpenerDialog.addMessage("10000 x 10000 x 1000 (100.3MB)");
        folderOpenerDialog.showDialog();
        if (folderOpenerDialog.wasCanceled()) {
            return false;
        }
        this.n = (int)folderOpenerDialog.getNextNumber();
        this.start = (int)folderOpenerDialog.getNextNumber();
        this.increment = (int)folderOpenerDialog.getNextNumber();
        if (this.increment < 1) {
            this.increment = 1;
        }
        this.filter = folderOpenerDialog.getNextString();
        grayscale = folderOpenerDialog.getNextBoolean();
        halfSize = folderOpenerDialog.getNextBoolean();
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

