/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Font;

public class Benchmark
implements PlugInFilter {
    String arg;
    ImagePlus imp;
    boolean showUpdates;
    int counter;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        if (string.equals("show")) {
            this.showBenchmarkResults();
            return 4096;
        }
        if (string.equals("jvm")) {
            this.showJVMComparison();
            return 4096;
        }
        if (string.equals("particles")) {
            this.showParticlesResults();
            return 4096;
        }
        this.arg = string;
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        Thread.currentThread().setPriority(1);
        if (this.arg.equals("draw")) {
            ImageWindow imageWindow = this.imp.getWindow();
            imageWindow.running = true;
            int n = 200;
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < n) {
                this.imp.draw();
                Thread.yield();
                if (n2 % 5 == 0) {
                    IJ.showProgress((double)n2 / (double)n);
                }
                if (!imageWindow.running) {
                    IJ.showProgress(1.0);
                    return;
                }
                ++n2;
            }
            IJ.showProgress(1.0);
            int n3 = this.imp.getWidth() * this.imp.getHeight() * n;
            long l2 = System.currentTimeMillis() - l;
            double d = (double)l2 / 1000.0;
            IJ.write(IJ.d2s((double)n3 / d / 1000000.0) + " million pixels per second");
            return;
        }
        this.showUpdates = !this.arg.equals("no-updates");
        imageProcessor.setInterpolate(false);
        int n = 0;
        while (n < 4) {
            imageProcessor.invert();
            this.updateScreen(this.imp);
            ++n;
        }
        int n4 = 0;
        while (n4 < 4) {
            imageProcessor.flipVertical();
            this.updateScreen(this.imp);
            ++n4;
        }
        imageProcessor.flipHorizontal();
        this.updateScreen(this.imp);
        imageProcessor.flipHorizontal();
        this.updateScreen(this.imp);
        int n5 = 0;
        while (n5 < 6) {
            imageProcessor.smooth();
            this.updateScreen(this.imp);
            ++n5;
        }
        imageProcessor.reset();
        int n6 = 0;
        while (n6 < 6) {
            imageProcessor.sharpen();
            this.updateScreen(this.imp);
            ++n6;
        }
        imageProcessor.reset();
        imageProcessor.smooth();
        this.updateScreen(this.imp);
        imageProcessor.findEdges();
        this.updateScreen(this.imp);
        imageProcessor.invert();
        this.updateScreen(this.imp);
        imageProcessor.autoThreshold();
        this.updateScreen(this.imp);
        imageProcessor.reset();
        imageProcessor.medianFilter();
        this.updateScreen(this.imp);
        int n7 = 0;
        while (n7 < 360) {
            imageProcessor.reset();
            imageProcessor.rotate(n7);
            this.updateScreen(this.imp);
            n7 += 15;
        }
        double d = 1.5;
        int n8 = 0;
        while (n8 < 8) {
            imageProcessor.reset();
            imageProcessor.scale(d, d);
            this.updateScreen(this.imp);
            d *= 1.5;
            ++n8;
        }
        int n9 = 0;
        while (n9 < 12) {
            imageProcessor.reset();
            imageProcessor.scale(d /= 1.5, d);
            this.updateScreen(this.imp);
            ++n9;
        }
        imageProcessor.reset();
        this.updateScreen(this.imp);
    }

    void updateScreen(ImagePlus imagePlus) {
        if (this.showUpdates) {
            imagePlus.updateAndDraw();
        }
        IJ.showStatus(this.counter++ + "/" + 72);
    }

    void showBenchmarkResults() {
        TextWindow textWindow = new TextWindow("ImageJ Benchmark", "", 450, 450);
        textWindow.setFont(new Font("Monospaced", 0, 12));
        textWindow.append("Time in seconds needed to perform 62 image processing");
        textWindow.append("operations on the 512x512 \"Mandrill\" image");
        textWindow.append("---------------------------------------------------------");
        textWindow.append(" 2.7   Xeon/1.7 (2X), WinXP  IE 6.0");
        textWindow.append(" 3.3   Pentium 4/1.4, Win2K  IE 5.0");
        textWindow.append(" 5.3   Pentium 3/750, Win98  IE 5.0");
        textWindow.append(" 5.6   Pentium 4/1.4, Win2K  JDK 1.3");
        textWindow.append(" 6.0   Pentium 3/750, Win98  Netscape 4.7");
        textWindow.append(" 8.6   PPC G4/400, MacOS     MRJ 2.2");
        textWindow.append(" 9.8   Pentium 2/400, Linux  IBM JDK 1.1.8");
        textWindow.append("  11   Pentium 2/400, Win95  JRE 1.1.8");
        textWindow.append("  12   Pentium 2/400, Win95  IE 5.5");
        textWindow.append("  12   Pentium 2/400, Win95  JDK 1.3");
        textWindow.append("  13   Pentium 2/400, Win95  Netscape 4.5");
        textWindow.append("  14   PPC G3/300, MacOS     MRJ 2.1");
        textWindow.append("  38   PPC 604/132, MacOS    MRJ 2.1ea2");
        textWindow.append("  61   PPC 604/132, MacOS    MRJ 2.0");
        textWindow.append("  89   Pentium/100, Win95    JRE 1.1.6");
        textWindow.append("  96   Pentium/400, Linux    Sun JDK 1.2.2 (17 with JIT)");
        textWindow.append("");
    }

    void showJVMComparison() {
        TextWindow textWindow = new TextWindow("JVM Comparison", "", 500, 550);
        textWindow.setFont(new Font("Monospaced", 0, 12));
        textWindow.append("   JVM           Benchmark  No Updates  Waves(fps) Particles");
        textWindow.append("");
        textWindow.append("PC (JRE 1.1.8)     11.5        8.7         16         44");
        textWindow.append("PC (MS Java)       12.3        9.6         19         38");
        textWindow.append("PC (JDK 1.4rc)     12.6       10.8         21         34");
        textWindow.append("PC (JDK 1.3)       13.2       11.8         20         34");
        textWindow.append("Mac OS 8/9)         8.7        6.4         19         35");
        textWindow.append("Mac OS X           11.0        9.0         18         44");
        textWindow.append("Linux (IBM 1.1.8)  10.8        8.8         15         46");
        textWindow.append("Linux (Sun 1.3.1)  13.2       11.5         17         13!");
        textWindow.append("");
        textWindow.append("'Benchmark' is the time needed to perform 72 image processing");
        textWindow.append("operations on a 512x512 RGB image with the screen updated");
        textWindow.append("after each operation. Lower is better.");
        textWindow.append("");
        textWindow.append("'No Updates' is the time needed to perform 72 image processing");
        textWindow.append("operations with no screen updates. Lower is better.");
        textWindow.append("");
        textWindow.append("'Waves' is the animation rate in frames per second using");
        textWindow.append("a 512x512 RGB image. Higher is better.");
        textWindow.append("");
        textWindow.append("'Particles' is the time needed to measure the location and");
        textWindow.append("size of 5097 particles in a 2000x1000 binary image. Lower");
        textWindow.append("is better.");
        textWindow.append("");
        textWindow.append("Test were run on 400Mhz machines. The Linux machine has 2 CPUs.");
    }

    void showParticlesResults() {
        TextWindow textWindow = new TextWindow("Particles Benchmark", "", 450, 500);
        textWindow.setFont(new Font("Monospaced", 0, 12));
        textWindow.append("These are times in seconds needed to measure the size");
        textWindow.append("and location of 5097 objects in a 2000x1000 binary image.");
        textWindow.append("Tests were run on 400Mhz Pentiums and a 400Mhz G3 Mac.");
        textWindow.append("");
        textWindow.append("24  Netscape 4.5");
        textWindow.append("24  Internet Explorer 4.0");
        textWindow.append("28  JDK 1.3");
        textWindow.append("30  JDK 1.2");
        textWindow.append("33  JDK 1.1.8");
        textWindow.append("35  MacOS Runtime for Java 2.2");
        textWindow.append("60  Sun JDK 1.2.2 for Linux");
        textWindow.append("70  IBM JDK 1.1.8 for Linux");
        textWindow.append("");
        textWindow.append("To run the benchmark:");
        textWindow.append("");
        textWindow.append("1) Open the test image using File/Open Samples/Particles.");
        textWindow.append("2) Check \"Area\" and \"Centroid\" in Analalyze/Set Measurements.");
        textWindow.append("3) Select Analyze/Analyze Particles.");
        textWindow.append("3) Check \"Display Results\" and then click \"OK\".");
    }
}

