/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class ImageMath
implements PlugInFilter {
    private String arg;
    private ImagePlus imp;
    private boolean canceled;
    private boolean first;
    private static double addValue = 25.0;
    private static double mulValue = 1.25;
    private static double minValue = 0.0;
    private static double maxValue = 255.0;
    private static final String defaultAndValue = "11110000";
    private static String andValue = "11110000";
    private static final double defaultGammaValue = 0.5;
    private static double gammaValue = 0.5;
    static /* synthetic */ Class class$ij$plugin$filter$ImageMath;

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        this.imp = imagePlus;
        this.first = true;
        IJ.register(class$ij$plugin$filter$ImageMath == null ? (class$ij$plugin$filter$ImageMath = ImageMath.class$("ij.plugin.filter.ImageMath")) : class$ij$plugin$filter$ImageMath);
        return IJ.setupDialog(imagePlus, 95);
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        if (this.arg.equals("add")) {
            if (this.first) {
                addValue = this.getValue("Add", "Value: ", addValue, 0);
            }
            if (this.canceled) {
                return;
            }
            imageProcessor.add(addValue);
            return;
        }
        if (this.arg.equals("sub")) {
            if (this.first) {
                addValue = this.getValue("Subtract", "Value: ", addValue, 0);
            }
            if (this.canceled) {
                return;
            }
            imageProcessor.add(-addValue);
            return;
        }
        if (this.arg.equals("mul")) {
            if (this.first) {
                mulValue = this.getValue("Multiply", "Value: ", mulValue, 2);
            }
            if (this.canceled) {
                return;
            }
            imageProcessor.multiply(mulValue);
            return;
        }
        if (this.arg.equals("div")) {
            if (this.first) {
                mulValue = this.getValue("Divide", "Value: ", mulValue, 2);
            }
            if (this.canceled) {
                return;
            }
            if (mulValue != 0.0) {
                imageProcessor.multiply(1.0 / mulValue);
            }
            return;
        }
        if (this.arg.equals("and")) {
            if (this.first) {
                andValue = this.getBinaryValue("AND", "Value (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                imageProcessor.and(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException numberFormatException) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("or")) {
            if (this.first) {
                andValue = this.getBinaryValue("OR", "Value (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                imageProcessor.or(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException numberFormatException) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("xor")) {
            if (this.first) {
                andValue = this.getBinaryValue("XOR", "Value (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                imageProcessor.xor(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException numberFormatException) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("min")) {
            if (this.first) {
                minValue = this.getValue("Min", "Value: ", minValue, 0);
            }
            if (this.canceled) {
                return;
            }
            imageProcessor.min(minValue);
            if (!(imageProcessor instanceof ByteProcessor)) {
                imageProcessor.resetMinAndMax();
            }
            return;
        }
        if (this.arg.equals("max")) {
            if (this.first) {
                maxValue = this.getValue("Max", "Value: ", maxValue, 0);
            }
            if (this.canceled) {
                return;
            }
            imageProcessor.max(maxValue);
            if (!(imageProcessor instanceof ByteProcessor)) {
                imageProcessor.resetMinAndMax();
            }
            return;
        }
        if (this.arg.equals("gamma")) {
            if (this.first) {
                gammaValue = this.getValue("Gamma", "Value (0.1-5.0): ", gammaValue, 2);
            }
            if (this.canceled) {
                return;
            }
            if (gammaValue < 0.1 || gammaValue > 5.0) {
                IJ.error("Gamma must be between 0.1 and 5.0");
                gammaValue = 0.5;
                return;
            }
            imageProcessor.gamma(gammaValue);
            return;
        }
        if (this.arg.equals("log")) {
            imageProcessor.log();
            return;
        }
        if (this.arg.equals("sqr")) {
            imageProcessor.sqr();
            return;
        }
        if (this.arg.equals("sqrt")) {
            imageProcessor.sqrt();
            return;
        }
        if (this.arg.equals("reciprocal")) {
            if (!(imageProcessor instanceof FloatProcessor)) {
                IJ.error("32-bit float image required");
                this.canceled = true;
                return;
            }
            float[] fArray = (float[])imageProcessor.getPixels();
            int n = 0;
            while (n < imageProcessor.getWidth() * imageProcessor.getHeight()) {
                fArray[n] = fArray[n] == 0.0f ? Float.NaN : 1.0f / fArray[n];
                ++n;
            }
            if (!(imageProcessor instanceof ByteProcessor)) {
                imageProcessor.resetMinAndMax();
            }
            return;
        }
    }

    double getValue(String string, String string2, double d, int n) {
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addNumericField(string2, d, n);
        genericDialog.showDialog();
        if (this.first) {
            this.imp.startTiming();
        }
        this.first = false;
        this.canceled = genericDialog.wasCanceled();
        if (this.canceled) {
            return d;
        }
        return genericDialog.getNextNumber();
    }

    String getBinaryValue(String string, String string2, String string3) {
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addStringField(string2, string3);
        genericDialog.showDialog();
        if (this.first) {
            this.imp.startTiming();
        }
        this.first = false;
        this.canceled = genericDialog.wasCanceled();
        if (this.canceled) {
            return string3;
        }
        return genericDialog.getNextString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

