/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;

public class RankFilters
implements PlugInFilter {
    public static final int MEDIAN = 0;
    public static final int MEAN = 1;
    public static final int MIN = 2;
    public static final int MAX = 3;
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    ImagePlus imp;
    int filterType = 0;
    String title;
    int kw;
    int kh;
    int slice;
    boolean canceled;
    ImageWindow win;
    private static final String[] typeStrings = new String[]{"Median", "Mean", "Minimum", "Maximum"};
    boolean isLineRoi;
    static double radius = 2.0;
    static /* synthetic */ Class class$ij$plugin$filter$RankFilters;

    public int setup(String string, ImagePlus imagePlus) {
        IJ.register(class$ij$plugin$filter$RankFilters == null ? (class$ij$plugin$filter$RankFilters = RankFilters.class$("ij.plugin.filter.RankFilters")) : class$ij$plugin$filter$RankFilters);
        this.imp = imagePlus;
        if (string.equals("min")) {
            this.filterType = 2;
        } else if (string.equals("max")) {
            this.filterType = 3;
        } else if (string.equals("mean")) {
            this.filterType = 1;
        }
        this.slice = 0;
        this.canceled = false;
        if (imagePlus != null) {
            this.win = imagePlus.getWindow();
            this.win.running = true;
            Roi roi = imagePlus.getRoi();
            this.isLineRoi = roi != null && roi.getType() >= 5;
        }
        this.title = typeStrings[this.filterType];
        IJ.showStatus(this.title + ", radius=" + radius + " (esc to abort)");
        if (imagePlus != null && !this.showDialog()) {
            return 4096;
        }
        return IJ.setupDialog(imagePlus, 31);
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (!this.win.running) {
            this.canceled = true;
            IJ.beep();
            return;
        }
        if (this.isLineRoi) {
            imageProcessor.resetRoi();
        }
        this.rank(imageProcessor, radius, this.filterType);
        if (this.slice > 1) {
            IJ.showStatus(this.title + ": " + this.slice + "/" + this.imp.getStackSize());
        }
        if (this.slice == this.imp.getStackSize()) {
            imageProcessor.resetMinAndMax();
        }
    }

    void showMasks() {
        int n = 150;
        int n2 = 150;
        ImageStack imageStack = new ImageStack(n, n2);
        double d = 0.5;
        while (d < 50.0) {
            int n3 = (int)(d + 0.5) * 2 + 1;
            int[] nArray = this.createCircularMask(n3, d);
            FloatProcessor floatProcessor = new FloatProcessor(n, n2, new int[n * n2]);
            floatProcessor.insert(new FloatProcessor(n3, n3, nArray), n / 2 - n3 / 2, n2 / 2 - n3 / 2);
            imageStack.addSlice("radius=" + d + ", size=" + n3, floatProcessor);
            d += 0.5;
        }
        new ImagePlus("Masks", imageStack).show();
    }

    int getType(ImageProcessor imageProcessor) {
        int n = imageProcessor instanceof ByteProcessor ? 0 : (imageProcessor instanceof ShortProcessor ? 1 : (imageProcessor instanceof FloatProcessor ? 2 : 3));
        return n;
    }

    public void convertBack(ImageProcessor imageProcessor, ImageProcessor imageProcessor2, int n) {
        switch (n) {
            case 0: {
                imageProcessor = imageProcessor.convertToByte(false);
                byte[] byArray = (byte[])imageProcessor2.getPixels();
                byte[] byArray2 = (byte[])imageProcessor.getPixels();
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                break;
            }
            case 1: {
                imageProcessor = imageProcessor.convertToShort(false);
                short[] sArray = (short[])imageProcessor2.getPixels();
                short[] sArray2 = (short[])imageProcessor.getPixels();
                System.arraycopy(sArray2, 0, sArray, 0, sArray.length);
                break;
            }
        }
    }

    boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog(this.title + "...");
        genericDialog.addNumericField("Radius (pixels):", radius, 1);
        genericDialog.addCheckbox("Show Circular Masks", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            this.canceled = true;
            return false;
        }
        radius = genericDialog.getNextNumber();
        boolean bl = genericDialog.getNextBoolean();
        if (bl) {
            this.showMasks();
            return false;
        }
        if (radius < 0.5) {
            radius = 0.5;
        }
        this.imp.startTiming();
        return true;
    }

    public void rank(ImageProcessor imageProcessor, double d, int n) {
        int n2 = this.getType(imageProcessor);
        if (n2 == 3) {
            this.rankRGB(imageProcessor, d, n);
            return;
        }
        imageProcessor.setCalibrationTable(null);
        ImageProcessor imageProcessor2 = imageProcessor.convertToFloat();
        imageProcessor2.setRoi(imageProcessor.getRoi());
        imageProcessor2.setMask(imageProcessor.getMask());
        this.rankFloat(imageProcessor2, d, n);
        this.convertBack(imageProcessor2, imageProcessor, n2);
    }

    public void rankRGB(ImageProcessor imageProcessor, double d, int n) {
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        Rectangle rectangle = imageProcessor.getRoi();
        int[] nArray = imageProcessor.getMask();
        int n4 = n2 * n3;
        if (this.slice == 1) {
            IJ.showStatus(this.title + " (red)");
        }
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        ((ColorProcessor)imageProcessor).getRGB(byArray, byArray2, byArray3);
        ByteProcessor byteProcessor = new ByteProcessor(n2, n3, byArray, null);
        ByteProcessor byteProcessor2 = new ByteProcessor(n2, n3, byArray2, null);
        ByteProcessor byteProcessor3 = new ByteProcessor(n2, n3, byArray3, null);
        ImageProcessor imageProcessor2 = byteProcessor.convertToFloat();
        imageProcessor2.setRoi(rectangle);
        imageProcessor2.setMask(nArray);
        this.rankFloat(imageProcessor2, d, n);
        if (this.canceled) {
            return;
        }
        ImageProcessor imageProcessor3 = imageProcessor2.convertToByte(false);
        if (this.slice == 1) {
            IJ.showStatus(this.title + " (green)");
        }
        imageProcessor2 = byteProcessor2.convertToFloat();
        imageProcessor2.setRoi(rectangle);
        imageProcessor2.setMask(nArray);
        this.rankFloat(imageProcessor2, d, n);
        if (this.canceled) {
            return;
        }
        ImageProcessor imageProcessor4 = imageProcessor2.convertToByte(false);
        if (this.slice == 1) {
            IJ.showStatus(this.title + " (blue)");
        }
        imageProcessor2 = byteProcessor3.convertToFloat();
        imageProcessor2.setRoi(rectangle);
        imageProcessor2.setMask(nArray);
        this.rankFloat(imageProcessor2, d, n);
        if (this.canceled) {
            return;
        }
        ImageProcessor imageProcessor5 = imageProcessor2.convertToByte(false);
        ((ColorProcessor)imageProcessor).setRGB((byte[])imageProcessor3.getPixels(), (byte[])imageProcessor4.getPixels(), (byte[])imageProcessor5.getPixels());
    }

    public void rankFloat(ImageProcessor imageProcessor, double d, int n) {
        int n2;
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        Rectangle rectangle = imageProcessor.getRoi();
        boolean bl = rectangle.width != n3 || rectangle.height != n4;
        boolean bl2 = bl && imageProcessor.getMask() != null;
        int n5 = 0;
        int n6 = 0;
        int n7 = n3 - 1;
        int n8 = n4 - 1;
        if (bl) {
            n5 = rectangle.x;
            n6 = rectangle.y;
            n7 = n5 + rectangle.width - 1;
            n8 = n6 + rectangle.height - 1;
            if (bl2) {
                imageProcessor.snapshot();
            }
        }
        int n9 = n2 = (int)(d + 0.5) * 2 + 1;
        int[] nArray = this.createCircularMask(n2, d);
        int n10 = 0;
        int n11 = 0;
        while (n11 < n2 * n2) {
            if (nArray[n11] != 0) {
                ++n10;
            }
            ++n11;
        }
        float[] fArray = new float[n10];
        int n12 = n2 / 2;
        int n13 = n9 / 2;
        float[] fArray2 = (float[])imageProcessor.getPixels();
        float[] fArray3 = (float[])imageProcessor.getPixelsCopy();
        int n14 = Math.max((n8 - n6) / 50, 1);
        int n15 = n3 - n12;
        int n16 = n4 - n13;
        int n17 = n6;
        while (n17 <= n8) {
            if (n17 % n14 == 0) {
                IJ.showProgress((double)n17 / (double)n4);
                boolean bl3 = this.canceled = this.win != null && !this.win.running;
                if (this.canceled) break;
            }
            int n18 = n5;
            while (n18 <= n7) {
                double d2 = 0.0;
                int n19 = 0;
                int n20 = 0;
                boolean bl4 = n17 < n13 || n17 >= n16 || n18 < n12 || n18 >= n15;
                int n21 = -n13;
                while (n21 <= n13) {
                    int n22 = n18 + (n17 + n21) * n3;
                    int n23 = -n12;
                    while (n23 <= n12) {
                        if (nArray[n19++] != 0) {
                            fArray[n20] = bl4 ? this.getPixel(n18 + n23, n17 + n21, fArray3, n3, n4) : fArray3[n22 + n23];
                            ++n20;
                        }
                        ++n23;
                    }
                    ++n21;
                }
                fArray2[n18 + n17 * n3] = n == 0 ? this.findMedian(fArray) : (n == 1 ? this.findMean(fArray) : (n == 2 ? this.findMin(fArray) : this.findMax(fArray)));
                ++n18;
            }
            ++n17;
        }
        if (bl2) {
            imageProcessor.reset(imageProcessor.getMask());
        }
        IJ.showProgress(1.0);
        if (this.canceled) {
            imageProcessor.insert(new FloatProcessor(n3, n4, fArray3, null), 0, 0);
            IJ.beep();
        }
    }

    private float getPixel(int n, int n2, float[] fArray, int n3, int n4) {
        if (n <= 0) {
            n = 0;
        }
        if (n >= n3) {
            n = n3 - 1;
        }
        if (n2 <= 0) {
            n2 = 0;
        }
        if (n2 >= n4) {
            n2 = n4 - 1;
        }
        return fArray[n + n2 * n3];
    }

    int[] createCircularMask(int n, double d) {
        int[] nArray = new int[n * n];
        int n2 = n / 2;
        int n3 = (int)(d * d) + 1;
        int n4 = -n2;
        while (n4 <= n2) {
            int n5 = -n2;
            while (n5 <= n2) {
                if (n4 * n4 + n5 * n5 <= n3) {
                    nArray[n2 + n4 + (n2 + n5) * n] = 1;
                }
                ++n5;
            }
            ++n4;
        }
        return nArray;
    }

    private final float findMedian(float[] fArray) {
        int n = fArray.length;
        int n2 = (n - 1) / 2;
        int n3 = 0;
        int n4 = n - 1;
        float f = fArray[n2];
        while (n3 < n4) {
            int n5 = n3;
            int n6 = n4;
            while (true) {
                if (fArray[n5] < f) {
                    ++n5;
                    continue;
                }
                while (f < fArray[n6]) {
                    --n6;
                }
                float f2 = fArray[n6];
                fArray[n6] = fArray[n5];
                fArray[n5] = f2;
                if (--n6 < n2 || ++n5 > n2) break;
            }
            if (n6 < n2) {
                n3 = n5;
            }
            if (n2 < n5) {
                n4 = n6;
            }
            f = fArray[n2];
        }
        return f;
    }

    private final float findMin(float[] fArray) {
        float f = fArray[0];
        int n = 1;
        while (n < fArray.length) {
            if (fArray[n] < f) {
                f = fArray[n];
            }
            ++n;
        }
        return f;
    }

    private final float findMax(float[] fArray) {
        float f = fArray[0];
        int n = 1;
        while (n < fArray.length) {
            if (fArray[n] > f) {
                f = fArray[n];
            }
            ++n;
        }
        return f;
    }

    private final float findMean(float[] fArray) {
        float f = fArray[0];
        int n = 1;
        while (n < fArray.length) {
            f += fArray[n];
            ++n;
        }
        return f / (float)fArray.length;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

