/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.TrimmedButton;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.plugin.frame.ContrastPlot;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.TrimmedLabel;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackProcessor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class ContrastAdjuster
extends PlugInFrame
implements Runnable,
ActionListener,
AdjustmentListener,
ItemListener {
    static final int AUTO_THRESHOLD = 5000;
    static final String[] channelLabels = new String[]{"Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "RGB"};
    static final int[] channelConstants = new int[]{4, 2, 1, 3, 5, 6, 7};
    ContrastPlot plot = new ContrastPlot();
    Thread thread;
    private static Frame instance;
    int minSliderValue = -1;
    int maxSliderValue = -1;
    int brightnessValue = -1;
    int contrastValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doSet;
    boolean doApplyLut;
    boolean doThreshold;
    boolean doUpdate;
    Panel panel;
    Panel tPanel;
    Button autoB;
    Button resetB;
    Button setB;
    Button applyB;
    Button threshB;
    Button updateB;
    int previousImageID;
    int previousType;
    Object previousSnapshot;
    ImageJ ij;
    double min;
    double max;
    double previousMin;
    double previousMax;
    double defaultMin;
    double defaultMax;
    int contrast;
    int brightness;
    boolean RGBImage;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Scrollbar contrastSlider;
    Scrollbar brightnessSlider;
    Label minLabel;
    Label maxLabel;
    Label windowLabel;
    Label levelLabel;
    boolean done;
    int autoThreshold;
    GridBagLayout gridbag;
    GridBagConstraints c;
    int y = 0;
    boolean windowLevel;
    boolean balance;
    Font monoFont = new Font("Monospaced", 0, 12);
    Font sanFont = new Font("SansSerif", 0, 12);
    int channels = 7;
    Choice choice;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int SET = 2;
    static final int APPLY = 3;
    static final int THRESHOLD = 4;
    static final int MIN = 5;
    static final int MAX = 6;
    static final int BRIGHTNESS = 7;
    static final int CONTRAST = 8;
    static final int UPDATE = 9;
    static /* synthetic */ Class class$ij$plugin$frame$ContrastAdjuster;

    public ContrastAdjuster() {
        super("B&C");
    }

    public void run(String string) {
        int n;
        this.windowLevel = string.equals("wl");
        this.balance = string.equals("balance");
        if (this.windowLevel) {
            this.setTitle("W&L");
        } else if (this.balance) {
            this.setTitle("Color");
            this.channels = 4;
        }
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        IJ.register(class$ij$plugin$frame$ContrastAdjuster == null ? (class$ij$plugin$frame$ContrastAdjuster = ContrastAdjuster.class$("ij.plugin.frame.ContrastAdjuster")) : class$ij$plugin$frame$ContrastAdjuster);
        WindowManager.addWindow(this);
        this.ij = IJ.getInstance();
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.gridbag);
        this.c.gridx = 0;
        this.y = 0;
        this.c.gridy = this.y++;
        this.c.fill = 1;
        this.c.anchor = 10;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.gridbag.setConstraints(this.plot, this.c);
        this.add(this.plot);
        if (!this.windowLevel) {
            this.panel = new Panel();
            this.c.gridy = this.y++;
            this.c.insets = new Insets(0, 10, 0, 10);
            this.gridbag.setConstraints(this.panel, this.c);
            this.panel.setLayout(new BorderLayout());
            this.minLabel = new Label("      ", 0);
            this.minLabel.setFont(this.monoFont);
            this.panel.add("West", this.minLabel);
            this.maxLabel = new Label("      ", 2);
            this.maxLabel.setFont(this.monoFont);
            this.panel.add("East", this.maxLabel);
            this.add(this.panel);
        }
        if (!this.windowLevel) {
            this.minSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.minSlider, this.c);
            this.add(this.minSlider);
            this.minSlider.addAdjustmentListener(this);
            this.minSlider.setUnitIncrement(1);
            this.addLabel("Minimum", null);
        }
        if (!this.windowLevel) {
            this.maxSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.maxSlider, this.c);
            this.add(this.maxSlider);
            this.maxSlider.addAdjustmentListener(this);
            this.maxSlider.setUnitIncrement(1);
            this.addLabel("Maximum", null);
        }
        this.brightnessSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        this.c.gridy = this.y++;
        this.c.insets = new Insets(this.windowLevel ? 12 : 2, 10, 0, 10);
        this.gridbag.setConstraints(this.brightnessSlider, this.c);
        this.add(this.brightnessSlider);
        this.brightnessSlider.addAdjustmentListener(this);
        this.brightnessSlider.setUnitIncrement(1);
        if (this.windowLevel) {
            this.levelLabel = new TrimmedLabel("        ");
            this.addLabel("Level: ", this.levelLabel);
        } else {
            this.addLabel("Brightness", null);
        }
        if (!this.balance) {
            this.contrastSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.contrastSlider, this.c);
            this.add(this.contrastSlider);
            this.contrastSlider.addAdjustmentListener(this);
            this.contrastSlider.setUnitIncrement(1);
            if (this.windowLevel) {
                this.windowLabel = new TrimmedLabel("        ");
                this.addLabel("Window: ", this.windowLabel);
            } else {
                this.addLabel("Contrast", null);
            }
        }
        if (this.balance) {
            this.c.gridy = this.y++;
            this.c.insets = new Insets(5, 10, 0, 10);
            this.choice = new Choice();
            n = 0;
            while (n < channelLabels.length) {
                this.choice.addItem(channelLabels[n]);
                ++n;
            }
            this.gridbag.setConstraints(this.choice, this.c);
            this.choice.addItemListener(this);
            this.add(this.choice);
        }
        n = IJ.isMacOSX() ? 20 : 0;
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(0, 2, 0, 0));
        this.autoB = new TrimmedButton("Auto", n);
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.resetB = new TrimmedButton("Reset", n);
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.setB = new TrimmedButton("Set", n);
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        this.applyB = new TrimmedButton("Apply", n);
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        if (!this.windowLevel && !this.balance) {
            this.threshB = new TrimmedButton("Thresh", n);
            this.threshB.addActionListener(this);
            this.threshB.addKeyListener(this.ij);
            this.panel.add(this.threshB);
            this.updateB = new TrimmedButton("Update", n);
            this.updateB.addActionListener(this);
            this.updateB.addKeyListener(this.ij);
            this.panel.add(this.updateB);
        }
        this.c.gridy = this.y++;
        this.c.insets = new Insets(8, 5, 10, 5);
        this.gridbag.setConstraints(this.panel, this.c);
        this.add(this.panel);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        this.show();
        this.thread = new Thread((Runnable)this, "ContrastAdjuster");
        this.thread.start();
        this.setup();
    }

    void addLabel(String string, Label label) {
        this.panel = new Panel();
        this.c.gridy = this.y++;
        this.c.insets = new Insets(0, 10, 0, 0);
        this.gridbag.setConstraints(this.panel, this.c);
        this.panel.setLayout(new FlowLayout(label == null ? 1 : 0, 0, 0));
        TrimmedLabel trimmedLabel = new TrimmedLabel(string);
        trimmedLabel.setFont(this.sanFont);
        this.panel.add(trimmedLabel);
        if (label != null) {
            label.setFont(this.monoFont);
            label.setAlignment(0);
            this.panel.add(label);
        }
        this.add(this.panel);
    }

    void setup() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            this.setup(imagePlus);
            this.updatePlot();
            this.updateLabels(imagePlus, imageProcessor);
            imagePlus.updateAndDraw();
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.minSlider) {
            this.minSliderValue = this.minSlider.getValue();
        } else if (adjustmentEvent.getSource() == this.maxSlider) {
            this.maxSliderValue = this.maxSlider.getValue();
        } else if (adjustmentEvent.getSource() == this.contrastSlider) {
            this.contrastValue = this.contrastSlider.getValue();
        } else {
            this.brightnessValue = this.brightnessSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == null) {
            return;
        }
        if (button == this.resetB) {
            this.doReset = true;
        } else if (button == this.autoB) {
            this.doAutoAdjust = true;
        } else if (button == this.setB) {
            this.doSet = true;
        } else if (button == this.applyB) {
            this.doApplyLut = true;
        } else if (button == this.threshB) {
            this.doThreshold = true;
        } else if (button == this.updateB) {
            this.doUpdate = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imagePlus) {
        boolean bl;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n = imagePlus.getType();
        this.RGBImage = n == 4;
        boolean bl2 = bl = this.RGBImage && this.previousSnapshot != null && ((ColorProcessor)imageProcessor).getSnapshotPixels() != this.previousSnapshot;
        if (imagePlus.getID() != this.previousImageID || bl || n != this.previousType) {
            this.setupNewImage(imagePlus, imageProcessor);
        }
        this.previousImageID = imagePlus.getID();
        this.previousType = n;
        return imageProcessor;
    }

    void setupNewImage(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.previousMin = this.min;
        this.previousMax = this.max;
        if (this.RGBImage) {
            imageProcessor.snapshot();
            this.previousSnapshot = ((ColorProcessor)imageProcessor).getSnapshotPixels();
        } else {
            this.previousSnapshot = null;
        }
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        if (imagePlus.getType() == 4) {
            d = 0.0;
            d2 = 255.0;
        }
        if (imageProcessor instanceof ShortProcessor || imageProcessor instanceof FloatProcessor) {
            imageProcessor.resetMinAndMax();
            this.defaultMin = imageProcessor.getMin();
            this.defaultMax = imageProcessor.getMax();
        } else {
            this.defaultMin = 0.0;
            this.defaultMax = 255.0;
        }
        this.setMinAndMax(imageProcessor, d, d2);
        this.min = imageProcessor.getMin();
        this.max = imageProcessor.getMax();
        if (IJ.debugMode) {
            IJ.log("min: " + this.min);
            IJ.log("max: " + this.max);
            IJ.log("defaultMin: " + this.defaultMin);
            IJ.log("defaultMax: " + this.defaultMax);
        }
        this.plot.defaultMin = this.defaultMin;
        this.plot.defaultMax = this.defaultMax;
        this.updateScrollBars(null);
        if (!this.doReset) {
            this.plotHistogram(imagePlus);
        }
        this.autoThreshold = 0;
    }

    void setMinAndMax(ImageProcessor imageProcessor, double d, double d2) {
        if (this.channels != 7 && imageProcessor instanceof ColorProcessor) {
            ((ColorProcessor)imageProcessor).setMinAndMax(d, d2, this.channels);
        } else {
            imageProcessor.setMinAndMax(d, d2);
        }
    }

    void updatePlot() {
        this.plot.min = this.min;
        this.plot.max = this.max;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int n;
        boolean bl;
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        int n2 = imagePlus.getType();
        Calibration calibration = imagePlus.getCalibration();
        boolean bl2 = bl = n2 == 2;
        if (calibration.calibrated()) {
            d = calibration.getCValue((int)d);
            d2 = calibration.getCValue((int)d2);
            if (n2 != 1) {
                bl = true;
            }
        }
        int n3 = n = bl ? 2 : 0;
        if (this.windowLevel) {
            double d3 = d2 - d;
            double d4 = d + d3 / 2.0;
            this.windowLabel.setText(IJ.d2s(d3, n));
            this.levelLabel.setText(IJ.d2s(d4, n));
        } else {
            this.minLabel.setText(IJ.d2s(d, n));
            this.maxLabel.setText(IJ.d2s(d2, n));
        }
    }

    void updateScrollBars(Scrollbar scrollbar) {
        double d;
        double d2;
        if (scrollbar == null || scrollbar != this.contrastSlider) {
            d2 = this.sliderRange / 2;
            d = (this.defaultMax - this.defaultMin) / (this.max - this.min) * d2;
            if (d > d2) {
                d = (double)this.sliderRange - (this.max - this.min) / (this.defaultMax - this.defaultMin) * d2;
            }
            this.contrast = (int)d;
            if (this.contrastSlider != null) {
                this.contrastSlider.setValue(this.contrast);
            }
        }
        if (scrollbar == null || scrollbar != this.brightnessSlider) {
            d2 = this.min + (this.max - this.min) / 2.0;
            d = 1.0 - (d2 - this.defaultMin) / (this.defaultMax - this.defaultMin);
            this.brightness = (int)(d * (double)this.sliderRange);
            this.brightnessSlider.setValue(this.brightness);
        }
        if (this.minSlider != null && (scrollbar == null || scrollbar != this.minSlider)) {
            this.minSlider.setValue(this.scaleDown(this.min));
        }
        if (this.maxSlider != null && (scrollbar == null || scrollbar != this.maxSlider)) {
            this.maxSlider.setValue(this.scaleDown(this.max));
        }
    }

    int scaleDown(double d) {
        if (d < this.defaultMin) {
            d = this.defaultMin;
        }
        if (d > this.defaultMax) {
            d = this.defaultMax;
        }
        return (int)((d - this.defaultMin) * 255.0 / (this.defaultMax - this.defaultMin));
    }

    void doMasking(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int[] nArray = imagePlus.getMask();
        if (nArray != null) {
            imageProcessor.reset(nArray);
        }
    }

    void adjustMin(ImagePlus imagePlus, ImageProcessor imageProcessor, double d) {
        this.min = this.defaultMin + d * (this.defaultMax - this.defaultMin) / 255.0;
        if (this.max > this.defaultMax) {
            this.max = this.defaultMax;
        }
        if (this.min > this.max) {
            this.max = this.min;
        }
        this.setMinAndMax(imageProcessor, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(imageProcessor);
        }
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
        this.updateScrollBars(this.minSlider);
    }

    void adjustMax(ImagePlus imagePlus, ImageProcessor imageProcessor, double d) {
        this.max = this.defaultMin + d * (this.defaultMax - this.defaultMin) / 255.0;
        if (this.min < 0.0) {
            this.min = 0.0;
        }
        if (this.max < this.min) {
            this.min = this.max;
        }
        this.setMinAndMax(imageProcessor, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(imageProcessor);
        }
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
        this.updateScrollBars(this.maxSlider);
    }

    void adjustBrightness(ImagePlus imagePlus, ImageProcessor imageProcessor, double d) {
        double d2 = this.defaultMin + (this.defaultMax - this.defaultMin) * (((double)this.sliderRange - d) / (double)this.sliderRange);
        double d3 = this.max - this.min;
        this.min = d2 - d3 / 2.0;
        this.max = d2 + d3 / 2.0;
        this.setMinAndMax(imageProcessor, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(imageProcessor);
        }
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
        this.updateScrollBars(this.brightnessSlider);
    }

    void adjustContrast(ImagePlus imagePlus, ImageProcessor imageProcessor, int n) {
        double d = this.min + (this.max - this.min) / 2.0;
        double d2 = this.defaultMax - this.defaultMin;
        double d3 = this.sliderRange / 2;
        double d4 = (double)n <= d3 ? (double)n / d3 : d3 / (double)(this.sliderRange - n);
        if (d4 > 0.0) {
            this.min = d - 0.5 * d2 / d4;
            this.max = d + 0.5 * d2 / d4;
        }
        this.setMinAndMax(imageProcessor, this.min, this.max);
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
        this.updateScrollBars(this.contrastSlider);
    }

    void reset(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (this.RGBImage) {
            imageProcessor.reset();
        }
        if (imageProcessor instanceof ShortProcessor || imageProcessor instanceof FloatProcessor) {
            imageProcessor.resetMinAndMax();
            this.defaultMin = imageProcessor.getMin();
            this.defaultMax = imageProcessor.getMax();
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
        }
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        this.setMinAndMax(imageProcessor, this.min, this.max);
        this.updateScrollBars(null);
        this.plotHistogram(imagePlus);
        this.autoThreshold = 0;
        if (Recorder.record) {
            Recorder.record("resetMinAndMax");
        }
    }

    void update(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (this.previousMin == 0.0 && this.previousMax == 0.0 || imagePlus.getType() != this.previousType) {
            IJ.beep();
        } else {
            this.min = this.previousMin;
            this.max = this.previousMax;
            this.setMinAndMax(imageProcessor, this.min, this.max);
            this.updateScrollBars(null);
            this.plotHistogram(imagePlus);
        }
    }

    void plotHistogram(ImagePlus imagePlus) {
        ImageStatistics imageStatistics;
        if (this.balance && (this.channels == 4 || this.channels == 2 || this.channels == 1) && imagePlus.getType() == 4) {
            int n = imagePlus.getWidth();
            int n2 = imagePlus.getHeight();
            byte[] byArray = new byte[n * n2];
            byte[] byArray2 = new byte[n * n2];
            byte[] byArray3 = new byte[n * n2];
            ((ColorProcessor)imagePlus.getProcessor()).getRGB(byArray, byArray2, byArray3);
            byte[] byArray4 = null;
            if (this.channels == 4) {
                byArray4 = byArray;
            } else if (this.channels == 2) {
                byArray4 = byArray2;
            } else if (this.channels == 1) {
                byArray4 = byArray3;
            }
            ByteProcessor byteProcessor = new ByteProcessor(n, n2, byArray4, null);
            imageStatistics = ImageStatistics.getStatistics(byteProcessor, 0, imagePlus.getCalibration());
        } else {
            imageStatistics = imagePlus.getStatistics();
        }
        this.plot.setHistogram(imageStatistics);
    }

    void apply(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (this.RGBImage) {
            imagePlus.unlock();
        }
        if (!imagePlus.lock()) {
            return;
        }
        if (imagePlus.getType() == 4) {
            if (imagePlus.getStackSize() > 1) {
                this.applyRGBStack(imagePlus);
            } else {
                imageProcessor.snapshot();
                this.reset(imagePlus, imageProcessor);
                imagePlus.changes = true;
            }
            imagePlus.unlock();
            return;
        }
        if (imagePlus.getType() != 0) {
            IJ.beep();
            IJ.showStatus("Apply requires an 8-bit grayscale image or an RGB stack");
            imagePlus.unlock();
            return;
        }
        int[] nArray = new int[256];
        int n = (int)imageProcessor.getMin();
        int n2 = (int)imageProcessor.getMax();
        int n3 = 0;
        while (n3 < 256) {
            nArray[n3] = n3 <= n ? 0 : (n3 >= n2 ? 255 : (int)((double)(n3 - n) / (double)(n2 - n) * 255.0));
            ++n3;
        }
        if (imagePlus.getStackSize() > 1) {
            ImageStack imageStack = imagePlus.getStack();
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)this, "Entire Stack?", "Apply LUT to all " + imageStack.getSize() + " slices in the stack?");
            if (yesNoCancelDialog.cancelPressed()) {
                imagePlus.unlock();
                return;
            }
            if (yesNoCancelDialog.yesPressed()) {
                new StackProcessor(imageStack, imageProcessor).applyTable(nArray);
            } else {
                imageProcessor.applyTable(nArray);
            }
        } else {
            imageProcessor.applyTable(nArray);
        }
        this.reset(imagePlus, imageProcessor);
        imagePlus.changes = true;
        imagePlus.unlock();
    }

    void applyRGBStack(ImagePlus imagePlus) {
        int n = imagePlus.getCurrentSlice();
        int n2 = imagePlus.getStackSize();
        if (!IJ.showMessageWithCancel("Update Entire Stack?", "Apply brightness and contrast settings\nto all " + n2 + " slices in the stack?\n \n" + "NOTE: There is no Undo for this operation.")) {
            return;
        }
        int n3 = 1;
        while (n3 <= n2) {
            if (n3 != n) {
                imagePlus.setSlice(n3);
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                this.setMinAndMax(imageProcessor, this.min, this.max);
                IJ.showProgress((double)n3 / (double)n2);
            }
            ++n3;
        }
        imagePlus.setSlice(n);
        imagePlus.changes = true;
    }

    void threshold(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int n = (int)((this.defaultMax - this.defaultMin) / 2.0);
        this.min = n;
        this.max = n;
        this.setMinAndMax(imageProcessor, this.min, this.max);
        this.setThreshold(imageProcessor);
        this.updateScrollBars(null);
    }

    void setThreshold(ImageProcessor imageProcessor) {
        if (!(imageProcessor instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)imageProcessor).isInvertedLut()) {
            imageProcessor.setThreshold(this.max, 255.0, 2);
        } else {
            imageProcessor.setThreshold(0.0, this.max, 2);
        }
    }

    void autoAdjust(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int[] nArray;
        if (this.RGBImage) {
            imageProcessor.reset();
        }
        Calibration calibration = imagePlus.getCalibration();
        imagePlus.setCalibration(null);
        ImageStatistics imageStatistics = imagePlus.getStatistics();
        imagePlus.setCalibration(calibration);
        int[] nArray2 = imageStatistics.histogram;
        this.autoThreshold = this.autoThreshold < 10 ? 5000 : (this.autoThreshold /= 2);
        int n = imageStatistics.pixelCount / this.autoThreshold;
        int n2 = -1;
        boolean bl = false;
        do {
            boolean bl2 = bl = nArray2[++n2] > n;
        } while (!bl && n2 < 255);
        int n3 = n2;
        n2 = 256;
        do {
            boolean bl3 = bl = nArray2[--n2] > n;
        } while (!bl && n2 > 0);
        int n4 = n2;
        if (n4 >= n3) {
            imagePlus.killRoi();
            this.min = imageStatistics.histMin + (double)n3 * imageStatistics.binSize;
            this.max = imageStatistics.histMin + (double)n4 * imageStatistics.binSize;
            if (this.min == this.max) {
                this.min = imageStatistics.min;
                this.max = imageStatistics.max;
            }
        } else {
            this.reset(imagePlus, imageProcessor);
            return;
        }
        this.setMinAndMax(imageProcessor, this.min, this.max);
        this.updateScrollBars(null);
        Roi roi = imagePlus.getRoi();
        if (roi != null && (nArray = roi.getMask()) != null) {
            imageProcessor.reset(nArray);
        }
    }

    void setMinAndMax(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.min = imageProcessor.getMin();
        this.max = imageProcessor.getMax();
        Calibration calibration = imagePlus.getCalibration();
        int n = imageProcessor instanceof FloatProcessor || calibration.calibrated() ? 2 : 0;
        double d = calibration.getCValue(this.min);
        double d2 = calibration.getCValue(this.max);
        GenericDialog genericDialog = new GenericDialog("Set Min and Max");
        genericDialog.addNumericField("Minimum Displayed Value: ", d, n);
        genericDialog.addNumericField("Maximum Displayed Value: ", d2, n);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        d = genericDialog.getNextNumber();
        d2 = genericDialog.getNextNumber();
        d = calibration.getRawValue(d);
        if ((d2 = calibration.getRawValue(d2)) >= d) {
            this.min = d;
            this.max = d2;
            this.setMinAndMax(imageProcessor, this.min, this.max);
            this.updateScrollBars(null);
            if (this.RGBImage) {
                this.doMasking(imagePlus, imageProcessor);
            }
            if (Recorder.record) {
                Recorder.record("setMinAndMax", (int)this.min, (int)this.max);
            }
        }
    }

    void setWindowLevel(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.min = imageProcessor.getMin();
        this.max = imageProcessor.getMax();
        Calibration calibration = imagePlus.getCalibration();
        int n = imageProcessor instanceof FloatProcessor || calibration.calibrated() ? 2 : 0;
        double d = calibration.getCValue(this.min);
        double d2 = calibration.getCValue(this.max);
        double d3 = d2 - d;
        double d4 = d + d3 / 2.0;
        GenericDialog genericDialog = new GenericDialog("Set W&L");
        genericDialog.addNumericField("Window Center (Level): ", d4, n);
        genericDialog.addNumericField("Window Width: ", d3, n);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        d4 = genericDialog.getNextNumber();
        d3 = genericDialog.getNextNumber();
        d = d4 - d3 / 2.0;
        d2 = d4 + d3 / 2.0;
        d = calibration.getRawValue(d);
        if ((d2 = calibration.getRawValue(d2)) >= d) {
            this.min = d;
            this.max = d2;
            this.setMinAndMax(imageProcessor, d, d2);
            this.updateScrollBars(null);
            if (this.RGBImage) {
                this.doMasking(imagePlus, imageProcessor);
            }
            if (Recorder.record) {
                Recorder.record("setMinAndMax", (int)this.min, (int)this.max);
            }
        }
    }

    public void run() {
        while (!this.done) {
            ContrastAdjuster contrastAdjuster = this;
            synchronized (contrastAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int n;
        int n2 = this.minSliderValue;
        int n3 = this.maxSliderValue;
        int n4 = this.brightnessValue;
        int n5 = this.contrastValue;
        if (this.doReset) {
            n = 0;
        } else if (this.doAutoAdjust) {
            n = 1;
        } else if (this.doSet) {
            n = 2;
        } else if (this.doApplyLut) {
            n = 3;
        } else if (this.doThreshold) {
            n = 4;
        } else if (this.doUpdate) {
            n = 9;
        } else if (this.minSliderValue >= 0) {
            n = 5;
        } else if (this.maxSliderValue >= 0) {
            n = 6;
        } else if (this.brightnessValue >= 0) {
            n = 7;
        } else if (this.contrastValue >= 0) {
            n = 8;
        } else {
            return;
        }
        this.contrastValue = -1;
        this.brightnessValue = -1;
        this.maxSliderValue = -1;
        this.minSliderValue = -1;
        this.doUpdate = false;
        this.doThreshold = false;
        this.doApplyLut = false;
        this.doSet = false;
        this.doAutoAdjust = false;
        this.doReset = false;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        ImageProcessor imageProcessor = n != 9 ? this.setup(imagePlus) : imagePlus.getProcessor();
        if (this.RGBImage && !imagePlus.lock()) {
            imagePlus = null;
            return;
        }
        switch (n) {
            case 0: {
                this.reset(imagePlus, imageProcessor);
                break;
            }
            case 1: {
                this.autoAdjust(imagePlus, imageProcessor);
                break;
            }
            case 2: {
                if (this.windowLevel) {
                    this.setWindowLevel(imagePlus, imageProcessor);
                    break;
                }
                this.setMinAndMax(imagePlus, imageProcessor);
                break;
            }
            case 3: {
                this.apply(imagePlus, imageProcessor);
                break;
            }
            case 4: {
                this.threshold(imagePlus, imageProcessor);
                break;
            }
            case 9: {
                this.update(imagePlus, imageProcessor);
                break;
            }
            case 5: {
                this.adjustMin(imagePlus, imageProcessor, n2);
                break;
            }
            case 6: {
                this.adjustMax(imagePlus, imageProcessor, n3);
                break;
            }
            case 7: {
                this.adjustBrightness(imagePlus, imageProcessor, n4);
                break;
            }
            case 8: {
                this.adjustContrast(imagePlus, imageProcessor, n5);
            }
        }
        this.updatePlot();
        this.updateLabels(imagePlus, imageProcessor);
        imagePlus.updateAndDraw();
        if (this.RGBImage) {
            imagePlus.unlock();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        instance = null;
        this.done = true;
        ContrastAdjuster contrastAdjuster = this;
        synchronized (contrastAdjuster) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.setup();
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        this.channels = channelConstants[this.choice.getSelectedIndex()];
        this.doReset = true;
        this.notify();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

