/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.macro.Interpreter;
import ij.macro.Program;
import ij.text.TextWindow;
import ij.util.Tools;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

class MacroExecuter
implements Runnable {
    private String macro;
    private Program pgm;
    private int address;
    private Thread thread;
    private boolean pushGlobals;

    MacroExecuter(String string) {
        this.macro = string;
        this.thread = new Thread((Runnable)this, "Macro");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    MacroExecuter(Program program, int n, String string) {
        this.pgm = program;
        this.address = n;
        this.thread = new Thread((Runnable)this, string);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    MacroExecuter(Program program, boolean bl) {
        this.pgm = program;
        this.pushGlobals = true;
        this.thread = new Thread((Runnable)this, "GlobalPusher");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void run() {
        block9: {
            try {
                if (this.pgm == null) {
                    new Interpreter().run(this.macro);
                } else if (this.pushGlobals) {
                    new Interpreter().pushGlobals(this.pgm);
                } else {
                    new Interpreter().runMacro(this.pgm, this.address);
                }
            }
            catch (Throwable throwable) {
                IJ.showStatus("");
                IJ.showProgress(1.0);
                ImagePlus imagePlus = WindowManager.getCurrentImage();
                if (imagePlus != null) {
                    imagePlus.unlock();
                }
                String string = throwable.getMessage();
                if (throwable instanceof RuntimeException && string != null && throwable.getMessage().equals("Macro canceled")) {
                    return;
                }
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                PrintWriter printWriter = new PrintWriter(charArrayWriter);
                throwable.printStackTrace(printWriter);
                String string2 = charArrayWriter.toString();
                if (IJ.isMacintosh()) {
                    string2 = Tools.fixNewLines(string2);
                }
                if (string2.indexOf("NullPointerException") >= 0 && string2.indexOf("ij.process") >= 0) break block9;
                new TextWindow("Exception", string2, 350, 250);
            }
        }
    }
}

