/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImageStack;
import ij.process.ImageProcessor;

public class StackProcessor {
    private ImageStack stack;
    private ImageProcessor ip;
    int nSlices;
    double xScale;
    double yScale;
    int[] table;
    static final int FLIPH = 0;
    static final int FLIPV = 1;
    static final int SCALE = 2;
    static final int INVERT = 3;
    static final int APPLY_TABLE = 4;

    public StackProcessor(ImageStack imageStack, ImageProcessor imageProcessor) {
        this.stack = imageStack;
        this.ip = imageProcessor;
        this.nSlices = imageStack.getSize();
        if (this.nSlices > 1) {
            imageProcessor.setProgressBar(null);
        }
    }

    void process(int n) {
        String string = "";
        switch (n) {
            case 0: 
            case 1: {
                string = "Flip: ";
                break;
            }
            case 2: {
                string = "Scale: ";
                break;
            }
            case 3: {
                string = "Invert: ";
                break;
            }
            case 4: {
                string = "Apply: ";
            }
        }
        ImageProcessor imageProcessor = this.stack.getProcessor(1);
        imageProcessor.setRoi(this.ip.getRoi());
        imageProcessor.setInterpolate(this.ip.getInterpolate());
        int n2 = 1;
        while (n2 <= this.nSlices) {
            this.showStatus(string, n2, this.nSlices);
            imageProcessor.setPixels(this.stack.getPixels(n2));
            if (this.nSlices == 1 && n2 == 1 && n == 2) {
                imageProcessor.snapshot();
            }
            switch (n) {
                case 0: {
                    imageProcessor.flipHorizontal();
                    break;
                }
                case 1: {
                    imageProcessor.flipVertical();
                    break;
                }
                case 2: {
                    imageProcessor.scale(this.xScale, this.yScale);
                    break;
                }
                case 3: {
                    imageProcessor.invert();
                    break;
                }
                case 4: {
                    imageProcessor.applyTable(this.table);
                }
            }
            IJ.showProgress((double)n2 / (double)this.nSlices);
            ++n2;
        }
        IJ.showProgress(1.0);
    }

    public void invert() {
        this.process(3);
    }

    public void flipHorizontal() {
        this.process(0);
    }

    public void flipVertical() {
        this.process(1);
    }

    public void applyTable(int[] nArray) {
        this.table = nArray;
        this.process(4);
    }

    public void scale(double d, double d2) {
        this.xScale = d;
        this.yScale = d2;
        this.process(2);
    }

    /*
     * Unable to fully structure code
     */
    public ImageStack resize(int var1_1, int var2_2) {
        block5: {
            var3_3 = new ImageStack(var1_1, var2_2);
            try {
                var5_4 = 1;
                while (var5_4 <= this.nSlices) {
                    this.showStatus("Resize: ", var5_4, this.nSlices);
                    this.ip.setPixels(this.stack.getPixels(1));
                    var6_7 = this.stack.getSliceLabel(1);
                    this.stack.deleteSlice(1);
                    var4_6 = this.ip.resize(var1_1, var2_2);
                    if (var4_6 != null) {
                        var3_3.addSlice(var6_7, var4_6);
                    }
                    IJ.showProgress((double)var5_4 / (double)this.nSlices);
                    ++var5_4;
                }
                IJ.showProgress(1.0);
                break block5;
            }
            catch (OutOfMemoryError var5_5) {
                ** while (this.stack.getSize() > 1)
            }
lbl-1000:
            // 1 sources

            {
                this.stack.deleteLastSlice();
                continue;
            }
lbl21:
            // 1 sources

            IJ.outOfMemory("StackProcessor.resize");
            IJ.showProgress(1.0);
        }
        return var3_3;
    }

    ImageStack rotate90Degrees(boolean bl) {
        ImageStack imageStack = new ImageStack(this.stack.getHeight(), this.stack.getWidth());
        int n = 1;
        while (n <= this.nSlices) {
            this.showStatus("Rotate: ", n, this.nSlices);
            this.ip.setPixels(this.stack.getPixels(1));
            String string = this.stack.getSliceLabel(1);
            this.stack.deleteSlice(1);
            ImageProcessor imageProcessor = bl ? this.ip.rotateRight() : this.ip.rotateLeft();
            if (imageProcessor != null) {
                imageStack.addSlice(string, imageProcessor);
            }
            IJ.showProgress((double)n / (double)this.nSlices);
            ++n;
        }
        IJ.showProgress(1.0);
        return imageStack;
    }

    public ImageStack rotateRight() {
        return this.rotate90Degrees(true);
    }

    public ImageStack rotateLeft() {
        return this.rotate90Degrees(false);
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        this.copyBits(imageProcessor, null, n, n2, n3);
    }

    public void copyBits(ImageStack imageStack, int n, int n2, int n3) {
        this.copyBits(null, imageStack, n, n2, n3);
    }

    private void copyBits(ImageProcessor imageProcessor, ImageStack imageStack, int n, int n2, int n3) {
        int n4 = this.nSlices / 20;
        if (n4 < 1) {
            n4 = 1;
        }
        boolean bl = imageProcessor == null;
        int n5 = 1;
        while (n5 <= this.nSlices) {
            if (bl) {
                imageProcessor = imageStack.getProcessor(n5);
            }
            ImageProcessor imageProcessor2 = this.stack.getProcessor(n5);
            imageProcessor2.copyBits(imageProcessor, n, n2, n3);
            if (n5 % n4 == 0) {
                IJ.showProgress((double)n5 / (double)this.nSlices);
            }
            ++n5;
        }
        IJ.showProgress(1.0);
    }

    void showStatus(String string, int n, int n2) {
        IJ.showStatus(string + n + "/" + n2);
    }
}

